/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Size64;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.AbstractCharList;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharComparator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharComparators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharListIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharSpliterators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharUnaryOperator;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.UnaryOperator;

public interface CharList
extends CharCollection,
Comparable<List<? extends Character>>,
List<Character> {
    @Override
    public CharListIterator iterator();

    @Override
    default public CharSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractCharList.IndexBasedSpliterator(this, 0);
        }
        return CharSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16720);
    }

    public CharListIterator listIterator();

    public CharListIterator listIterator(int var1);

    public CharList subList(int var1, int var2);

    public void getElements(int var1, char[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(char[] cArray) {
        this.setElements(0, cArray);
    }

    default public void setElements(int n2, char[] cArray) {
        this.setElements(n2, cArray, 0, cArray.length);
    }

    default public void setElements(int n2, char[] cArray, int n3, int n4) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
        CharArrays.ensureOffsetLength(cArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        CharListIterator charListIterator = this.listIterator(n2);
        int n5 = 0;
        while (n5 < n4) {
            charListIterator.nextChar();
            charListIterator.set(cArray[n3 + n5++]);
        }
    }

    @Override
    public boolean add(char var1);

    @Override
    public void add(int var1, char var2);

    @Override
    @Deprecated
    default public void add(int n2, Character c2) {
        this.add(n2, c2.charValue());
    }

    @Override
    public char set(int var1, char var2);

    default public void replaceAll(CharUnaryOperator charUnaryOperator) {
        CharListIterator charListIterator = this.listIterator();
        while (charListIterator.hasNext()) {
            charListIterator.set(charUnaryOperator.apply(charListIterator.nextChar()));
        }
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Character> unaryOperator) {
        Objects.requireNonNull(unaryOperator);
        this.replaceAll(unaryOperator instanceof CharUnaryOperator ? (CharUnaryOperator)unaryOperator : unaryOperator::apply);
    }

    public char getChar(int var1);

    public int indexOf(char var1);

    public int lastIndexOf(char var1);

    @Override
    @Deprecated
    default public boolean contains(Object object) {
        return CharCollection.super.contains(object);
    }

    @Override
    @Deprecated
    default public Character get(int n2) {
        return Character.valueOf(this.getChar(n2));
    }

    @Override
    @Deprecated
    default public int indexOf(Object object) {
        return this.indexOf(((Character)object).charValue());
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object object) {
        return this.lastIndexOf(((Character)object).charValue());
    }

    @Override
    @Deprecated
    default public boolean add(Character c2) {
        return this.add(c2.charValue());
    }

    public char removeChar(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object object) {
        return CharCollection.super.remove(object);
    }

    @Override
    @Deprecated
    default public Character remove(int n2) {
        return Character.valueOf(this.removeChar(n2));
    }

    @Override
    @Deprecated
    default public Character set(int n2, Character c2) {
        return Character.valueOf(this.set(n2, c2.charValue()));
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Character> comparator) {
        this.sort(CharComparators.asCharComparator(comparator));
    }

    default public void sort(CharComparator charComparator) {
        if (charComparator == null) {
            this.unstableSort(charComparator);
        } else {
            char[] cArray = this.toCharArray();
            CharArrays.stableSort(cArray, charComparator);
            this.setElements(cArray);
        }
    }

    default public void unstableSort(CharComparator charComparator) {
        char[] cArray = this.toCharArray();
        if (charComparator == null) {
            CharArrays.unstableSort(cArray);
        } else {
            CharArrays.unstableSort(cArray, charComparator);
        }
        this.setElements(cArray);
    }
}

