/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteConsumer;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteListIterator;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public final class ByteIterators {
    public static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    public static int unwrap(ByteIterator byteIterator, byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + n3 + ") is negative");
        }
        if (n2 < 0 || n2 + n3 > byArray.length) {
            throw new IllegalArgumentException();
        }
        int n4 = n3;
        while (n4-- != 0 && byteIterator.hasNext()) {
            byArray[n2++] = byteIterator.nextByte();
        }
        return n3 - n4 - 1;
    }

    public static int unwrap(ByteIterator byteIterator, byte[] byArray) {
        return ByteIterators.unwrap(byteIterator, byArray, 0, byArray.length);
    }

    public static class EmptyIterator
    implements ByteListIterator,
    Serializable,
    Cloneable {
        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public byte nextByte() {
            throw new NoSuchElementException();
        }

        @Override
        public byte previousByte() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void forEachRemaining(ByteConsumer byteConsumer) {
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Byte> consumer) {
        }

        public Object clone() {
            return EMPTY_ITERATOR;
        }
    }

    public static abstract class AbstractIndexBasedListIterator
    extends AbstractIndexBasedIterator
    implements ByteListIterator {
        protected AbstractIndexBasedListIterator(int n2, int n3) {
            super(n2, n3);
        }

        protected abstract void add(int var1, byte var2);

        protected abstract void set(int var1, byte var2);

        @Override
        public boolean hasPrevious() {
            return this.pos > this.minPos;
        }

        @Override
        public byte previousByte() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = --this.pos;
            return this.get(this.pos);
        }

        @Override
        public int nextIndex() {
            return this.pos;
        }

        @Override
        public int previousIndex() {
            return this.pos - 1;
        }

        @Override
        public void add(byte by2) {
            this.add(this.pos++, by2);
            this.lastReturned = -1;
        }

        @Override
        public void set(byte by2) {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            this.set(this.lastReturned, by2);
        }
    }

    public static abstract class AbstractIndexBasedIterator
    extends AbstractByteIterator {
        protected final int minPos;
        protected int pos;
        protected int lastReturned;

        protected AbstractIndexBasedIterator(int n2, int n3) {
            this.minPos = n2;
            this.pos = n3;
        }

        protected abstract byte get(int var1);

        protected abstract void remove(int var1);

        protected abstract int getMaxPos();

        @Override
        public boolean hasNext() {
            return this.pos < this.getMaxPos();
        }

        @Override
        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.pos++;
            return this.get(this.lastReturned);
        }

        @Override
        public void remove() {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            this.remove(this.lastReturned);
            if (this.lastReturned < this.pos) {
                --this.pos;
            }
            this.lastReturned = -1;
        }

        @Override
        public void forEachRemaining(ByteConsumer byteConsumer) {
            while (this.pos < this.getMaxPos()) {
                ++this.pos;
                this.lastReturned = this.lastReturned;
                byteConsumer.accept(this.get(this.lastReturned));
            }
        }
    }
}

