/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.internal;

import com.gradle.maven.extension.internal.dep.io.netty.util.internal.CleanableDirectBuffer;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.Cleaner;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent0;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class CleanerJava9
implements Cleaner {
    private static final InternalLogger logger;
    private static final MethodHandle INVOKE_CLEANER;

    CleanerJava9() {
    }

    static boolean isSupported() {
        return INVOKE_CLEANER != null;
    }

    @Override
    public CleanableDirectBuffer allocate(int n2) {
        return new CleanableDirectBufferImpl(ByteBuffer.allocateDirect(n2));
    }

    @Override
    @Deprecated
    public void freeDirectBuffer(ByteBuffer byteBuffer) {
        CleanerJava9.freeDirectBufferStatic(byteBuffer);
    }

    private static void freeDirectBufferStatic(ByteBuffer byteBuffer) {
        if (System.getSecurityManager() == null) {
            try {
                INVOKE_CLEANER.invokeExact(byteBuffer);
            }
            catch (Throwable throwable) {
                PlatformDependent0.throwException(throwable);
            }
        } else {
            CleanerJava9.freeDirectBufferPrivileged(byteBuffer);
        }
    }

    private static void freeDirectBufferPrivileged(final ByteBuffer byteBuffer) {
        Throwable throwable = AccessController.doPrivileged(new PrivilegedAction<Throwable>(){

            @Override
            public Throwable run() {
                try {
                    INVOKE_CLEANER.invokeExact(byteBuffer);
                }
                catch (Throwable throwable) {
                    return throwable;
                }
                return null;
            }
        });
        if (throwable != null) {
            PlatformDependent0.throwException(throwable);
        }
    }

    static {
        Throwable throwable;
        MethodHandle methodHandle;
        logger = InternalLoggerFactory.getInstance(CleanerJava9.class);
        if (PlatformDependent0.hasUnsafe()) {
            final ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
            Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Class<?> clazz = PlatformDependent0.UNSAFE.getClass();
                        MethodHandles.Lookup lookup = MethodHandles.lookup();
                        MethodHandle methodHandle = lookup.findVirtual(clazz, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
                        methodHandle = methodHandle.bindTo(PlatformDependent0.UNSAFE);
                        methodHandle.invokeExact(byteBuffer);
                        return methodHandle;
                    }
                    catch (Throwable throwable) {
                        return throwable;
                    }
                }
            });
            if (object instanceof Throwable) {
                methodHandle = null;
                throwable = (Throwable)object;
            } else {
                methodHandle = (MethodHandle)object;
                throwable = null;
            }
        } else {
            methodHandle = null;
            throwable = new UnsupportedOperationException("sun.misc.Unsafe unavailable");
        }
        if (throwable == null) {
            logger.debug("java.nio.ByteBuffer.cleaner(): available");
        } else {
            logger.debug("java.nio.ByteBuffer.cleaner(): unavailable", throwable);
        }
        INVOKE_CLEANER = methodHandle;
    }

    private static final class CleanableDirectBufferImpl
    implements CleanableDirectBuffer {
        private final ByteBuffer buffer;

        private CleanableDirectBufferImpl(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
        }

        @Override
        public ByteBuffer buffer() {
            return this.buffer;
        }

        @Override
        public void clean() {
            CleanerJava9.freeDirectBufferStatic(this.buffer);
        }
    }
}

