/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.concurrent;

import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.DefaultPromise;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.EventExecutorGroup;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FastThreadLocal;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.GlobalEventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.OrderedEventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.Promise;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.RejectedExecutionHandler;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.ScheduledFutureTask;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.ThreadProperties;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ThreadExecutorMap;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Async;

public abstract class SingleThreadEventExecutor
extends AbstractScheduledEventExecutor
implements OrderedEventExecutor {
    static final int DEFAULT_MAX_PENDING_EXECUTOR_TASKS = Math.max(16, SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.eventexecutor.maxPendingTasks", Integer.MAX_VALUE));
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SingleThreadEventExecutor.class);
    private static final Runnable NOOP_TASK = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final AtomicIntegerFieldUpdater<SingleThreadEventExecutor> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SingleThreadEventExecutor.class, "state");
    private static final AtomicReferenceFieldUpdater<SingleThreadEventExecutor, ThreadProperties> PROPERTIES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SingleThreadEventExecutor.class, ThreadProperties.class, "threadProperties");
    private static final AtomicLongFieldUpdater<SingleThreadEventExecutor> ACCUMULATED_ACTIVE_TIME_NANOS_UPDATER = AtomicLongFieldUpdater.newUpdater(SingleThreadEventExecutor.class, "accumulatedActiveTimeNanos");
    private static final AtomicIntegerFieldUpdater<SingleThreadEventExecutor> CONSECUTIVE_IDLE_CYCLES_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SingleThreadEventExecutor.class, "consecutiveIdleCycles");
    private static final AtomicIntegerFieldUpdater<SingleThreadEventExecutor> CONSECUTIVE_BUSY_CYCLES_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SingleThreadEventExecutor.class, "consecutiveBusyCycles");
    private final Queue<Runnable> taskQueue;
    private volatile Thread thread;
    private volatile ThreadProperties threadProperties;
    private final Executor executor;
    private volatile boolean interrupted;
    private final Lock processingLock = new ReentrantLock();
    private final CountDownLatch threadLock = new CountDownLatch(1);
    private final Set<Runnable> shutdownHooks = new LinkedHashSet<Runnable>();
    private final boolean addTaskWakesUp;
    private final int maxPendingTasks;
    private final RejectedExecutionHandler rejectedExecutionHandler;
    private final boolean supportSuspension;
    private volatile long accumulatedActiveTimeNanos;
    private volatile long lastActivityTimeNanos;
    private volatile int consecutiveIdleCycles;
    private volatile int consecutiveBusyCycles;
    private long lastExecutionTime;
    private volatile int state = 1;
    private volatile long gracefulShutdownQuietPeriod;
    private volatile long gracefulShutdownTimeout;
    private long gracefulShutdownStartTime;
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private static final long SCHEDULE_PURGE_INTERVAL = TimeUnit.SECONDS.toNanos(1L);

    protected SingleThreadEventExecutor(EventExecutorGroup eventExecutorGroup, Executor executor, boolean bl2, boolean bl3, int n2, RejectedExecutionHandler rejectedExecutionHandler) {
        super(eventExecutorGroup);
        this.addTaskWakesUp = bl2;
        this.supportSuspension = bl3;
        this.maxPendingTasks = Math.max(16, n2);
        this.executor = ThreadExecutorMap.apply(executor, (EventExecutor)this);
        this.taskQueue = this.newTaskQueue(this.maxPendingTasks);
        this.rejectedExecutionHandler = ObjectUtil.checkNotNull(rejectedExecutionHandler, "rejectedHandler");
        this.lastActivityTimeNanos = this.ticker().nanoTime();
    }

    protected Queue<Runnable> newTaskQueue(int n2) {
        return new LinkedBlockingQueue<Runnable>(n2);
    }

    protected Runnable pollTask() {
        assert (this.inEventLoop());
        return SingleThreadEventExecutor.pollTaskFrom(this.taskQueue);
    }

    protected static Runnable pollTaskFrom(Queue<Runnable> queue) {
        Runnable runnable;
        while ((runnable = queue.poll()) == WAKEUP_TASK) {
        }
        return runnable;
    }

    protected boolean hasTasks() {
        assert (this.inEventLoop());
        return !this.taskQueue.isEmpty();
    }

    protected void addTask(Runnable runnable) {
        ObjectUtil.checkNotNull(runnable, "task");
        if (!this.offerTask(runnable)) {
            this.reject(runnable);
        }
    }

    final boolean offerTask(Runnable runnable) {
        if (this.isShutdown()) {
            SingleThreadEventExecutor.reject();
        }
        return this.taskQueue.offer(runnable);
    }

    protected boolean removeTask(Runnable runnable) {
        return this.taskQueue.remove(ObjectUtil.checkNotNull(runnable, "task"));
    }

    protected boolean runAllTasks() {
        boolean bl2;
        assert (this.inEventLoop());
        boolean bl3 = false;
        do {
            bl2 = this.fetchFromScheduledTaskQueue(this.taskQueue);
            if (!this.runAllTasksFrom(this.taskQueue)) continue;
            bl3 = true;
        } while (!bl2);
        if (bl3) {
            this.lastExecutionTime = this.getCurrentTimeNanos();
        }
        this.afterRunningAllTasks();
        return bl3;
    }

    protected final boolean runAllTasksFrom(Queue<Runnable> queue) {
        Runnable runnable = SingleThreadEventExecutor.pollTaskFrom(queue);
        if (runnable == null) {
            return false;
        }
        do {
            SingleThreadEventExecutor.safeExecute(runnable);
        } while ((runnable = SingleThreadEventExecutor.pollTaskFrom(queue)) != null);
        return true;
    }

    protected boolean runAllTasks(long l2) {
        long l3;
        long l4;
        block2: {
            this.fetchFromScheduledTaskQueue(this.taskQueue);
            Runnable runnable = this.pollTask();
            if (runnable == null) {
                this.afterRunningAllTasks();
                return false;
            }
            long l5 = l2 > 0L ? this.getCurrentTimeNanos() + l2 : 0L;
            long l6 = 0L;
            l4 = this.ticker().nanoTime();
            do {
                SingleThreadEventExecutor.safeExecute(runnable);
                if ((++l6 & 0x3FL) == 0L && (l3 = this.getCurrentTimeNanos()) >= l5) break block2;
            } while ((runnable = this.pollTask()) != null);
            l3 = this.getCurrentTimeNanos();
        }
        long l7 = this.ticker().nanoTime();
        this.accumulatedActiveTimeNanos += l7 - l4;
        this.lastActivityTimeNanos = l7;
        this.afterRunningAllTasks();
        this.lastExecutionTime = l3;
        return true;
    }

    protected void afterRunningAllTasks() {
    }

    protected long delayNanos(long l2) {
        l2 -= this.ticker().initialNanoTime();
        ScheduledFutureTask<?> scheduledFutureTask = this.peekScheduledTask();
        if (scheduledFutureTask == null) {
            return SCHEDULE_PURGE_INTERVAL;
        }
        return scheduledFutureTask.delayNanos(l2);
    }

    protected void updateLastExecutionTime() {
        long l2;
        this.lastExecutionTime = l2 = this.getCurrentTimeNanos();
        this.lastActivityTimeNanos = l2;
    }

    protected void reportActiveIoTime(long l2) {
        assert (this.inEventLoop());
        if (l2 > 0L) {
            this.accumulatedActiveTimeNanos += l2;
            this.lastActivityTimeNanos = this.ticker().nanoTime();
        }
    }

    protected void resetIdleCycles() {
        CONSECUTIVE_IDLE_CYCLES_UPDATER.set(this, 0);
    }

    protected void resetBusyCycles() {
        CONSECUTIVE_BUSY_CYCLES_UPDATER.set(this, 0);
    }

    protected boolean isSuspensionSupported() {
        return this.supportSuspension;
    }

    protected abstract void run();

    protected void cleanup() {
    }

    protected void wakeup(boolean bl2) {
        if (!bl2) {
            this.taskQueue.offer(WAKEUP_TASK);
        }
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return thread == this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runShutdownHooks() {
        boolean bl2 = false;
        while (!this.shutdownHooks.isEmpty()) {
            ArrayList<Runnable> arrayList = new ArrayList<Runnable>(this.shutdownHooks);
            this.shutdownHooks.clear();
            for (Runnable runnable : arrayList) {
                try {
                    SingleThreadEventExecutor.runTask(runnable);
                }
                catch (Throwable throwable) {
                    logger.warn("Shutdown hook raised an exception.", throwable);
                }
                finally {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            this.lastExecutionTime = this.getCurrentTimeNanos();
        }
        return bl2;
    }

    private void shutdown0(long l2, long l3, int n2) {
        boolean bl2;
        int n3;
        int n4;
        if (this.isShuttingDown()) {
            return;
        }
        boolean bl3 = this.inEventLoop();
        do {
            if (this.isShuttingDown()) {
                return;
            }
            bl2 = true;
            n4 = this.state;
            if (bl3) {
                n3 = n2;
                continue;
            }
            switch (n4) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n3 = n2;
                    break;
                }
                default: {
                    n3 = n4;
                    bl2 = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, n4, n3));
        if (l2 != -1L) {
            this.gracefulShutdownQuietPeriod = l2;
        }
        if (l3 != -1L) {
            this.gracefulShutdownTimeout = l3;
        }
        if (this.ensureThreadStarted(n4)) {
            return;
        }
        if (bl2) {
            this.taskQueue.offer(WAKEUP_TASK);
            if (!this.addTaskWakesUp) {
                this.wakeup(bl3);
            }
        }
    }

    @Override
    public Future<?> shutdownGracefully(long l2, long l3, TimeUnit timeUnit) {
        ObjectUtil.checkPositiveOrZero(l2, "quietPeriod");
        if (l3 < l2) {
            throw new IllegalArgumentException("timeout: " + l3 + " (expected >= quietPeriod (" + l2 + "))");
        }
        ObjectUtil.checkNotNull(timeUnit, "unit");
        this.shutdown0(timeUnit.toNanos(l2), timeUnit.toNanos(l3), 5);
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        this.shutdown0(-1L, -1L, 6);
    }

    @Override
    public boolean isShuttingDown() {
        return this.state >= 5;
    }

    @Override
    public boolean isShutdown() {
        return this.state >= 6;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 7;
    }

    public boolean trySuspend() {
        if (this.supportSuspension) {
            if (STATE_UPDATER.compareAndSet(this, 4, 2)) {
                this.wakeup(this.inEventLoop());
                return true;
            }
            if (STATE_UPDATER.compareAndSet(this, 1, 3)) {
                return true;
            }
            int n2 = this.state;
            return n2 == 3 || n2 == 2;
        }
        return false;
    }

    protected boolean canSuspend() {
        return this.canSuspend(this.state);
    }

    protected boolean canSuspend(int n2) {
        assert (this.inEventLoop());
        return this.supportSuspension && (n2 == 3 || n2 == 2) && !this.hasTasks() && this.nextScheduledTaskDeadlineNanos() == -1L;
    }

    protected boolean confirmShutdown() {
        if (!this.isShuttingDown()) {
            return false;
        }
        if (!this.inEventLoop()) {
            throw new IllegalStateException("must be invoked from an event loop");
        }
        this.cancelScheduledTasks();
        if (this.gracefulShutdownStartTime == 0L) {
            this.gracefulShutdownStartTime = this.getCurrentTimeNanos();
        }
        if (this.runAllTasks() || this.runShutdownHooks()) {
            if (this.isShutdown()) {
                return true;
            }
            if (this.gracefulShutdownQuietPeriod == 0L) {
                return true;
            }
            this.taskQueue.offer(WAKEUP_TASK);
            return false;
        }
        long l2 = this.getCurrentTimeNanos();
        if (this.isShutdown() || l2 - this.gracefulShutdownStartTime > this.gracefulShutdownTimeout) {
            return true;
        }
        if (l2 - this.lastExecutionTime <= this.gracefulShutdownQuietPeriod) {
            this.taskQueue.offer(WAKEUP_TASK);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) throws InterruptedException {
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (this.inEventLoop()) {
            throw new IllegalStateException("cannot await termination of the current thread");
        }
        this.threadLock.await(l2, timeUnit);
        return this.isTerminated();
    }

    @Override
    public void execute(Runnable runnable) {
        this.execute0(runnable);
    }

    @Override
    public void lazyExecute(Runnable runnable) {
        this.lazyExecute0(runnable);
    }

    private void execute0(@Async.Schedule Runnable runnable) {
        ObjectUtil.checkNotNull(runnable, "task");
        this.execute(runnable, this.wakesUpForTask(runnable));
    }

    private void lazyExecute0(@Async.Schedule Runnable runnable) {
        this.execute(ObjectUtil.checkNotNull(runnable, "task"), false);
    }

    @Override
    void scheduleRemoveScheduled(final ScheduledFutureTask<?> scheduledFutureTask) {
        ObjectUtil.checkNotNull(scheduledFutureTask, "task");
        int n2 = this.state;
        if (this.supportSuspension && n2 == 3) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    scheduledFutureTask.run();
                    if (SingleThreadEventExecutor.this.canSuspend(3)) {
                        SingleThreadEventExecutor.this.trySuspend();
                    }
                }
            }, true);
        } else {
            this.execute(scheduledFutureTask, false);
        }
    }

    private void execute(Runnable runnable, boolean bl2) {
        boolean bl3 = this.inEventLoop();
        this.addTask(runnable);
        if (!bl3) {
            this.startThread();
            if (this.isShutdown()) {
                boolean bl4 = false;
                try {
                    if (this.removeTask(runnable)) {
                        bl4 = true;
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                if (bl4) {
                    SingleThreadEventExecutor.reject();
                }
            }
        }
        if (!this.addTaskWakesUp && bl2) {
            this.wakeup(bl3);
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(collection);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(collection, l2, timeUnit);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(collection);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException {
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(collection, l2, timeUnit);
    }

    private void throwIfInEventLoop(String string) {
        if (this.inEventLoop()) {
            throw new RejectedExecutionException("Calling " + string + " from within the EventLoop is not allowed");
        }
    }

    protected boolean wakesUpForTask(Runnable runnable) {
        return true;
    }

    protected static void reject() {
        throw new RejectedExecutionException("event executor terminated");
    }

    protected final void reject(Runnable runnable) {
        this.rejectedExecutionHandler.rejected(runnable, this);
    }

    private void startThread() {
        int n2 = this.state;
        if ((n2 == 1 || n2 == 3) && STATE_UPDATER.compareAndSet(this, n2, 4)) {
            this.resetIdleCycles();
            this.resetBusyCycles();
            boolean bl2 = false;
            try {
                this.doStartThread();
                bl2 = true;
            }
            finally {
                if (!bl2) {
                    STATE_UPDATER.compareAndSet(this, 4, 1);
                }
            }
        }
    }

    private boolean ensureThreadStarted(int n2) {
        if (n2 == 1 || n2 == 3) {
            try {
                this.doStartThread();
            }
            catch (Throwable throwable) {
                STATE_UPDATER.set(this, 7);
                this.terminationFuture.tryFailure(throwable);
                if (!(throwable instanceof Exception)) {
                    PlatformDependent.throwException(throwable);
                }
                return true;
            }
        }
        return false;
    }

    private void doStartThread() {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                int n2;
                int n3;
                boolean bl2;
                Throwable throwable;
                boolean bl3;
                block73: {
                    SingleThreadEventExecutor.this.processingLock.lock();
                    assert (SingleThreadEventExecutor.this.thread == null);
                    SingleThreadEventExecutor.this.thread = Thread.currentThread();
                    if (SingleThreadEventExecutor.this.interrupted) {
                        SingleThreadEventExecutor.this.thread.interrupt();
                        SingleThreadEventExecutor.this.interrupted = false;
                    }
                    bl3 = false;
                    throwable = null;
                    SingleThreadEventExecutor.this.updateLastExecutionTime();
                    bl2 = false;
                    do {
                        SingleThreadEventExecutor.this.run();
                        bl3 = true;
                        n3 = SingleThreadEventExecutor.this.state;
                        if (!SingleThreadEventExecutor.this.canSuspend(n3)) break block73;
                    } while (!STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, 2, 3) || !SingleThreadEventExecutor.this.canSuspend(3) && STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, 3, 4));
                    bl2 = true;
                }
                int n4 = n3 = !bl2 ? 1 : 0;
                if (n3 != 0) {
                    while ((n2 = SingleThreadEventExecutor.this.state) < 5 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n2, 5)) {
                    }
                    if (bl3 && SingleThreadEventExecutor.this.gracefulShutdownStartTime == 0L && logger.isErrorEnabled()) {
                        logger.error("Buggy " + EventExecutor.class.getSimpleName() + " implementation; " + SingleThreadEventExecutor.class.getSimpleName() + ".confirmShutdown() must be called before run() implementation terminates.");
                    }
                }
                try {
                    if (n3 == 0) return;
                    while (!SingleThreadEventExecutor.this.confirmShutdown()) {
                    }
                    while ((n2 = SingleThreadEventExecutor.this.state) < 6 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n2, 6)) {
                    }
                    SingleThreadEventExecutor.this.confirmShutdown();
                    return;
                }
                finally {
                    block74: {
                        try {
                            if (n3 != 0) {
                                try {
                                    SingleThreadEventExecutor.this.cleanup();
                                    break block74;
                                }
                                finally {
                                    FastThreadLocal.removeAll();
                                    STATE_UPDATER.set(SingleThreadEventExecutor.this, 7);
                                    SingleThreadEventExecutor.this.threadLock.countDown();
                                    n2 = SingleThreadEventExecutor.this.drainTasks();
                                    if (n2 > 0 && logger.isWarnEnabled()) {
                                        logger.warn("An event executor terminated with non-empty task queue (" + n2 + ')');
                                    }
                                    if (throwable == null) {
                                        SingleThreadEventExecutor.this.terminationFuture.setSuccess(null);
                                    } else {
                                        SingleThreadEventExecutor.this.terminationFuture.setFailure(throwable);
                                    }
                                }
                            }
                            FastThreadLocal.removeAll();
                            SingleThreadEventExecutor.this.threadProperties = null;
                        }
                        finally {
                            SingleThreadEventExecutor.this.thread = null;
                            SingleThreadEventExecutor.this.processingLock.unlock();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    int n5;
                    boolean bl4;
                    throwable = throwable2;
                    logger.warn("Unexpected exception from an event executor: ", throwable2);
                    boolean bl5 = bl4 = !bl2;
                    if (bl4) {
                        while ((n5 = SingleThreadEventExecutor.this.state) < 5 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n5, 5)) {
                        }
                        if (bl3 && SingleThreadEventExecutor.this.gracefulShutdownStartTime == 0L && logger.isErrorEnabled()) {
                            logger.error("Buggy " + EventExecutor.class.getSimpleName() + " implementation; " + SingleThreadEventExecutor.class.getSimpleName() + ".confirmShutdown() must be called before run() implementation terminates.");
                        }
                    }
                    try {
                        if (!bl4) return;
                        while (!SingleThreadEventExecutor.this.confirmShutdown()) {
                        }
                        while ((n5 = SingleThreadEventExecutor.this.state) < 6 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n5, 6)) {
                        }
                        SingleThreadEventExecutor.this.confirmShutdown();
                        return;
                    }
                    finally {
                        block75: {
                            try {
                                if (bl4) {
                                    try {
                                        SingleThreadEventExecutor.this.cleanup();
                                        break block75;
                                    }
                                    finally {
                                        FastThreadLocal.removeAll();
                                        STATE_UPDATER.set(SingleThreadEventExecutor.this, 7);
                                        SingleThreadEventExecutor.this.threadLock.countDown();
                                        n5 = SingleThreadEventExecutor.this.drainTasks();
                                        if (n5 > 0 && logger.isWarnEnabled()) {
                                            logger.warn("An event executor terminated with non-empty task queue (" + n5 + ')');
                                        }
                                        if (throwable == null) {
                                            SingleThreadEventExecutor.this.terminationFuture.setSuccess(null);
                                        } else {
                                            SingleThreadEventExecutor.this.terminationFuture.setFailure(throwable);
                                        }
                                    }
                                }
                                FastThreadLocal.removeAll();
                                SingleThreadEventExecutor.this.threadProperties = null;
                            }
                            finally {
                                SingleThreadEventExecutor.this.thread = null;
                                SingleThreadEventExecutor.this.processingLock.unlock();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        int n6;
                        boolean bl6;
                        boolean bl7 = bl6 = !bl2;
                        if (bl6) {
                            while ((n6 = SingleThreadEventExecutor.this.state) < 5 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n6, 5)) {
                            }
                            if (bl3 && SingleThreadEventExecutor.this.gracefulShutdownStartTime == 0L && logger.isErrorEnabled()) {
                                logger.error("Buggy " + EventExecutor.class.getSimpleName() + " implementation; " + SingleThreadEventExecutor.class.getSimpleName() + ".confirmShutdown() must be called before run() implementation terminates.");
                            }
                        }
                        try {
                            if (!bl6) throw throwable3;
                            while (!SingleThreadEventExecutor.this.confirmShutdown()) {
                            }
                            while ((n6 = SingleThreadEventExecutor.this.state) < 6 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n6, 6)) {
                            }
                            SingleThreadEventExecutor.this.confirmShutdown();
                            throw throwable3;
                        }
                        finally {
                            block76: {
                                try {
                                    if (bl6) {
                                        try {
                                            SingleThreadEventExecutor.this.cleanup();
                                            break block76;
                                        }
                                        finally {
                                            FastThreadLocal.removeAll();
                                            STATE_UPDATER.set(SingleThreadEventExecutor.this, 7);
                                            SingleThreadEventExecutor.this.threadLock.countDown();
                                            n6 = SingleThreadEventExecutor.this.drainTasks();
                                            if (n6 > 0 && logger.isWarnEnabled()) {
                                                logger.warn("An event executor terminated with non-empty task queue (" + n6 + ')');
                                            }
                                            if (throwable == null) {
                                                SingleThreadEventExecutor.this.terminationFuture.setSuccess(null);
                                            } else {
                                                SingleThreadEventExecutor.this.terminationFuture.setFailure(throwable);
                                            }
                                        }
                                    }
                                    FastThreadLocal.removeAll();
                                    SingleThreadEventExecutor.this.threadProperties = null;
                                }
                                finally {
                                    SingleThreadEventExecutor.this.thread = null;
                                    SingleThreadEventExecutor.this.processingLock.unlock();
                                }
                            }
                        }
                    }
                }
            }
        });
    }

    final int drainTasks() {
        Runnable runnable;
        int n2 = 0;
        while ((runnable = this.taskQueue.poll()) != null) {
            if (WAKEUP_TASK == runnable) continue;
            ++n2;
        }
        return n2;
    }
}

