/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util;

import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FastThreadLocal;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FastThreadLocalThread;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectPool;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class Recycler<T> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Recycler.class);
    private static final EnhancedHandle<?> NOOP_HANDLE = new LocalPoolHandle(null);
    private static final UnguardedLocalPool<?> NOOP_LOCAL_POOL = new UnguardedLocalPool(0);
    private static final int DEFAULT_MAX_CAPACITY_PER_THREAD;
    private static final int RATIO;
    private static final int DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD;
    private static final boolean BLOCKING_POOL;
    private static final boolean BATCH_FAST_TL_ONLY;
    private final LocalPool<?, T> localPool;
    private final FastThreadLocal<LocalPool<?, T>> threadLocalPool;

    protected Recycler(int n2) {
        this(n2, RATIO, DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
    }

    protected Recycler() {
        this(DEFAULT_MAX_CAPACITY_PER_THREAD);
    }

    protected Recycler(int n2, int n3, int n4) {
        this(n2, n3, n4, true, null, false);
    }

    private Recycler(int n2, int n3, int n4, boolean bl2, Thread thread, final boolean bl3) {
        final int n5 = Math.max(0, n3);
        if (n2 <= 0) {
            n2 = 0;
            n4 = 0;
        } else {
            n2 = Math.max(4, n2);
            n4 = Math.max(2, Math.min(n4, n2 >> 1));
        }
        if (n2 > 0 && bl2) {
            final int n6 = n2;
            final int n7 = n4;
            this.threadLocalPool = new FastThreadLocal<LocalPool<?, T>>(){

                @Override
                protected LocalPool<?, T> initialValue() {
                    return bl3 ? new UnguardedLocalPool(n6, n5, n7) : new GuardedLocalPool(n6, n5, n7);
                }

                @Override
                protected void onRemoval(LocalPool<?, T> localPool) throws Exception {
                    super.onRemoval(localPool);
                    MessagePassingQueue messagePassingQueue = localPool.pooledHandles;
                    localPool.pooledHandles = null;
                    localPool.owner = null;
                    if (messagePassingQueue != null) {
                        messagePassingQueue.clear();
                    }
                }
            };
            this.localPool = null;
        } else {
            this.threadLocalPool = null;
            if (n2 == 0) {
                this.localPool = NOOP_LOCAL_POOL;
            } else {
                Objects.requireNonNull(thread, "owner");
                this.localPool = bl3 ? new UnguardedLocalPool(thread, n2, n5, n4) : new GuardedLocalPool(thread, n2, n5, n4);
            }
        }
    }

    public final T get() {
        if (this.localPool != null) {
            return this.localPool.getWith(this);
        }
        if (PlatformDependent.isVirtualThread(Thread.currentThread()) && !FastThreadLocalThread.currentThreadHasFastThreadLocal()) {
            return (T)this.newObject(NOOP_HANDLE);
        }
        return this.threadLocalPool.get().getWith(this);
    }

    protected abstract T newObject(Handle<T> var1);

    static {
        int n2 = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.recycler.maxCapacityPerThread", SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.recycler.maxCapacity", 4096));
        if (n2 < 0) {
            n2 = 4096;
        }
        DEFAULT_MAX_CAPACITY_PER_THREAD = n2;
        DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.recycler.chunkSize", 32);
        RATIO = Math.max(0, SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.recycler.ratio", 8));
        BLOCKING_POOL = SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.recycler.blocking", false);
        BATCH_FAST_TL_ONLY = SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.recycler.batchFastThreadLocalOnly", true);
        if (logger.isDebugEnabled()) {
            if (DEFAULT_MAX_CAPACITY_PER_THREAD == 0) {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: disabled");
                logger.debug("-Dio.netty.recycler.ratio: disabled");
                logger.debug("-Dio.netty.recycler.chunkSize: disabled");
                logger.debug("-Dio.netty.recycler.blocking: disabled");
                logger.debug("-Dio.netty.recycler.batchFastThreadLocalOnly: disabled");
            } else {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: {}", (Object)DEFAULT_MAX_CAPACITY_PER_THREAD);
                logger.debug("-Dio.netty.recycler.ratio: {}", (Object)RATIO);
                logger.debug("-Dio.netty.recycler.chunkSize: {}", (Object)DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
                logger.debug("-Dio.netty.recycler.blocking: {}", (Object)BLOCKING_POOL);
                logger.debug("-Dio.netty.recycler.batchFastThreadLocalOnly: {}", (Object)BATCH_FAST_TL_ONLY);
            }
        }
    }

    private static final class BlockingMessageQueue<T>
    implements MessagePassingQueue<T> {
        private final Queue<T> deque;
        private final int maxCapacity;

        BlockingMessageQueue(int n2) {
            this.maxCapacity = n2;
            this.deque = new ArrayDeque<T>();
        }

        public synchronized boolean offer(T t2) {
            if (this.deque.size() == this.maxCapacity) {
                return false;
            }
            return this.deque.offer(t2);
        }

        public synchronized T poll() {
            return this.deque.poll();
        }

        @Override
        public synchronized void clear() {
            this.deque.clear();
        }

        @Override
        public boolean relaxedOffer(T t2) {
            return this.offer(t2);
        }

        @Override
        public T relaxedPoll() {
            return this.poll();
        }
    }

    private static abstract class LocalPool<H, T> {
        private final int ratioInterval;
        private final H[] batch;
        private int batchSize;
        private Thread owner;
        private MessagePassingQueue<H> pooledHandles;
        private int ratioCounter;

        LocalPool(int n2) {
            this.ratioInterval = n2 == 0 ? -1 : 0;
            this.owner = null;
            this.batch = null;
            this.batchSize = 0;
            this.pooledHandles = LocalPool.createExternalMcPool(n2);
            this.ratioCounter = 0;
        }

        LocalPool(Thread thread, int n2, int n3, int n4) {
            this.ratioInterval = n3;
            this.owner = thread;
            this.batch = thread != null ? new Object[n4] : null;
            this.batchSize = 0;
            this.pooledHandles = LocalPool.createExternalScPool(n4, n2);
            this.ratioCounter = n3;
        }

        private static <H> MessagePassingQueue<H> createExternalMcPool(int n2) {
            if (n2 == 0) {
                return null;
            }
            if (BLOCKING_POOL) {
                return new BlockingMessageQueue(n2);
            }
            return (MessagePassingQueue)((Object)PlatformDependent.newFixedMpmcQueue(n2));
        }

        private static <H> MessagePassingQueue<H> createExternalScPool(int n2, int n3) {
            if (n3 == 0) {
                return null;
            }
            if (BLOCKING_POOL) {
                return new BlockingMessageQueue(n3);
            }
            return (MessagePassingQueue)((Object)PlatformDependent.newMpscQueue(n2, n3));
        }

        LocalPool(int n2, int n3, int n4) {
            this(!BATCH_FAST_TL_ONLY || FastThreadLocalThread.currentThreadHasFastThreadLocal() ? Thread.currentThread() : null, n2, n3, n4);
        }

        protected final H acquire() {
            int n2 = this.batchSize;
            if (n2 == 0) {
                MessagePassingQueue<H> messagePassingQueue = this.pooledHandles;
                if (messagePassingQueue == null) {
                    return null;
                }
                return messagePassingQueue.relaxedPoll();
            }
            int n3 = n2 - 1;
            H h2 = this.batch[n3];
            this.batchSize = n3;
            this.batch[n3] = null;
            return h2;
        }

        protected final void release(H h2) {
            Thread thread = this.owner;
            if (thread != null && Thread.currentThread() == thread && this.batchSize < this.batch.length) {
                this.batch[this.batchSize] = h2;
                ++this.batchSize;
            } else if (thread != null && LocalPool.isTerminated(thread)) {
                this.pooledHandles = null;
                this.owner = null;
            } else {
                MessagePassingQueue<H> messagePassingQueue = this.pooledHandles;
                if (messagePassingQueue != null) {
                    messagePassingQueue.relaxedOffer(h2);
                }
            }
        }

        private static boolean isTerminated(Thread thread) {
            return PlatformDependent.isJ9Jvm() ? !thread.isAlive() : thread.getState() == Thread.State.TERMINATED;
        }

        boolean canAllocatePooled() {
            if (this.ratioInterval < 0) {
                return false;
            }
            if (this.ratioInterval == 0) {
                return true;
            }
            if (++this.ratioCounter >= this.ratioInterval) {
                this.ratioCounter = 0;
                return true;
            }
            return false;
        }

        abstract T getWith(Recycler<T> var1);
    }

    private static final class UnguardedLocalPool<T>
    extends LocalPool<T, T> {
        private final EnhancedHandle<T> handle;

        UnguardedLocalPool(int n2) {
            super(n2);
            this.handle = n2 == 0 ? null : new LocalPoolHandle(this);
        }

        UnguardedLocalPool(Thread thread, int n2, int n3, int n4) {
            super(thread, n2, n3, n4);
            this.handle = new LocalPoolHandle(this);
        }

        UnguardedLocalPool(int n2, int n3, int n4) {
            super(n2, n3, n4);
            this.handle = new LocalPoolHandle(this);
        }

        @Override
        public T getWith(Recycler<T> recycler) {
            Object object = this.acquire();
            if (object == null) {
                object = recycler.newObject(this.canAllocatePooled() ? this.handle : NOOP_HANDLE);
            }
            return (T)object;
        }
    }

    private static final class GuardedLocalPool<T>
    extends LocalPool<DefaultHandle<T>, T> {
        GuardedLocalPool(Thread thread, int n2, int n3, int n4) {
            super(thread, n2, n3, n4);
        }

        GuardedLocalPool(int n2, int n3, int n4) {
            super(n2, n3, n4);
        }

        @Override
        public T getWith(Recycler<T> recycler) {
            Object t2;
            DefaultHandle defaultHandle = (DefaultHandle)this.acquire();
            if (defaultHandle == null) {
                DefaultHandle defaultHandle2 = defaultHandle = this.canAllocatePooled() ? new DefaultHandle(this) : null;
                if (defaultHandle != null) {
                    t2 = recycler.newObject(defaultHandle);
                    defaultHandle.set(t2);
                } else {
                    t2 = recycler.newObject(NOOP_HANDLE);
                }
            } else {
                t2 = defaultHandle.claim();
            }
            return t2;
        }
    }

    private static final class DefaultHandle<T>
    extends EnhancedHandle<T> {
        private static final AtomicIntegerFieldUpdater<DefaultHandle<?>> STATE_UPDATER;
        private volatile int state;
        private final GuardedLocalPool<T> localPool;
        private T value;

        DefaultHandle(GuardedLocalPool<T> guardedLocalPool) {
            this.localPool = guardedLocalPool;
        }

        @Override
        public void recycle(Object object) {
            if (object != this.value) {
                throw new IllegalArgumentException("object does not belong to handle");
            }
            this.toAvailable();
            this.localPool.release(this);
        }

        @Override
        public void unguardedRecycle(Object object) {
            if (object != this.value) {
                throw new IllegalArgumentException("object does not belong to handle");
            }
            this.unguardedToAvailable();
            this.localPool.release(this);
        }

        T claim() {
            assert (this.state == 1);
            STATE_UPDATER.lazySet(this, 0);
            return this.value;
        }

        void set(T t2) {
            this.value = t2;
        }

        private void toAvailable() {
            int n2 = STATE_UPDATER.getAndSet(this, 1);
            if (n2 == 1) {
                throw new IllegalStateException("Object has been recycled already.");
            }
        }

        private void unguardedToAvailable() {
            int n2 = this.state;
            if (n2 == 1) {
                throw new IllegalStateException("Object has been recycled already.");
            }
            STATE_UPDATER.lazySet(this, 1);
        }

        static {
            AtomicIntegerFieldUpdater<DefaultHandle> atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultHandle.class, "state");
            STATE_UPDATER = atomicIntegerFieldUpdater;
        }
    }

    public static abstract class EnhancedHandle<T>
    implements Handle<T> {
        public abstract void unguardedRecycle(Object var1);

        private EnhancedHandle() {
        }
    }

    public static interface Handle<T>
    extends ObjectPool.Handle<T> {
    }

    private static final class LocalPoolHandle<T>
    extends EnhancedHandle<T> {
        private final UnguardedLocalPool<T> pool;

        private LocalPoolHandle(UnguardedLocalPool<T> unguardedLocalPool) {
            this.pool = unguardedLocalPool;
        }

        @Override
        public void recycle(T t2) {
            UnguardedLocalPool<T> unguardedLocalPool = this.pool;
            if (unguardedLocalPool != null) {
                unguardedLocalPool.release(t2);
            }
        }

        @Override
        public void unguardedRecycle(Object object) {
            UnguardedLocalPool<T> unguardedLocalPool = this.pool;
            if (unguardedLocalPool != null) {
                unguardedLocalPool.release(object);
            }
        }
    }
}

