/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util;

import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import java.util.Locale;

public final class NettyRuntime {
    private static final AvailableProcessorsHolder holder = new AvailableProcessorsHolder();

    public static int availableProcessors() {
        return holder.availableProcessors();
    }

    static class AvailableProcessorsHolder {
        private int availableProcessors;

        AvailableProcessorsHolder() {
        }

        synchronized void setAvailableProcessors(int n2) {
            ObjectUtil.checkPositive(n2, "availableProcessors");
            if (this.availableProcessors != 0) {
                String string = String.format(Locale.ROOT, "availableProcessors is already set to [%d], rejecting [%d]", this.availableProcessors, n2);
                throw new IllegalStateException(string);
            }
            this.availableProcessors = n2;
        }

        synchronized int availableProcessors() {
            if (this.availableProcessors == 0) {
                int n2 = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.availableProcessors", Runtime.getRuntime().availableProcessors());
                this.setAvailableProcessors(n2);
            }
            return this.availableProcessors;
        }
    }
}

