/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.ssl;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.AsyncRunnable;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.CipherSuiteConverter;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.ClientAuth;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.ExtendedOpenSslSession;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.GroupsConverter;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.NotSslRecordException;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSsl;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslInternalSession;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslParametersUtil;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslSessionContext;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslSessionId;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.SignatureAlgorithmConverter;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.SslUtils;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.util.LazyJavaxX509Certificate;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.util.LazyX509Certificate;
import com.gradle.maven.extension.internal.dep.io.netty.internal.tcnative.AsyncTask;
import com.gradle.maven.extension.internal.dep.io.netty.internal.tcnative.Buffer;
import com.gradle.maven.extension.internal.dep.io.netty.internal.tcnative.SSL;
import com.gradle.maven.extension.internal.dep.io.netty.util.AbstractReferenceCounted;
import com.gradle.maven.extension.internal.dep.io.netty.util.CharsetUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCounted;
import com.gradle.maven.extension.internal.dep.io.netty.util.ResourceLeakDetector;
import com.gradle.maven.extension.internal.dep.io.netty.util.ResourceLeakDetectorFactory;
import com.gradle.maven.extension.internal.dep.io.netty.util.ResourceLeakTracker;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.EmptyArrays;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ThrowableUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AlgorithmConstraints;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.security.cert.X509Certificate;

public class ReferenceCountedOpenSslEngine
extends SSLEngine
implements ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslEngine.class);
    private static final ResourceLeakDetector<ReferenceCountedOpenSslEngine> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslEngine.class);
    private static final int[] OPENSSL_OP_NO_PROTOCOLS = new int[]{SSL.SSL_OP_NO_SSLv2, SSL.SSL_OP_NO_SSLv3, SSL.SSL_OP_NO_TLSv1, SSL.SSL_OP_NO_TLSv1_1, SSL.SSL_OP_NO_TLSv1_2, SSL.SSL_OP_NO_TLSv1_3};
    static final int MAX_PLAINTEXT_LENGTH = SSL.SSL_MAX_PLAINTEXT_LENGTH;
    static final int MAX_RECORD_SIZE = SSL.SSL_MAX_RECORD_LENGTH;
    private static final SSLEngineResult NEED_UNWRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_UNWRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult CLOSED_NOT_HANDSHAKING = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
    private long ssl;
    private long networkBIO;
    private HandshakeState handshakeState = HandshakeState.NOT_STARTED;
    private boolean receivedShutdown;
    private volatile boolean destroyed;
    private volatile String applicationProtocol;
    private volatile boolean needTask;
    private boolean hasTLSv13Cipher;
    private boolean sessionSet;
    private final ResourceLeakTracker<ReferenceCountedOpenSslEngine> leak;
    private final AbstractReferenceCounted refCnt = new AbstractReferenceCounted(){

        @Override
        public ReferenceCounted touch(Object object) {
            if (ReferenceCountedOpenSslEngine.this.leak != null) {
                ReferenceCountedOpenSslEngine.this.leak.record(object);
            }
            return ReferenceCountedOpenSslEngine.this;
        }

        @Override
        protected void deallocate() {
            ReferenceCountedOpenSslEngine.this.shutdown();
            if (ReferenceCountedOpenSslEngine.this.leak != null) {
                boolean bl2 = ReferenceCountedOpenSslEngine.this.leak.close(ReferenceCountedOpenSslEngine.this);
                assert (bl2);
            }
            ReferenceCountedOpenSslEngine.this.parentContext.release();
        }
    };
    private final Set<String> enabledProtocols = new LinkedHashSet<String>();
    private volatile ClientAuth clientAuth = ClientAuth.NONE;
    private String endpointIdentificationAlgorithm;
    private List<SNIServerName> serverNames;
    private String[] groups;
    private AlgorithmConstraints algorithmConstraints;
    private volatile Collection<SNIMatcher> matchers;
    private boolean isInboundDone;
    private boolean outboundClosed;
    final boolean jdkCompatibilityMode;
    private final boolean clientMode;
    final ByteBufAllocator alloc;
    private final Map<Long, ReferenceCountedOpenSslEngine> engines;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final ReferenceCountedOpenSslContext parentContext;
    private final OpenSslInternalSession session;
    private final ByteBuffer[] singleSrcBuffer = new ByteBuffer[1];
    private final ByteBuffer[] singleDstBuffer = new ByteBuffer[1];
    private final boolean enableOcsp;
    private int maxWrapOverhead;
    private int maxWrapBufferSize;
    private Throwable pendingException;
    private static final X509Certificate[] JAVAX_CERTS_NOT_SUPPORTED = new X509Certificate[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslEngine(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, ByteBufAllocator byteBufAllocator, String string, int n2, boolean bl2, boolean bl3, String string2, List<SNIServerName> list) {
        super(string, n2);
        OpenSsl.ensureAvailability();
        this.engines = referenceCountedOpenSslContext.engines;
        this.enableOcsp = referenceCountedOpenSslContext.enableOcsp;
        this.groups = (String[])referenceCountedOpenSslContext.groups.clone();
        this.jdkCompatibilityMode = bl2;
        this.alloc = ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        this.apn = (OpenSslApplicationProtocolNegotiator)referenceCountedOpenSslContext.applicationProtocolNegotiator();
        this.clientMode = referenceCountedOpenSslContext.isClient();
        this.endpointIdentificationAlgorithm = string2;
        this.serverNames = list;
        this.session = new ExtendedOpenSslSession(new DefaultOpenSslSession(referenceCountedOpenSslContext.sessionContext())){
            private String[] peerSupportedSignatureAlgorithms;
            private List<SNIServerName> requestedServerNames;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SNIServerName> getRequestedServerNames() {
                if (ReferenceCountedOpenSslEngine.this.clientMode) {
                    List list = ReferenceCountedOpenSslEngine.this.serverNames;
                    return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
                }
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
                synchronized (referenceCountedOpenSslEngine) {
                    if (this.requestedServerNames == null) {
                        byte[] byArray;
                        String string;
                        this.requestedServerNames = ReferenceCountedOpenSslEngine.this.destroyed ? Collections.emptyList() : ((string = SSL.getSniHostname((long)ReferenceCountedOpenSslEngine.this.ssl)) == null ? Collections.emptyList() : ((byArray = SSL.getSniHostname((long)ReferenceCountedOpenSslEngine.this.ssl).getBytes(CharsetUtil.UTF_8)).length == 0 ? Collections.emptyList() : Collections.singletonList(new SNIHostName(byArray))));
                    }
                    return this.requestedServerNames;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getPeerSupportedSignatureAlgorithms() {
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
                synchronized (referenceCountedOpenSslEngine) {
                    if (this.peerSupportedSignatureAlgorithms == null) {
                        if (ReferenceCountedOpenSslEngine.this.destroyed) {
                            this.peerSupportedSignatureAlgorithms = EmptyArrays.EMPTY_STRINGS;
                        } else {
                            String[] stringArray = SSL.getSigAlgs((long)ReferenceCountedOpenSslEngine.this.ssl);
                            if (stringArray == null) {
                                this.peerSupportedSignatureAlgorithms = EmptyArrays.EMPTY_STRINGS;
                            } else {
                                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(stringArray.length);
                                for (String string : stringArray) {
                                    String string2 = SignatureAlgorithmConverter.toJavaName(string);
                                    if (string2 == null) continue;
                                    linkedHashSet.add(string2);
                                }
                                this.peerSupportedSignatureAlgorithms = linkedHashSet.toArray(EmptyArrays.EMPTY_STRINGS);
                            }
                        }
                    }
                    return (String[])this.peerSupportedSignatureAlgorithms.clone();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<byte[]> getStatusResponses() {
                byte[] byArray = null;
                if (ReferenceCountedOpenSslEngine.this.enableOcsp && ReferenceCountedOpenSslEngine.this.clientMode) {
                    ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
                    synchronized (referenceCountedOpenSslEngine) {
                        if (!ReferenceCountedOpenSslEngine.this.destroyed) {
                            byArray = SSL.getOcspResponse((long)ReferenceCountedOpenSslEngine.this.ssl);
                        }
                    }
                }
                return byArray == null ? Collections.emptyList() : Collections.singletonList(byArray);
            }
        };
        try {
            long l2;
            referenceCountedOpenSslContext.retain();
            if (!referenceCountedOpenSslContext.sessionContext().useKeyManager()) {
                this.session.setLocalCertificate(referenceCountedOpenSslContext.keyCertChain);
            }
            Lock lock = referenceCountedOpenSslContext.ctxLock.readLock();
            lock.lock();
            try {
                l2 = SSL.newSSL((long)referenceCountedOpenSslContext.ctx, (!referenceCountedOpenSslContext.isClient() ? 1 : 0) != 0);
            }
            finally {
                lock.unlock();
            }
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            synchronized (referenceCountedOpenSslEngine) {
                this.ssl = l2;
                try {
                    boolean bl4;
                    this.networkBIO = SSL.bioNewByteBuffer((long)this.ssl, (int)referenceCountedOpenSslContext.getBioNonApplicationBufferSize());
                    this.setClientAuth(this.clientMode ? ClientAuth.NONE : referenceCountedOpenSslContext.clientAuth);
                    assert (referenceCountedOpenSslContext.protocols != null);
                    this.hasTLSv13Cipher = referenceCountedOpenSslContext.hasTLSv13Cipher;
                    this.setEnabledProtocols(referenceCountedOpenSslContext.protocols);
                    boolean bl5 = SslUtils.isValidHostNameForSNI(string) && ReferenceCountedOpenSslEngine.isValidHostNameForSNI(string);
                    boolean bl6 = bl4 = list != null && !list.isEmpty();
                    if (this.clientMode && (bl5 || bl4)) {
                        if (bl5) {
                            SSL.setTlsExtHostName((long)this.ssl, (String)string);
                            this.serverNames = Collections.singletonList(new SNIHostName(string));
                        } else {
                            for (SNIServerName sNIServerName : list) {
                                if (sNIServerName instanceof SNIHostName) {
                                    SNIHostName sNIHostName = (SNIHostName)sNIServerName;
                                    SSL.setTlsExtHostName((long)this.ssl, (String)sNIHostName.getAsciiName());
                                    continue;
                                }
                                throw new IllegalArgumentException("Only " + SNIHostName.class.getName() + " instances are supported, but found: " + sNIServerName);
                            }
                        }
                    }
                    if (this.enableOcsp) {
                        SSL.enableOcsp((long)this.ssl);
                    }
                    if (!bl2) {
                        SSL.setMode((long)this.ssl, (int)(SSL.getMode((long)this.ssl) | SSL.SSL_MODE_ENABLE_PARTIAL_WRITE));
                    }
                    if (ReferenceCountedOpenSslEngine.isProtocolEnabled(SSL.getOptions((long)this.ssl), SSL.SSL_OP_NO_TLSv1_3, "TLSv1.3")) {
                        boolean bl7;
                        boolean bl8 = bl7 = this.clientMode ? ReferenceCountedOpenSslContext.CLIENT_ENABLE_SESSION_TICKET_TLSV13 : ReferenceCountedOpenSslContext.SERVER_ENABLE_SESSION_TICKET_TLSV13;
                        if (bl7) {
                            SSL.clearOptions((long)this.ssl, (int)SSL.SSL_OP_NO_TICKET);
                        }
                    }
                    if ((OpenSsl.isBoringSSL() || OpenSsl.isAWSLC()) && this.clientMode) {
                        SSL.setRenegotiateMode((long)this.ssl, (int)SSL.SSL_RENEGOTIATE_ONCE);
                    }
                    this.calculateMaxWrapOverhead();
                    this.configureEndpointVerification(string2);
                }
                catch (Throwable throwable) {
                    this.shutdown();
                    PlatformDependent.throwException(throwable);
                }
            }
        }
        catch (Throwable throwable) {
            referenceCountedOpenSslContext.release();
            PlatformDependent.throwException(throwable);
        }
        this.parentContext = referenceCountedOpenSslContext;
        this.leak = bl3 ? leakDetector.track(this) : null;
    }

    private static boolean isValidHostNameForSNI(String string) {
        try {
            new SNIHostName(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    @Override
    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    @Override
    public final ReferenceCounted touch() {
        this.refCnt.touch();
        return this;
    }

    @Override
    public final ReferenceCounted touch(Object object) {
        this.refCnt.touch(object);
        return this;
    }

    @Override
    public final boolean release() {
        return this.refCnt.release();
    }

    @Override
    public String getApplicationProtocol() {
        return this.applicationProtocol;
    }

    @Override
    public String getHandshakeApplicationProtocol() {
        return this.applicationProtocol;
    }

    @Override
    public final synchronized SSLSession getHandshakeSession() {
        switch (this.handshakeState) {
            case NOT_STARTED: 
            case FINISHED: {
                return null;
            }
        }
        return this.session;
    }

    public final synchronized long sslPointer() {
        return this.ssl;
    }

    public final synchronized void shutdown() {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.engines != null) {
                this.engines.remove(this.ssl);
            }
            SSL.freeSSL((long)this.ssl);
            this.networkBIO = 0L;
            this.ssl = 0L;
            this.outboundClosed = true;
            this.isInboundDone = true;
        }
        SSL.clearError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writePlaintextData(ByteBuffer byteBuffer, int n2) {
        int n3;
        int n4 = byteBuffer.position();
        int n5 = byteBuffer.limit();
        if (byteBuffer.isDirect()) {
            n3 = SSL.writeToSSL((long)this.ssl, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n4), (int)n2);
            if (n3 > 0) {
                byteBuffer.position(n4 + n3);
            }
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n2);
            try {
                byteBuffer.limit(n4 + n2);
                byteBuf.setBytes(0, byteBuffer);
                byteBuffer.limit(n5);
                n3 = SSL.writeToSSL((long)this.ssl, (long)OpenSsl.memoryAddress(byteBuf), (int)n2);
                if (n3 > 0) {
                    byteBuffer.position(n4 + n3);
                } else {
                    byteBuffer.position(n4);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n3;
    }

    synchronized void bioSetFd(int n2) {
        if (!this.destroyed) {
            SSL.bioSetFd((long)this.ssl, (int)n2);
        }
    }

    private ByteBuf writeEncryptedData(ByteBuffer byteBuffer, int n2) throws SSLException {
        int n3 = byteBuffer.position();
        if (byteBuffer.isDirect()) {
            SSL.bioSetByteBuffer((long)this.networkBIO, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n3), (int)n2, (boolean)false);
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n2);
            try {
                int n4 = byteBuffer.limit();
                byteBuffer.limit(n3 + n2);
                byteBuf.writeBytes(byteBuffer);
                byteBuffer.position(n3);
                byteBuffer.limit(n4);
                SSL.bioSetByteBuffer((long)this.networkBIO, (long)OpenSsl.memoryAddress(byteBuf), (int)n2, (boolean)false);
                return byteBuf;
            }
            catch (Throwable throwable) {
                byteBuf.release();
                PlatformDependent.throwException(throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readPlaintextData(ByteBuffer byteBuffer) throws SSLException {
        int n2;
        int n3 = byteBuffer.position();
        if (byteBuffer.isDirect()) {
            n2 = SSL.readFromSSL((long)this.ssl, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n3), (int)(byteBuffer.limit() - n3));
            if (n2 > 0) {
                byteBuffer.position(n3 + n2);
            }
        } else {
            int n4 = byteBuffer.limit();
            int n5 = Math.min(this.maxEncryptedPacketLength0(), n4 - n3);
            ByteBuf byteBuf = this.alloc.directBuffer(n5);
            try {
                n2 = SSL.readFromSSL((long)this.ssl, (long)OpenSsl.memoryAddress(byteBuf), (int)n5);
                if (n2 > 0) {
                    byteBuffer.limit(n3 + n2);
                    byteBuf.getBytes(byteBuf.readerIndex(), byteBuffer);
                    byteBuffer.limit(n4);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n2;
    }

    final int maxEncryptedPacketLength0() {
        return this.maxWrapOverhead + MAX_PLAINTEXT_LENGTH;
    }

    final int calculateMaxLengthForWrap(int n2, int n3) {
        return (int)Math.min((long)this.maxWrapBufferSize, (long)n2 + (long)this.maxWrapOverhead * (long)n3);
    }

    final int calculateOutNetBufSize(int n2, int n3) {
        return (int)Math.min(Integer.MAX_VALUE, (long)n2 + (long)this.maxWrapOverhead * (long)n3);
    }

    final synchronized int sslPending() {
        return this.sslPending0();
    }

    private void calculateMaxWrapOverhead() {
        this.maxWrapOverhead = SSL.getMaxWrapOverhead((long)this.ssl);
        this.maxWrapBufferSize = this.jdkCompatibilityMode ? this.maxEncryptedPacketLength0() : this.maxEncryptedPacketLength0() << 4;
    }

    private int sslPending0() {
        return this.handshakeState != HandshakeState.FINISHED ? 0 : SSL.sslPending((long)this.ssl);
    }

    private boolean isBytesAvailableEnoughForWrap(int n2, int n3, int n4) {
        return (long)n2 - (long)this.maxWrapOverhead * (long)n4 >= (long)n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n2, int n3, ByteBuffer byteBuffer) throws SSLException {
        ObjectUtil.checkNotNullWithIAE(byteBufferArray, "srcs");
        ObjectUtil.checkNotNullWithIAE(byteBuffer, "dst");
        if (n2 >= byteBufferArray.length || n2 + n3 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException("offset: " + n2 + ", length: " + n3 + " (expected: offset <= offset + length <= srcs.length (" + byteBufferArray.length + "))");
        }
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isOutboundDone()) {
                return this.isInboundDone() || this.destroyed ? CLOSED_NOT_HANDSHAKING : NEED_UNWRAP_CLOSED;
            }
            int n4 = 0;
            ByteBuf byteBuf = null;
            try {
                int n5;
                if (byteBuffer.isDirect()) {
                    SSL.bioSetByteBuffer((long)this.networkBIO, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)byteBuffer.position()), (int)byteBuffer.remaining(), (boolean)true);
                } else {
                    byteBuf = this.alloc.directBuffer(byteBuffer.remaining());
                    SSL.bioSetByteBuffer((long)this.networkBIO, (long)OpenSsl.memoryAddress(byteBuf), (int)byteBuf.writableBytes(), (boolean)true);
                }
                int n6 = SSL.bioLengthByteBuffer((long)this.networkBIO);
                if (this.outboundClosed) {
                    if (!this.isBytesAvailableEnoughForWrap(byteBuffer.remaining(), 2, 1)) {
                        SSLEngineResult sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), 0, 0);
                        return sSLEngineResult;
                    }
                    n4 = SSL.bioFlushByteBuffer((long)this.networkBIO);
                    if (n4 <= 0) {
                        SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
                        return sSLEngineResult;
                    }
                    if (!this.doSSLShutdown()) {
                        SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, n4);
                        return sSLEngineResult;
                    }
                    n4 = n6 - SSL.bioLengthByteBuffer((long)this.networkBIO);
                    SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, n4);
                    return sSLEngineResult;
                }
                SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                HandshakeState handshakeState = this.handshakeState;
                if (this.handshakeState != HandshakeState.FINISHED) {
                    if (this.handshakeState != HandshakeState.STARTED_EXPLICITLY) {
                        this.handshakeState = HandshakeState.STARTED_IMPLICITLY;
                    }
                    n4 = SSL.bioFlushByteBuffer((long)this.networkBIO);
                    if (this.pendingException != null) {
                        if (n4 > 0) {
                            SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, n4);
                            return sSLEngineResult;
                        }
                        SSLEngineResult sSLEngineResult = this.newResult(this.handshakeException(), 0, 0);
                        return sSLEngineResult;
                    }
                    handshakeStatus = this.handshake();
                    n4 = n6 - SSL.bioLengthByteBuffer((long)this.networkBIO);
                    if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        SSLEngineResult sSLEngineResult = this.newResult(handshakeStatus, 0, n4);
                        return sSLEngineResult;
                    }
                    if (n4 > 0) {
                        SSLEngineResult sSLEngineResult = this.newResult(this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? (n4 == n6 ? SSLEngineResult.HandshakeStatus.NEED_WRAP : this.getHandshakeStatus(SSL.bioLengthNonApplication((long)this.networkBIO))) : SSLEngineResult.HandshakeStatus.FINISHED), 0, n4);
                        return sSLEngineResult;
                    }
                    if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                        SSLEngineResult sSLEngineResult = this.isOutboundDone() ? NEED_UNWRAP_CLOSED : NEED_UNWRAP_OK;
                        return sSLEngineResult;
                    }
                    if (this.outboundClosed) {
                        n4 = SSL.bioFlushByteBuffer((long)this.networkBIO);
                        SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(handshakeStatus, 0, n4);
                        return sSLEngineResult;
                    }
                }
                int n7 = n2 + n3;
                if (this.jdkCompatibilityMode || handshakeState != HandshakeState.FINISHED) {
                    n5 = 0;
                    for (int i2 = n2; i2 < n7; ++i2) {
                        ByteBuffer byteBuffer2 = byteBufferArray[i2];
                        if (byteBuffer2 == null) {
                            throw new IllegalArgumentException("srcs[" + i2 + "] is null");
                        }
                        if (n5 == MAX_PLAINTEXT_LENGTH || (n5 += byteBuffer2.remaining()) <= MAX_PLAINTEXT_LENGTH && n5 >= 0) continue;
                        n5 = MAX_PLAINTEXT_LENGTH;
                    }
                    if (!this.isBytesAvailableEnoughForWrap(byteBuffer.remaining(), n5, 1)) {
                        SSLEngineResult sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), 0, 0);
                        return sSLEngineResult;
                    }
                }
                n5 = 0;
                assert (n4 == 0);
                n4 = SSL.bioFlushByteBuffer((long)this.networkBIO);
                if (n4 > 0) {
                    SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(handshakeStatus, n5, n4);
                    return sSLEngineResult;
                }
                if (this.pendingException != null) {
                    Throwable throwable = this.pendingException;
                    this.pendingException = null;
                    this.shutdown();
                    throw new SSLException(throwable);
                }
                while (n2 < n7) {
                    ByteBuffer byteBuffer3 = byteBufferArray[n2];
                    int n8 = byteBuffer3.remaining();
                    if (n8 != 0) {
                        int n9;
                        int n10;
                        if (this.jdkCompatibilityMode) {
                            n10 = this.writePlaintextData(byteBuffer3, Math.min(n8, MAX_PLAINTEXT_LENGTH - n5));
                        } else {
                            n9 = byteBuffer.remaining() - n4 - this.maxWrapOverhead;
                            if (n9 <= 0) {
                                SSLEngineResult sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), n5, n4);
                                return sSLEngineResult;
                            }
                            n10 = this.writePlaintextData(byteBuffer3, Math.min(n8, n9));
                        }
                        n9 = SSL.bioLengthByteBuffer((long)this.networkBIO);
                        n4 += n6 - n9;
                        n6 = n9;
                        if (n10 > 0) {
                            n5 += n10;
                            if (this.jdkCompatibilityMode || n4 == byteBuffer.remaining()) {
                                SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(handshakeStatus, n5, n4);
                                return sSLEngineResult;
                            }
                        } else {
                            int n11 = SSL.getError((long)this.ssl, (int)n10);
                            if (n11 == SSL.SSL_ERROR_ZERO_RETURN) {
                                if (!this.receivedShutdown) {
                                    this.closeAll();
                                    SSLEngineResult.HandshakeStatus handshakeStatus2 = this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? ((n4 += n6 - SSL.bioLengthByteBuffer((long)this.networkBIO)) == byteBuffer.remaining() ? SSLEngineResult.HandshakeStatus.NEED_WRAP : this.getHandshakeStatus(SSL.bioLengthNonApplication((long)this.networkBIO))) : SSLEngineResult.HandshakeStatus.FINISHED);
                                    SSLEngineResult sSLEngineResult = this.newResult(handshakeStatus2, n5, n4);
                                    return sSLEngineResult;
                                }
                                SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, n5, n4);
                                return sSLEngineResult;
                            }
                            if (n11 == SSL.SSL_ERROR_WANT_READ) {
                                SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NEED_UNWRAP, n5, n4);
                                return sSLEngineResult;
                            }
                            if (n11 == SSL.SSL_ERROR_WANT_WRITE) {
                                if (n4 > 0) {
                                    SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NEED_WRAP, n5, n4);
                                    return sSLEngineResult;
                                }
                                SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.Status.BUFFER_OVERFLOW, handshakeStatus, n5, n4);
                                return sSLEngineResult;
                            }
                            if (n11 != SSL.SSL_ERROR_WANT_X509_LOOKUP && n11 != SSL.SSL_ERROR_WANT_CERTIFICATE_VERIFY && n11 != SSL.SSL_ERROR_WANT_PRIVATE_KEY_OPERATION) {
                                throw this.shutdownWithError("SSL_write", n11, SSL.getLastErrorNumber());
                            }
                            SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NEED_TASK, n5, n4);
                            return sSLEngineResult;
                        }
                    }
                    ++n2;
                }
                SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(handshakeStatus, n5, n4);
                return sSLEngineResult;
            }
            finally {
                SSL.bioClearByteBuffer((long)this.networkBIO);
                if (byteBuf == null) {
                    byteBuffer.position(byteBuffer.position() + n4);
                } else {
                    assert (byteBuf.readableBytes() <= byteBuffer.remaining()) : "The destination buffer " + byteBuffer + " didn't have enough remaining space to hold the encrypted content in " + byteBuf;
                    byteBuffer.put(byteBuf.internalNioBuffer(byteBuf.readerIndex(), n4));
                    byteBuf.release();
                }
            }
        }
    }

    private SSLEngineResult newResult(SSLEngineResult.HandshakeStatus handshakeStatus, int n2, int n3) {
        return this.newResult(SSLEngineResult.Status.OK, handshakeStatus, n2, n3);
    }

    private SSLEngineResult newResult(SSLEngineResult.Status status, SSLEngineResult.HandshakeStatus handshakeStatus, int n2, int n3) {
        if (this.isOutboundDone()) {
            if (this.isInboundDone()) {
                handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                this.shutdown();
            }
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, handshakeStatus, n2, n3);
        }
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.needTask = true;
        }
        return new SSLEngineResult(status, handshakeStatus, n2, n3);
    }

    private SSLEngineResult newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus, int n2, int n3) throws SSLException {
        return this.newResult(this.mayFinishHandshake(handshakeStatus, n2, n3), n2, n3);
    }

    private SSLEngineResult newResultMayFinishHandshake(SSLEngineResult.Status status, SSLEngineResult.HandshakeStatus handshakeStatus, int n2, int n3) throws SSLException {
        return this.newResult(status, this.mayFinishHandshake(handshakeStatus, n2, n3), n2, n3);
    }

    private SSLException shutdownWithError(String string, int n2, int n3) {
        Object object;
        if (logger.isDebugEnabled()) {
            object = SSL.getErrorString((long)n3);
            logger.debug("{} failed with {}: OpenSSL error: {} {}", string, n2, n3, object);
        }
        this.shutdown();
        object = this.newSSLExceptionForError(n3);
        if (this.pendingException != null) {
            ((Throwable)object).initCause(this.pendingException);
            this.pendingException = null;
        }
        return object;
    }

    private SSLEngineResult handleUnwrapException(int n2, int n3, SSLException sSLException) throws SSLException {
        int n4 = SSL.getLastErrorNumber();
        if (n4 != 0) {
            return this.sslReadErrorResult(SSL.SSL_ERROR_SSL, n4, n2, n3);
        }
        throw sSLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, int n2, int n3, ByteBuffer[] byteBufferArray2, int n4, int n5) throws SSLException {
        Object object;
        int n6;
        ByteBuffer byteBuffer;
        ObjectUtil.checkNotNullWithIAE(byteBufferArray, "srcs");
        if (n2 >= byteBufferArray.length || n2 + n3 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException("offset: " + n2 + ", length: " + n3 + " (expected: offset <= offset + length <= srcs.length (" + byteBufferArray.length + "))");
        }
        ObjectUtil.checkNotNullWithIAE(byteBufferArray2, "dsts");
        if (n4 >= byteBufferArray2.length || n4 + n5 > byteBufferArray2.length) {
            throw new IndexOutOfBoundsException("offset: " + n4 + ", length: " + n5 + " (expected: offset <= offset + length <= dsts.length (" + byteBufferArray2.length + "))");
        }
        long l2 = 0L;
        int n7 = n4 + n5;
        for (n6 = n4; n6 < n7; l2 += (long)byteBuffer.remaining(), ++n6) {
            byteBuffer = ObjectUtil.checkNotNullArrayParam(byteBufferArray2[n6], n6, "dsts");
            if (!byteBuffer.isReadOnly()) continue;
            throw new ReadOnlyBufferException();
        }
        n6 = n2 + n3;
        long l3 = 0L;
        for (int i2 = n2; i2 < n6; l3 += (long)object.remaining(), ++i2) {
            object = ObjectUtil.checkNotNullArrayParam(byteBufferArray[i2], i2, "srcs");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            int n8;
            int n9;
            block60: {
                int n10;
                if (this.isInboundDone()) {
                    return this.isOutboundDone() || this.destroyed ? CLOSED_NOT_HANDSHAKING : NEED_WRAP_CLOSED;
                }
                object = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                HandshakeState handshakeState = this.handshakeState;
                if (this.handshakeState != HandshakeState.FINISHED) {
                    if (this.handshakeState != HandshakeState.STARTED_EXPLICITLY) {
                        this.handshakeState = HandshakeState.STARTED_IMPLICITLY;
                    }
                    if ((object = this.handshake()) == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        return this.newResult((SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    if (object == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                        return NEED_WRAP_OK;
                    }
                    if (this.isInboundDone) {
                        return NEED_WRAP_CLOSED;
                    }
                }
                int n11 = this.sslPending0();
                if (this.jdkCompatibilityMode || handshakeState != HandshakeState.FINISHED) {
                    if (l3 < 5L) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_UNDERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    n10 = SslUtils.getEncryptedPacketLength(byteBufferArray, n2);
                    if (n10 == -2) {
                        throw new NotSslRecordException("not an SSL/TLS record");
                    }
                    assert (n10 >= 0);
                    n9 = n10 - 5;
                    if ((long)n9 > l2) {
                        if (n9 > MAX_RECORD_SIZE) {
                            throw new SSLException("Illegal packet length: " + n9 + " > " + this.session.getApplicationBufferSize());
                        }
                        this.session.tryExpandApplicationBufferSize(n9);
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_OVERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    if (l3 < (long)n10) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_UNDERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                } else {
                    if (l3 == 0L && n11 <= 0) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_UNDERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    if (l2 == 0L) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_OVERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    n10 = (int)Math.min(Integer.MAX_VALUE, l3);
                }
                assert (n2 < n6);
                assert (l2 > 0L);
                n9 = 0;
                n8 = 0;
                try {
                    while (true) {
                        int n12;
                        ByteBuf byteBuf;
                        ByteBuffer byteBuffer2;
                        int n13;
                        if ((n13 = (byteBuffer2 = byteBufferArray[n2]).remaining()) == 0) {
                            if (n11 <= 0) {
                                if (++n2 < n6) continue;
                                break;
                            }
                            byteBuf = null;
                            n12 = SSL.bioLengthByteBuffer((long)this.networkBIO);
                        } else {
                            n12 = Math.min(n10, n13);
                            try {
                                byteBuf = this.writeEncryptedData(byteBuffer2, n12);
                            }
                            catch (SSLException sSLException) {
                                SSLEngineResult sSLEngineResult = this.handleUnwrapException(n8, n9, sSLException);
                                SSL.bioClearByteBuffer((long)this.networkBIO);
                                this.rejectRemoteInitiatedRenegotiation();
                                return sSLEngineResult;
                            }
                        }
                        try {
                            int n14;
                            block61: {
                                while (true) {
                                    ByteBuffer byteBuffer3;
                                    if (!(byteBuffer3 = byteBufferArray2[n4]).hasRemaining()) {
                                        if (++n4 < n7) continue;
                                        break block60;
                                    }
                                    try {
                                        n14 = this.readPlaintextData(byteBuffer3);
                                    }
                                    catch (SSLException sSLException) {
                                        SSLEngineResult sSLEngineResult = this.handleUnwrapException(n8, n9, sSLException);
                                        if (byteBuf != null) {
                                            byteBuf.release();
                                        }
                                        SSL.bioClearByteBuffer((long)this.networkBIO);
                                        this.rejectRemoteInitiatedRenegotiation();
                                        return sSLEngineResult;
                                    }
                                    int n15 = n12 - SSL.bioLengthByteBuffer((long)this.networkBIO);
                                    n8 += n15;
                                    n10 -= n15;
                                    n12 -= n15;
                                    byteBuffer2.position(byteBuffer2.position() + n15);
                                    if (n14 <= 0) break block61;
                                    n9 += n14;
                                    if (!byteBuffer3.hasRemaining()) {
                                        n11 = this.sslPending0();
                                        if (++n4 < n7) continue;
                                        SSLEngineResult sSLEngineResult = n11 > 0 ? this.newResult(SSLEngineResult.Status.BUFFER_OVERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), n8, n9) : this.newResultMayFinishHandshake(this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, (SSLEngineResult.HandshakeStatus)((Object)object), n8, n9);
                                        return sSLEngineResult;
                                    }
                                    if (n10 == 0 || this.jdkCompatibilityMode) break;
                                }
                                break;
                            }
                            int n16 = SSL.getError((long)this.ssl, (int)n14);
                            if (n16 != SSL.SSL_ERROR_WANT_READ && n16 != SSL.SSL_ERROR_WANT_WRITE) {
                                if (n16 == SSL.SSL_ERROR_ZERO_RETURN) {
                                    if (!this.receivedShutdown) {
                                        this.closeAll();
                                    }
                                    SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, (SSLEngineResult.HandshakeStatus)((Object)object), n8, n9);
                                    return sSLEngineResult;
                                }
                                if (n16 == SSL.SSL_ERROR_WANT_X509_LOOKUP || n16 == SSL.SSL_ERROR_WANT_CERTIFICATE_VERIFY || n16 == SSL.SSL_ERROR_WANT_PRIVATE_KEY_OPERATION) {
                                    SSLEngineResult sSLEngineResult = this.newResult(this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_TASK, n8, n9);
                                    return sSLEngineResult;
                                }
                                SSLEngineResult sSLEngineResult = this.sslReadErrorResult(n16, SSL.getLastErrorNumber(), n8, n9);
                                return sSLEngineResult;
                            }
                            if (++n2 < n6) continue;
                        }
                        finally {
                            if (byteBuf == null) continue;
                            byteBuf.release();
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    SSL.bioClearByteBuffer((long)this.networkBIO);
                    this.rejectRemoteInitiatedRenegotiation();
                }
            }
            if (!this.receivedShutdown && (SSL.getShutdown((long)this.ssl) & SSL.SSL_RECEIVED_SHUTDOWN) == SSL.SSL_RECEIVED_SHUTDOWN) {
                this.closeAll();
            }
            return this.newResultMayFinishHandshake(this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, (SSLEngineResult.HandshakeStatus)((Object)object), n8, n9);
        }
    }

    private boolean needWrapAgain(int n2) {
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            if (this.pendingException == null) {
                this.pendingException = this.newSSLExceptionForError(n2);
            } else if (ReferenceCountedOpenSslEngine.shouldAddSuppressed(this.pendingException, n2)) {
                ThrowableUtil.addSuppressed(this.pendingException, this.newSSLExceptionForError(n2));
            }
            SSL.clearError();
            return true;
        }
        return false;
    }

    private SSLException newSSLExceptionForError(int n2) {
        String string = SSL.getErrorString((long)n2);
        return this.handshakeState == HandshakeState.FINISHED ? new OpenSslException(string, n2) : new OpenSslHandshakeException(string, n2);
    }

    private static boolean shouldAddSuppressed(Throwable throwable, int n2) {
        for (Throwable throwable2 : ThrowableUtil.getSuppressed(throwable)) {
            if (!(throwable2 instanceof NativeSslException) || ((NativeSslException)((Object)throwable2)).errorCode() != n2) continue;
            return false;
        }
        return true;
    }

    private SSLEngineResult sslReadErrorResult(int n2, int n3, int n4, int n5) throws SSLException {
        if (this.needWrapAgain(n3)) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, n4, n5);
        }
        throw this.shutdownWithError("SSL_read", n2, n3);
    }

    private void closeAll() throws SSLException {
        this.receivedShutdown = true;
        this.closeOutbound();
        this.closeInbound();
    }

    private void rejectRemoteInitiatedRenegotiation() throws SSLHandshakeException {
        boolean bl2;
        if (this.destroyed || "TLSv1.3".equals(this.session.getProtocol()) || this.handshakeState != HandshakeState.FINISHED) {
            return;
        }
        int n2 = SSL.getHandshakeCount((long)this.ssl);
        boolean bl3 = bl2 = !this.clientMode && n2 > 1 || this.clientMode && n2 > 2;
        if (bl2) {
            this.shutdown();
            throw new SSLHandshakeException("remote-initiated renegotiation not allowed");
        }
    }

    public final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) throws SSLException {
        return this.unwrap(byteBufferArray, 0, byteBufferArray.length, byteBufferArray2, 0, byteBufferArray2.length);
    }

    private ByteBuffer[] singleSrcBuffer(ByteBuffer byteBuffer) {
        this.singleSrcBuffer[0] = byteBuffer;
        return this.singleSrcBuffer;
    }

    private void resetSingleSrcBuffer() {
        this.singleSrcBuffer[0] = null;
    }

    private ByteBuffer[] singleDstBuffer(ByteBuffer byteBuffer) {
        this.singleDstBuffer[0] = byteBuffer;
        return this.singleDstBuffer;
    }

    private void resetSingleDstBuffer() {
        this.singleDstBuffer[0] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n2, int n3) throws SSLException {
        try {
            SSLEngineResult sSLEngineResult = this.unwrap(this.singleSrcBuffer(byteBuffer), 0, 1, byteBufferArray, n2, n3);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult wrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        try {
            SSLEngineResult sSLEngineResult = this.wrap(this.singleSrcBuffer(byteBuffer), byteBuffer2);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        try {
            SSLEngineResult sSLEngineResult = this.unwrap(this.singleSrcBuffer(byteBuffer), this.singleDstBuffer(byteBuffer2));
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
            this.resetSingleDstBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray) throws SSLException {
        try {
            SSLEngineResult sSLEngineResult = this.unwrap(this.singleSrcBuffer(byteBuffer), byteBufferArray);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAndResetNeedTask(Runnable runnable) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            try {
                if (this.destroyed) {
                    return;
                }
                runnable.run();
                if (this.handshakeState != HandshakeState.FINISHED && !this.destroyed && SSL.doHandshake((long)this.ssl) <= 0) {
                    SSL.clearError();
                }
            }
            finally {
                this.needTask = false;
            }
        }
    }

    @Override
    public final synchronized Runnable getDelegatedTask() {
        if (this.destroyed) {
            return null;
        }
        Runnable runnable = SSL.getTask((long)this.ssl);
        if (runnable == null) {
            return null;
        }
        if (runnable instanceof AsyncTask) {
            return new AsyncTaskDecorator((AsyncTask)runnable);
        }
        return () -> this.runAndResetNeedTask(runnable);
    }

    @Override
    public final synchronized void closeInbound() throws SSLException {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        if (this.isOutboundDone()) {
            this.shutdown();
        }
        if (this.handshakeState != HandshakeState.NOT_STARTED && !this.receivedShutdown) {
            throw new SSLException("Inbound closed before receiving peer's close_notify: possible truncation attack?");
        }
    }

    @Override
    public final synchronized boolean isInboundDone() {
        return this.isInboundDone;
    }

    @Override
    public final synchronized void closeOutbound() {
        if (this.outboundClosed) {
            return;
        }
        this.outboundClosed = true;
        if (this.handshakeState != HandshakeState.NOT_STARTED && !this.destroyed) {
            int n2 = SSL.getShutdown((long)this.ssl);
            if ((n2 & SSL.SSL_SENT_SHUTDOWN) != SSL.SSL_SENT_SHUTDOWN) {
                this.doSSLShutdown();
            }
        } else {
            this.shutdown();
        }
    }

    private boolean doSSLShutdown() {
        if (SSL.isInInit((long)this.ssl) != 0) {
            return false;
        }
        int n2 = SSL.shutdownSSL((long)this.ssl);
        if (n2 < 0) {
            int n3 = SSL.getError((long)this.ssl, (int)n2);
            if (n3 == SSL.SSL_ERROR_SYSCALL || n3 == SSL.SSL_ERROR_SSL) {
                if (logger.isDebugEnabled()) {
                    int n4 = SSL.getLastErrorNumber();
                    logger.debug("SSL_shutdown failed: OpenSSL error: {} {}", (Object)n4, (Object)SSL.getErrorString((long)n4));
                }
                this.shutdown();
                return false;
            }
            SSL.clearError();
        }
        return true;
    }

    @Override
    public final synchronized boolean isOutboundDone() {
        return this.outboundClosed && (this.networkBIO == 0L || SSL.bioLengthNonApplication((long)this.networkBIO) == 0);
    }

    @Override
    public final String[] getSupportedCipherSuites() {
        return OpenSsl.AVAILABLE_CIPHER_SUITES.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String[] getEnabledCipherSuites() {
        boolean bl2;
        String[] stringArray;
        String[] stringArray2;
        Object object = this;
        synchronized (object) {
            if (!this.destroyed) {
                stringArray2 = SSL.getCiphers((long)this.ssl);
                int n2 = SSL.getOptions((long)this.ssl);
                if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n2, SSL.SSL_OP_NO_TLSv1_3, "TLSv1.3")) {
                    stringArray = OpenSsl.EXTRA_SUPPORTED_TLS_1_3_CIPHERS;
                    bl2 = true;
                } else {
                    stringArray = EmptyArrays.EMPTY_STRINGS;
                    bl2 = false;
                }
            } else {
                return EmptyArrays.EMPTY_STRINGS;
            }
        }
        if (stringArray2 == null) {
            return EmptyArrays.EMPTY_STRINGS;
        }
        object = new LinkedHashSet(stringArray2.length + stringArray.length);
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            for (String string : stringArray2) {
                String string2;
                String string3 = this.toJavaCipherSuite(string);
                String string4 = string2 = string3 == null ? string : string3;
                if ((!bl2 || !OpenSsl.isTlsv13Supported()) && SslUtils.isTLSv13Cipher(string2)) continue;
                object.add(string2);
            }
            Collections.addAll(object, stringArray);
        }
        return object.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setEnabledCipherSuites(String[] stringArray) {
        ObjectUtil.checkNotNull(stringArray, "cipherSuites");
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        CipherSuiteConverter.convertToCipherStrings(Arrays.asList(stringArray), stringBuilder, stringBuilder2, OpenSsl.isBoringSSL());
        String string = stringBuilder.toString();
        String string2 = stringBuilder2.toString();
        if (!OpenSsl.isTlsv13Supported() && !string2.isEmpty()) {
            throw new IllegalArgumentException("TLSv1.3 is not supported by this java version.");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            boolean bl2 = this.hasTLSv13Cipher = !string2.isEmpty();
            if (!this.destroyed) {
                try {
                    SSL.setCipherSuites((long)this.ssl, (String)string, (boolean)false);
                    if (OpenSsl.isTlsv13Supported()) {
                        SSL.setCipherSuites((long)this.ssl, (String)OpenSsl.checkTls13Ciphers(logger, string2), (boolean)true);
                    }
                    HashSet<String> hashSet = new HashSet<String>(this.enabledProtocols);
                    if (string.isEmpty()) {
                        hashSet.remove("TLSv1");
                        hashSet.remove("TLSv1.1");
                        hashSet.remove("TLSv1.2");
                        hashSet.remove("SSLv3");
                        hashSet.remove("SSLv2");
                        hashSet.remove("SSLv2Hello");
                    }
                    if (string2.isEmpty()) {
                        hashSet.remove("TLSv1.3");
                    }
                    this.setEnabledProtocols0(hashSet.toArray(EmptyArrays.EMPTY_STRINGS), !this.hasTLSv13Cipher);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("failed to enable cipher suites: " + string, exception);
                }
            } else {
                throw new IllegalStateException("failed to enable cipher suites: " + string);
            }
        }
    }

    @Override
    public final String[] getSupportedProtocols() {
        return OpenSsl.unpackSupportedProtocols().toArray(EmptyArrays.EMPTY_STRINGS);
    }

    @Override
    public final String[] getEnabledProtocols() {
        return this.enabledProtocols.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    private static boolean isProtocolEnabled(int n2, int n3, String string) {
        return (n2 & n3) == 0 && OpenSsl.isProtocolSupported(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setEnabledProtocols(String[] stringArray) {
        ObjectUtil.checkNotNullWithIAE(stringArray, "protocols");
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            this.enabledProtocols.clear();
            this.enabledProtocols.add("SSLv2Hello");
            Collections.addAll(this.enabledProtocols, stringArray);
            this.setEnabledProtocols0(stringArray, !this.hasTLSv13Cipher);
        }
    }

    private void setEnabledProtocols0(String[] stringArray, boolean bl2) {
        assert (Thread.holdsLock(this));
        int n2 = OPENSSL_OP_NO_PROTOCOLS.length;
        int n3 = 0;
        String[] stringArray2 = stringArray;
        int n4 = stringArray2.length;
        block16: for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            String string = stringArray2[i2];
            if (!OpenSsl.isProtocolSupported(string)) {
                throw new IllegalArgumentException("Protocol " + string + " is not supported.");
            }
            switch (string) {
                case "SSLv2": {
                    n5 = 0;
                    break;
                }
                case "SSLv3": {
                    n5 = 1;
                    break;
                }
                case "TLSv1": {
                    n5 = 2;
                    break;
                }
                case "TLSv1.1": {
                    n5 = 3;
                    break;
                }
                case "TLSv1.2": {
                    n5 = 4;
                    break;
                }
                case "TLSv1.3": {
                    if (bl2) continue block16;
                    n5 = 5;
                    break;
                }
                default: {
                    continue block16;
                }
            }
            n2 = Math.min(n2, n5);
            n3 = Math.max(n3, n5);
        }
        if (this.destroyed) {
            throw new IllegalStateException("failed to enable protocols: " + Arrays.asList(stringArray));
        }
        SSL.clearOptions((long)this.ssl, (int)(SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_NO_TLSv1_2 | SSL.SSL_OP_NO_TLSv1_3));
        int n6 = 0;
        for (n4 = 0; n4 < n2; ++n4) {
            n6 |= OPENSSL_OP_NO_PROTOCOLS[n4];
        }
        assert (n3 != Integer.MAX_VALUE);
        for (n4 = n3 + 1; n4 < OPENSSL_OP_NO_PROTOCOLS.length; ++n4) {
            n6 |= OPENSSL_OP_NO_PROTOCOLS[n4];
        }
        SSL.setOptions((long)this.ssl, (int)n6);
    }

    @Override
    public final SSLSession getSession() {
        return this.session;
    }

    @Override
    public final synchronized void beginHandshake() throws SSLException {
        switch (this.handshakeState) {
            case STARTED_IMPLICITLY: {
                this.checkEngineClosed();
                this.handshakeState = HandshakeState.STARTED_EXPLICITLY;
                this.calculateMaxWrapOverhead();
                break;
            }
            case STARTED_EXPLICITLY: {
                break;
            }
            case FINISHED: {
                throw new SSLException("renegotiation unsupported");
            }
            case NOT_STARTED: {
                this.handshakeState = HandshakeState.STARTED_EXPLICITLY;
                if (this.handshake() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.needTask = true;
                }
                this.calculateMaxWrapOverhead();
                break;
            }
            default: {
                throw new Error("Unexpected handshake state: " + (Object)((Object)this.handshakeState));
            }
        }
    }

    private void checkEngineClosed() throws SSLException {
        if (this.destroyed) {
            throw new SSLException("engine closed");
        }
    }

    private static SSLEngineResult.HandshakeStatus pendingStatus(int n2) {
        return n2 > 0 ? SSLEngineResult.HandshakeStatus.NEED_WRAP : SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
    }

    private static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    private static boolean isEmpty(byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }

    private SSLEngineResult.HandshakeStatus handshakeException() throws SSLException {
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        Throwable throwable = this.pendingException;
        assert (throwable != null);
        this.pendingException = null;
        this.shutdown();
        if (throwable instanceof SSLHandshakeException) {
            throw (SSLHandshakeException)throwable;
        }
        SSLHandshakeException sSLHandshakeException = new SSLHandshakeException("General OpenSslEngine problem");
        sSLHandshakeException.initCause(throwable);
        throw sSLHandshakeException;
    }

    private SSLEngineResult.HandshakeStatus handshake() throws SSLException {
        int n2;
        if (this.needTask) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.handshakeState == HandshakeState.FINISHED) {
            return SSLEngineResult.HandshakeStatus.FINISHED;
        }
        this.checkEngineClosed();
        if (this.pendingException != null) {
            if (SSL.doHandshake((long)this.ssl) <= 0) {
                SSL.clearError();
            }
            return this.handshakeException();
        }
        this.engines.put(this.sslPointer(), this);
        if (!this.sessionSet) {
            if (!this.parentContext.sessionContext().setSessionFromCache(this.ssl, this.session, this.getPeerHost(), this.getPeerPort())) {
                this.session.prepareHandshake();
            }
            this.sessionSet = true;
        }
        if ((n2 = SSL.doHandshake((long)this.ssl)) <= 0) {
            int n3 = SSL.getError((long)this.ssl, (int)n2);
            if (n3 == SSL.SSL_ERROR_WANT_READ || n3 == SSL.SSL_ERROR_WANT_WRITE) {
                return ReferenceCountedOpenSslEngine.pendingStatus(SSL.bioLengthNonApplication((long)this.networkBIO));
            }
            if (n3 == SSL.SSL_ERROR_WANT_X509_LOOKUP || n3 == SSL.SSL_ERROR_WANT_CERTIFICATE_VERIFY || n3 == SSL.SSL_ERROR_WANT_PRIVATE_KEY_OPERATION) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            int n4 = SSL.getLastErrorNumber();
            if (this.needWrapAgain(n4)) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            if (this.pendingException != null) {
                return this.handshakeException();
            }
            throw this.shutdownWithError("SSL_do_handshake", n3, n4);
        }
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        this.session.handshakeFinished(SSL.getSessionId((long)this.ssl), SSL.getCipherForSSL((long)this.ssl), SSL.getVersion((long)this.ssl), SSL.getPeerCertificate((long)this.ssl), SSL.getPeerCertChain((long)this.ssl), SSL.getTime((long)this.ssl) * 1000L, this.parentContext.sessionTimeout() * 1000L);
        this.selectApplicationProtocol();
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    private SSLEngineResult.HandshakeStatus mayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus, int n2, int n3) throws SSLException {
        return handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && n3 > 0 || handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && n2 > 0 ? this.handshake() : this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus() : SSLEngineResult.HandshakeStatus.FINISHED);
    }

    private SSLEngineResult.HandshakeStatus mayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus) throws SSLException {
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (this.handshakeState != HandshakeState.FINISHED) {
                return this.handshake();
            }
            if (!this.destroyed && SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
        }
        return handshakeStatus;
    }

    @Override
    public final synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.needPendingStatus()) {
            if (this.needTask) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            return ReferenceCountedOpenSslEngine.pendingStatus(SSL.bioLengthNonApplication((long)this.networkBIO));
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private SSLEngineResult.HandshakeStatus getHandshakeStatus(int n2) {
        if (this.needPendingStatus()) {
            if (this.needTask) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            return ReferenceCountedOpenSslEngine.pendingStatus(n2);
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private boolean needPendingStatus() {
        return this.handshakeState != HandshakeState.NOT_STARTED && !this.destroyed && (this.handshakeState != HandshakeState.FINISHED || this.isInboundDone() || this.isOutboundDone());
    }

    private String toJavaCipherSuite(String string) {
        if (string == null) {
            return null;
        }
        String string2 = SSL.getVersion((long)this.ssl);
        String string3 = ReferenceCountedOpenSslEngine.toJavaCipherSuitePrefix(string2);
        return CipherSuiteConverter.toJava(string, string3);
    }

    private static String toJavaCipherSuitePrefix(String string) {
        int n2 = string == null || string.isEmpty() ? 0 : (int)string.charAt(0);
        switch (n2) {
            case 84: {
                return "TLS";
            }
            case 83: {
                return "SSL";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public final void setUseClientMode(boolean bl2) {
        if (bl2 != this.clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final boolean getUseClientMode() {
        return this.clientMode;
    }

    @Override
    public final void setNeedClientAuth(boolean bl2) {
        this.setClientAuth(bl2 ? ClientAuth.REQUIRE : ClientAuth.NONE);
    }

    @Override
    public final boolean getNeedClientAuth() {
        return this.clientAuth == ClientAuth.REQUIRE;
    }

    @Override
    public final void setWantClientAuth(boolean bl2) {
        this.setClientAuth(bl2 ? ClientAuth.OPTIONAL : ClientAuth.NONE);
    }

    @Override
    public final boolean getWantClientAuth() {
        return this.clientAuth == ClientAuth.OPTIONAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientAuth(ClientAuth clientAuth) {
        if (this.clientMode) {
            return;
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.clientAuth == clientAuth) {
                return;
            }
            if (!this.destroyed) {
                switch (clientAuth) {
                    case NONE: {
                        SSL.setVerify((long)this.ssl, (int)0, (int)10);
                        break;
                    }
                    case REQUIRE: {
                        SSL.setVerify((long)this.ssl, (int)2, (int)10);
                        break;
                    }
                    case OPTIONAL: {
                        SSL.setVerify((long)this.ssl, (int)1, (int)10);
                        break;
                    }
                    default: {
                        throw new Error("Unexpected client auth mode: " + (Object)((Object)clientAuth));
                    }
                }
            }
            this.clientAuth = clientAuth;
        }
    }

    @Override
    public final void setEnableSessionCreation(boolean bl2) {
        if (bl2) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final boolean getEnableSessionCreation() {
        return false;
    }

    @Override
    public final synchronized SSLParameters getSSLParameters() {
        SSLParameters sSLParameters = super.getSSLParameters();
        sSLParameters.setEndpointIdentificationAlgorithm(this.endpointIdentificationAlgorithm);
        sSLParameters.setAlgorithmConstraints(this.algorithmConstraints);
        sSLParameters.setServerNames(this.serverNames);
        if (this.groups != null) {
            OpenSslParametersUtil.setNamesGroups(sSLParameters, (String[])this.groups.clone());
        }
        if (!this.destroyed) {
            sSLParameters.setUseCipherSuitesOrder((SSL.getOptions((long)this.ssl) & SSL.SSL_OP_CIPHER_SERVER_PREFERENCE) != 0);
        }
        sSLParameters.setSNIMatchers(this.matchers);
        return sSLParameters;
    }

    @Override
    public final synchronized void setSSLParameters(SSLParameters sSLParameters) {
        Object object;
        if (sSLParameters.getAlgorithmConstraints() != null) {
            throw new IllegalArgumentException("AlgorithmConstraints are not supported.");
        }
        boolean bl2 = this.destroyed;
        if (!bl2) {
            Iterator<String> iterator;
            if (this.clientMode) {
                object = sSLParameters.getServerNames();
                if (object != null && !object.isEmpty()) {
                    Object object2;
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        object2 = (SNIServerName)iterator.next();
                        if (object2 instanceof SNIHostName) continue;
                        throw new IllegalArgumentException("Only " + SNIHostName.class.getName() + " instances are supported, but found: " + object2);
                    }
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        object2 = (SNIServerName)iterator.next();
                        SNIHostName sNIHostName = (SNIHostName)object2;
                        SSL.setTlsExtHostName((long)this.ssl, (String)sNIHostName.getAsciiName());
                    }
                }
                this.serverNames = object;
            }
            if ((object = OpenSslParametersUtil.getNamesGroups(sSLParameters)) != null) {
                iterator = new LinkedHashSet(((Object)object).length);
                for (Object object3 : object) {
                    if (object3 == null || ((String)object3).isEmpty()) {
                        throw new IllegalArgumentException();
                    }
                    if (iterator.add(GroupsConverter.toOpenSsl((String)object3))) continue;
                    throw new IllegalArgumentException("named groups contains a duplicate");
                }
                if (!SSL.setCurvesList((long)this.ssl, (String[])iterator.toArray((String[])EmptyArrays.EMPTY_STRINGS))) {
                    throw new UnsupportedOperationException();
                }
                this.groups = object;
            }
            if (sSLParameters.getUseCipherSuitesOrder()) {
                SSL.setOptions((long)this.ssl, (int)SSL.SSL_OP_CIPHER_SERVER_PREFERENCE);
            } else {
                SSL.clearOptions((long)this.ssl, (int)SSL.SSL_OP_CIPHER_SERVER_PREFERENCE);
            }
        }
        this.matchers = sSLParameters.getSNIMatchers();
        object = sSLParameters.getEndpointIdentificationAlgorithm();
        if (!bl2) {
            this.configureEndpointVerification((String)object);
        }
        this.endpointIdentificationAlgorithm = object;
        this.algorithmConstraints = sSLParameters.getAlgorithmConstraints();
        super.setSSLParameters(sSLParameters);
    }

    private void configureEndpointVerification(String string) {
        if (this.clientMode && ReferenceCountedOpenSslEngine.isEndPointVerificationEnabled(string)) {
            SSL.setVerify((long)this.ssl, (int)2, (int)-1);
        }
    }

    private static boolean isEndPointVerificationEnabled(String string) {
        return string != null && !string.isEmpty();
    }

    private static long bufferAddress(ByteBuffer byteBuffer) {
        assert (byteBuffer.isDirect());
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.directBufferAddress(byteBuffer);
        }
        return Buffer.address((ByteBuffer)byteBuffer);
    }

    private void selectApplicationProtocol() throws SSLException {
        ApplicationProtocolConfig.SelectedListenerFailureBehavior selectedListenerFailureBehavior = this.apn.selectedListenerFailureBehavior();
        List<String> list = this.apn.protocols();
        switch (this.apn.protocol()) {
            case NONE: {
                break;
            }
            case ALPN: {
                String string = SSL.getAlpnSelected((long)this.ssl);
                if (string == null) break;
                this.applicationProtocol = ReferenceCountedOpenSslEngine.selectApplicationProtocol(list, selectedListenerFailureBehavior, string);
                break;
            }
            case NPN: {
                String string = SSL.getNextProtoNegotiated((long)this.ssl);
                if (string == null) break;
                this.applicationProtocol = ReferenceCountedOpenSslEngine.selectApplicationProtocol(list, selectedListenerFailureBehavior, string);
                break;
            }
            case NPN_AND_ALPN: {
                String string = SSL.getAlpnSelected((long)this.ssl);
                if (string == null) {
                    string = SSL.getNextProtoNegotiated((long)this.ssl);
                }
                if (string == null) break;
                this.applicationProtocol = ReferenceCountedOpenSslEngine.selectApplicationProtocol(list, selectedListenerFailureBehavior, string);
                break;
            }
            default: {
                throw new Error("Unexpected apn protocol: " + (Object)((Object)this.apn.protocol()));
            }
        }
    }

    private static String selectApplicationProtocol(List<String> list, ApplicationProtocolConfig.SelectedListenerFailureBehavior selectedListenerFailureBehavior, String string) throws SSLException {
        if (selectedListenerFailureBehavior == ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT) {
            return string;
        }
        int n2 = list.size();
        assert (n2 > 0);
        if (list.contains(string)) {
            return string;
        }
        if (selectedListenerFailureBehavior == ApplicationProtocolConfig.SelectedListenerFailureBehavior.CHOOSE_MY_LAST_PROTOCOL) {
            return list.get(n2 - 1);
        }
        throw new SSLException("unknown protocol " + string);
    }

    private static final class OpenSslHandshakeException
    extends SSLHandshakeException
    implements NativeSslException {
        private final int errorCode;

        OpenSslHandshakeException(String string, int n2) {
            super(string);
            this.errorCode = n2;
        }

        @Override
        public int errorCode() {
            return this.errorCode;
        }
    }

    private static final class OpenSslException
    extends SSLException
    implements NativeSslException {
        private final int errorCode;

        OpenSslException(String string, int n2) {
            super(string);
            this.errorCode = n2;
        }

        @Override
        public int errorCode() {
            return this.errorCode;
        }
    }

    private static interface NativeSslException {
        public int errorCode();
    }

    private final class DefaultOpenSslSession
    implements OpenSslInternalSession {
        private final OpenSslSessionContext sessionContext;
        private X509Certificate[] x509PeerCerts;
        private Certificate[] peerCerts;
        private boolean valid = true;
        private String protocol;
        private String cipher;
        private OpenSslSessionId id = OpenSslSessionId.NULL_ID;
        private long creationTime;
        private long lastAccessed = -1L;
        private volatile int applicationBufferSize = MAX_PLAINTEXT_LENGTH;
        private volatile Certificate[] localCertificateChain;
        private volatile Map<String, Object> keyValueStorage = new ConcurrentHashMap<String, Object>();

        DefaultOpenSslSession(OpenSslSessionContext openSslSessionContext) {
            this.sessionContext = openSslSessionContext;
        }

        private SSLSessionBindingEvent newSSLSessionBindingEvent(String string) {
            return new SSLSessionBindingEvent(ReferenceCountedOpenSslEngine.this.session, string);
        }

        @Override
        public void prepareHandshake() {
            this.keyValueStorage.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSessionDetails(long l2, long l3, OpenSslSessionId openSslSessionId, Map<String, Object> map) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (this.id == OpenSslSessionId.NULL_ID) {
                    this.id = openSslSessionId;
                    this.creationTime = l2;
                    this.lastAccessed = l3;
                    this.keyValueStorage = map;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OpenSslSessionId sessionId() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                byte[] byArray;
                if (this.id == OpenSslSessionId.NULL_ID && !ReferenceCountedOpenSslEngine.this.destroyed && (byArray = SSL.getSessionId((long)ReferenceCountedOpenSslEngine.this.ssl)) != null) {
                    this.id = new OpenSslSessionId(byArray);
                }
                return this.id;
            }
        }

        @Override
        public void setLocalCertificate(Certificate[] certificateArray) {
            this.localCertificateChain = certificateArray;
        }

        @Override
        public byte[] getId() {
            return this.sessionId().cloneBytes();
        }

        @Override
        public OpenSslSessionContext getSessionContext() {
            return this.sessionContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getCreationTime() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                return this.creationTime;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getLastAccessedTime() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                return this.lastAccessed == -1L ? this.creationTime : this.lastAccessed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidate() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                this.valid = false;
                this.sessionContext.removeFromCache(this.id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isValid() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                return this.valid || this.sessionContext.isInCache(this.id);
            }
        }

        @Override
        public void putValue(String string, Object object) {
            ObjectUtil.checkNotNull(string, "name");
            ObjectUtil.checkNotNull(object, "value");
            Object object2 = this.keyValueStorage.put(string, object);
            if (object instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)object).valueBound(this.newSSLSessionBindingEvent(string));
            }
            this.notifyUnbound(object2, string);
        }

        @Override
        public Object getValue(String string) {
            ObjectUtil.checkNotNull(string, "name");
            return this.keyValueStorage.get(string);
        }

        @Override
        public void removeValue(String string) {
            ObjectUtil.checkNotNull(string, "name");
            Object object = this.keyValueStorage.remove(string);
            this.notifyUnbound(object, string);
        }

        @Override
        public String[] getValueNames() {
            return this.keyValueStorage.keySet().toArray(EmptyArrays.EMPTY_STRINGS);
        }

        private void notifyUnbound(Object object, String string) {
            if (object instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)object).valueUnbound(this.newSSLSessionBindingEvent(string));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handshakeFinished(byte[] byArray, String string, String string2, byte[] byArray2, byte[][] byArray3, long l2, long l3) throws SSLException {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (!ReferenceCountedOpenSslEngine.this.destroyed) {
                    if (this.id == OpenSslSessionId.NULL_ID) {
                        this.id = byArray == null ? OpenSslSessionId.NULL_ID : new OpenSslSessionId(byArray);
                        this.creationTime = this.lastAccessed = l2;
                    }
                    this.cipher = ReferenceCountedOpenSslEngine.this.toJavaCipherSuite(string);
                    this.protocol = string2;
                    if (ReferenceCountedOpenSslEngine.this.clientMode) {
                        if (ReferenceCountedOpenSslEngine.isEmpty((Object[])byArray3)) {
                            this.peerCerts = EmptyArrays.EMPTY_CERTIFICATES;
                            this.x509PeerCerts = OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED ? EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES : JAVAX_CERTS_NOT_SUPPORTED;
                        } else {
                            this.peerCerts = new Certificate[byArray3.length];
                            this.x509PeerCerts = OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED ? new X509Certificate[byArray3.length] : JAVAX_CERTS_NOT_SUPPORTED;
                            this.initCerts(byArray3, 0);
                        }
                    } else if (ReferenceCountedOpenSslEngine.isEmpty(byArray2)) {
                        this.peerCerts = EmptyArrays.EMPTY_CERTIFICATES;
                        this.x509PeerCerts = EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES;
                    } else if (ReferenceCountedOpenSslEngine.isEmpty((Object[])byArray3)) {
                        this.peerCerts = new Certificate[]{new LazyX509Certificate(byArray2)};
                        this.x509PeerCerts = OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED ? new X509Certificate[]{new LazyJavaxX509Certificate(byArray2)} : JAVAX_CERTS_NOT_SUPPORTED;
                    } else {
                        this.peerCerts = new Certificate[byArray3.length + 1];
                        this.peerCerts[0] = new LazyX509Certificate(byArray2);
                        if (OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED) {
                            this.x509PeerCerts = new X509Certificate[byArray3.length + 1];
                            this.x509PeerCerts[0] = new LazyJavaxX509Certificate(byArray2);
                        } else {
                            this.x509PeerCerts = JAVAX_CERTS_NOT_SUPPORTED;
                        }
                        this.initCerts(byArray3, 1);
                    }
                } else {
                    throw new SSLException("Already closed");
                }
                ReferenceCountedOpenSslEngine.this.calculateMaxWrapOverhead();
                ReferenceCountedOpenSslEngine.this.handshakeState = HandshakeState.FINISHED;
            }
        }

        private void initCerts(byte[][] byArray, int n2) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                int n3 = n2 + i2;
                this.peerCerts[n3] = new LazyX509Certificate(byArray[i2]);
                if (this.x509PeerCerts == JAVAX_CERTS_NOT_SUPPORTED) continue;
                this.x509PeerCerts[n3] = new LazyJavaxX509Certificate(byArray[i2]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (ReferenceCountedOpenSslEngine.isEmpty(this.peerCerts)) {
                    throw new SSLPeerUnverifiedException("peer not verified");
                }
                return (Certificate[])this.peerCerts.clone();
            }
        }

        @Override
        public Certificate[] getLocalCertificates() {
            Certificate[] certificateArray = this.localCertificateChain;
            if (certificateArray == null) {
                return null;
            }
            return (Certificate[])certificateArray.clone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (this.x509PeerCerts == JAVAX_CERTS_NOT_SUPPORTED) {
                    throw new UnsupportedOperationException();
                }
                if (ReferenceCountedOpenSslEngine.isEmpty(this.x509PeerCerts)) {
                    throw new SSLPeerUnverifiedException("peer not verified");
                }
                return (X509Certificate[])this.x509PeerCerts.clone();
            }
        }

        @Override
        public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
            Certificate[] certificateArray = this.getPeerCertificates();
            return ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
        }

        @Override
        public Principal getLocalPrincipal() {
            Certificate[] certificateArray = this.localCertificateChain;
            if (certificateArray == null || certificateArray.length == 0) {
                return null;
            }
            return ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getCipherSuite() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (this.cipher == null) {
                    return "SSL_NULL_WITH_NULL_NULL";
                }
                return this.cipher;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getProtocol() {
            String string = this.protocol;
            if (string == null) {
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
                synchronized (referenceCountedOpenSslEngine) {
                    string = !ReferenceCountedOpenSslEngine.this.destroyed ? SSL.getVersion((long)ReferenceCountedOpenSslEngine.this.ssl) : "";
                }
            }
            return string;
        }

        @Override
        public String getPeerHost() {
            return ReferenceCountedOpenSslEngine.this.getPeerHost();
        }

        @Override
        public int getPeerPort() {
            return ReferenceCountedOpenSslEngine.this.getPeerPort();
        }

        @Override
        public int getPacketBufferSize() {
            return SSL.SSL_MAX_ENCRYPTED_LENGTH;
        }

        @Override
        public int getApplicationBufferSize() {
            return this.applicationBufferSize;
        }

        @Override
        public void tryExpandApplicationBufferSize(int n2) {
            if (n2 > MAX_PLAINTEXT_LENGTH && this.applicationBufferSize != MAX_RECORD_SIZE) {
                this.applicationBufferSize = MAX_RECORD_SIZE;
            }
        }

        public String toString() {
            return "DefaultOpenSslSession{sessionContext=" + this.sessionContext + ", id=" + this.id + '}';
        }

        public int hashCode() {
            return this.sessionId().hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof OpenSslInternalSession)) {
                return false;
            }
            return this.sessionId().equals(((OpenSslInternalSession)object).sessionId());
        }
    }

    private final class AsyncTaskDecorator
    implements AsyncRunnable,
    Runnable {
        private final AsyncTask task;

        AsyncTaskDecorator(AsyncTask asyncTask) {
            this.task = asyncTask;
        }

        @Override
        public void run(Runnable runnable) {
            if (ReferenceCountedOpenSslEngine.this.destroyed) {
                return;
            }
            this.task.runAsync(() -> ReferenceCountedOpenSslEngine.this.runAndResetNeedTask(runnable));
        }

        @Override
        public void run() {
            ReferenceCountedOpenSslEngine.this.runAndResetNeedTask((Runnable)this.task);
        }
    }

    private static enum HandshakeState {
        NOT_STARTED,
        STARTED_IMPLICITLY,
        STARTED_EXPLICITLY,
        FINISHED;

    }
}

