/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.ssl;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.PemEncoded;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.SslUtils;
import com.gradle.maven.extension.internal.dep.io.netty.util.AbstractReferenceCounted;
import com.gradle.maven.extension.internal.dep.io.netty.util.IllegalReferenceCountException;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;

class PemValue
extends AbstractReferenceCounted
implements PemEncoded {
    private final ByteBuf content;
    private final boolean sensitive;

    PemValue(ByteBuf byteBuf, boolean bl2) {
        this.content = ObjectUtil.checkNotNull(byteBuf, "content");
        this.sensitive = bl2;
    }

    @Override
    public boolean isSensitive() {
        return this.sensitive;
    }

    @Override
    public ByteBuf content() {
        int n2 = this.refCnt();
        if (n2 <= 0) {
            throw new IllegalReferenceCountException(n2);
        }
        return this.content;
    }

    @Override
    public PemValue touch() {
        return (PemValue)super.touch();
    }

    @Override
    public PemValue touch(Object object) {
        this.content.touch(object);
        return this;
    }

    @Override
    public PemValue retain() {
        return (PemValue)super.retain();
    }

    @Override
    protected void deallocate() {
        if (this.sensitive) {
            SslUtils.zeroout(this.content);
        }
        this.content.release();
    }
}

