/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.ssl;

import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslKeyMaterial;
import com.gradle.maven.extension.internal.dep.io.netty.internal.tcnative.SSL;
import com.gradle.maven.extension.internal.dep.io.netty.util.AbstractReferenceCounted;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.EmptyArrays;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

final class OpenSslPrivateKey
extends AbstractReferenceCounted
implements PrivateKey {
    private long privateKeyAddress;

    OpenSslPrivateKey(long l2) {
        this.privateKeyAddress = l2;
    }

    @Override
    public String getAlgorithm() {
        return "unknown";
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    protected void deallocate() {
        SSL.freePrivateKey((long)this.privateKeyAddress);
        this.privateKeyAddress = 0L;
    }

    @Override
    public OpenSslPrivateKey retain() {
        super.retain();
        return this;
    }

    @Override
    public OpenSslPrivateKey touch() {
        super.touch();
        return this;
    }

    @Override
    public OpenSslPrivateKey touch(Object object) {
        return this;
    }

    @Override
    public void destroy() {
        this.release(this.refCnt());
    }

    @Override
    public boolean isDestroyed() {
        return this.refCnt() == 0;
    }

    OpenSslKeyMaterial newKeyMaterial(long l2, X509Certificate[] x509CertificateArray) {
        return new OpenSslPrivateKeyMaterial(l2, x509CertificateArray);
    }

    final class OpenSslPrivateKeyMaterial
    extends AbstractReferenceCounted
    implements OpenSslKeyMaterial {
        long certificateChain;
        private final X509Certificate[] x509CertificateChain;

        OpenSslPrivateKeyMaterial(long l2, X509Certificate[] x509CertificateArray) {
            this.certificateChain = l2;
            this.x509CertificateChain = x509CertificateArray == null ? EmptyArrays.EMPTY_X509_CERTIFICATES : x509CertificateArray;
            OpenSslPrivateKey.this.retain();
        }

        @Override
        public OpenSslKeyMaterial touch(Object object) {
            OpenSslPrivateKey.this.touch(object);
            return this;
        }

        @Override
        public OpenSslKeyMaterial retain() {
            super.retain();
            return this;
        }

        @Override
        public OpenSslKeyMaterial touch() {
            OpenSslPrivateKey.this.touch();
            return this;
        }

        @Override
        protected void deallocate() {
            this.releaseChain();
            OpenSslPrivateKey.this.release();
        }

        private void releaseChain() {
            SSL.freeX509Chain((long)this.certificateChain);
            this.certificateChain = 0L;
        }
    }
}

