/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel.group;

import com.gradle.maven.extension.internal.dep.io.netty.channel.Channel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelId;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ServerChannel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.group.ChannelGroup;
import com.gradle.maven.extension.internal.dep.io.netty.channel.group.ChannelGroupFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.group.ChannelMatcher;
import com.gradle.maven.extension.internal.dep.io.netty.channel.group.ChannelMatchers;
import com.gradle.maven.extension.internal.dep.io.netty.channel.group.CombinedIterator;
import com.gradle.maven.extension.internal.dep.io.netty.channel.group.DefaultChannelGroupFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.group.VoidChannelGroupFuture;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.GenericFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.StringUtil;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultChannelGroup
extends AbstractSet<Channel>
implements ChannelGroup {
    private static final AtomicInteger nextId = new AtomicInteger();
    private final String name;
    private final EventExecutor executor;
    private final ConcurrentMap<ChannelId, Channel> serverChannels = new ConcurrentHashMap<ChannelId, Channel>();
    private final ConcurrentMap<ChannelId, Channel> nonServerChannels = new ConcurrentHashMap<ChannelId, Channel>();
    private final ChannelFutureListener remover = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            DefaultChannelGroup.this.remove(channelFuture.channel());
        }
    };
    private final VoidChannelGroupFuture voidFuture = new VoidChannelGroupFuture(this);
    private final boolean stayClosed;
    private volatile boolean closed;

    public DefaultChannelGroup(EventExecutor eventExecutor) {
        this(eventExecutor, false);
    }

    public DefaultChannelGroup(EventExecutor eventExecutor, boolean bl2) {
        this("group-0x" + Integer.toHexString(nextId.incrementAndGet()), eventExecutor, bl2);
    }

    public DefaultChannelGroup(String string, EventExecutor eventExecutor, boolean bl2) {
        ObjectUtil.checkNotNull(string, "name");
        this.name = string;
        this.executor = eventExecutor;
        this.stayClosed = bl2;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.nonServerChannels.isEmpty() && this.serverChannels.isEmpty();
    }

    @Override
    public int size() {
        return this.nonServerChannels.size() + this.serverChannels.size();
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof ServerChannel) {
            return this.serverChannels.containsValue(object);
        }
        if (object instanceof Channel) {
            return this.nonServerChannels.containsValue(object);
        }
        return false;
    }

    @Override
    public boolean add(Channel channel) {
        boolean bl2;
        ConcurrentMap<ChannelId, Channel> concurrentMap = channel instanceof ServerChannel ? this.serverChannels : this.nonServerChannels;
        boolean bl3 = bl2 = concurrentMap.putIfAbsent(channel.id(), channel) == null;
        if (bl2) {
            channel.closeFuture().addListener((GenericFutureListener)this.remover);
        }
        if (this.stayClosed && this.closed) {
            channel.close();
        }
        return bl2;
    }

    @Override
    public boolean remove(Object object) {
        Channel channel = null;
        if (object instanceof ChannelId) {
            channel = (Channel)this.nonServerChannels.remove(object);
            if (channel == null) {
                channel = (Channel)this.serverChannels.remove(object);
            }
        } else if (object instanceof Channel) {
            channel = (Channel)object;
            channel = channel instanceof ServerChannel ? (Channel)this.serverChannels.remove(channel.id()) : (Channel)this.nonServerChannels.remove(channel.id());
        }
        if (channel == null) {
            return false;
        }
        channel.closeFuture().removeListener((GenericFutureListener)this.remover);
        return true;
    }

    @Override
    public void clear() {
        this.nonServerChannels.clear();
        this.serverChannels.clear();
    }

    @Override
    public Iterator<Channel> iterator() {
        return new CombinedIterator<Channel>(this.serverChannels.values().iterator(), this.nonServerChannels.values().iterator());
    }

    @Override
    public Object[] toArray() {
        ArrayList arrayList = new ArrayList(this.size());
        arrayList.addAll(this.serverChannels.values());
        arrayList.addAll(this.nonServerChannels.values());
        return arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        ArrayList arrayList = new ArrayList(this.size());
        arrayList.addAll(this.serverChannels.values());
        arrayList.addAll(this.nonServerChannels.values());
        return arrayList.toArray(TArray);
    }

    @Override
    public ChannelGroupFuture close() {
        return this.close(ChannelMatchers.all());
    }

    public ChannelGroupFuture close(ChannelMatcher channelMatcher) {
        ObjectUtil.checkNotNull(channelMatcher, "matcher");
        LinkedHashMap<Channel, ChannelFuture> linkedHashMap = new LinkedHashMap<Channel, ChannelFuture>(this.size());
        if (this.stayClosed) {
            this.closed = true;
        }
        for (Channel channel : this.serverChannels.values()) {
            if (!channelMatcher.matches(channel)) continue;
            linkedHashMap.put(channel, channel.close());
        }
        for (Channel channel : this.nonServerChannels.values()) {
            if (!channelMatcher.matches(channel)) continue;
            linkedHashMap.put(channel, channel.close());
        }
        return new DefaultChannelGroupFuture(this, linkedHashMap, this.executor);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int compareTo(ChannelGroup channelGroup) {
        int n2 = this.name().compareTo(channelGroup.name());
        if (n2 != 0) {
            return n2;
        }
        return System.identityHashCode(this) - System.identityHashCode(channelGroup);
    }

    @Override
    public String toString() {
        return StringUtil.simpleClassName(this) + "(name: " + this.name() + ", size: " + this.size() + ')';
    }
}

