/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOutboundInvoker;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.PendingBytesTracker;
import com.gradle.maven.extension.internal.dep.io.netty.channel.VoidChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.util.Recycler;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.PromiseCombiner;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectPool;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;

public final class PendingWriteQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PendingWriteQueue.class);
    private static final int PENDING_WRITE_OVERHEAD = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.transport.pendingWriteSizeOverhead", 64);
    private final ChannelOutboundInvoker invoker;
    private final EventExecutor executor;
    private final PendingBytesTracker tracker;
    private PendingWrite head;
    private PendingWrite tail;
    private int size;
    private long bytes;

    public PendingWriteQueue(ChannelHandlerContext channelHandlerContext) {
        this.tracker = PendingBytesTracker.newTracker(channelHandlerContext.channel());
        this.invoker = channelHandlerContext;
        this.executor = channelHandlerContext.executor();
    }

    public boolean isEmpty() {
        assert (this.executor.inEventLoop());
        return this.head == null;
    }

    private int size(Object object) {
        int n2 = this.tracker.size(object);
        if (n2 < 0) {
            n2 = 0;
        }
        return n2 + PENDING_WRITE_OVERHEAD;
    }

    public void add(Object object, ChannelPromise channelPromise) {
        assert (this.executor.inEventLoop());
        ObjectUtil.checkNotNull(object, "msg");
        ObjectUtil.checkNotNull(channelPromise, "promise");
        int n2 = this.size(object);
        PendingWrite pendingWrite = PendingWrite.newInstance(object, n2, channelPromise);
        PendingWrite pendingWrite2 = this.tail;
        if (pendingWrite2 == null) {
            this.tail = this.head = pendingWrite;
        } else {
            pendingWrite2.next = pendingWrite;
            this.tail = pendingWrite;
        }
        ++this.size;
        this.bytes += (long)n2;
        this.tracker.incrementPendingOutboundBytes(pendingWrite.size);
        if (object instanceof AbstractReferenceCountedByteBuf) {
            ((AbstractReferenceCountedByteBuf)object).touch();
        } else {
            ReferenceCountUtil.touch(object);
        }
    }

    public ChannelFuture removeAndWriteAll() {
        assert (this.executor.inEventLoop());
        if (this.isEmpty()) {
            return null;
        }
        ChannelPromise channelPromise = this.invoker.newPromise();
        PromiseCombiner promiseCombiner = new PromiseCombiner(this.executor);
        try {
            PendingWrite pendingWrite = this.head;
            while (pendingWrite != null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
                this.bytes = 0L;
                while (pendingWrite != null) {
                    PendingWrite pendingWrite2 = pendingWrite.next;
                    Object object = pendingWrite.msg;
                    ChannelPromise channelPromise2 = pendingWrite.promise;
                    this.recycle(pendingWrite, false);
                    if (!(channelPromise2 instanceof VoidChannelPromise)) {
                        promiseCombiner.add(channelPromise2);
                    }
                    this.invoker.write(object, channelPromise2);
                    pendingWrite = pendingWrite2;
                }
                pendingWrite = this.head;
            }
            promiseCombiner.finish(channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
        this.assertEmpty();
        return channelPromise;
    }

    public void removeAndFailAll(Throwable throwable) {
        assert (this.executor.inEventLoop());
        ObjectUtil.checkNotNull(throwable, "cause");
        PendingWrite pendingWrite = this.head;
        while (pendingWrite != null) {
            this.tail = null;
            this.head = null;
            this.size = 0;
            this.bytes = 0L;
            while (pendingWrite != null) {
                PendingWrite pendingWrite2 = pendingWrite.next;
                ReferenceCountUtil.safeRelease(pendingWrite.msg);
                ChannelPromise channelPromise = pendingWrite.promise;
                this.recycle(pendingWrite, false);
                PendingWriteQueue.safeFail(channelPromise, throwable);
                pendingWrite = pendingWrite2;
            }
            pendingWrite = this.head;
        }
        this.assertEmpty();
    }

    private void assertEmpty() {
        assert (this.tail == null && this.head == null && this.size == 0);
    }

    private void recycle(PendingWrite pendingWrite, boolean bl2) {
        PendingWrite pendingWrite2 = pendingWrite.next;
        long l2 = pendingWrite.size;
        if (bl2) {
            if (pendingWrite2 == null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
                this.bytes = 0L;
            } else {
                this.head = pendingWrite2;
                --this.size;
                this.bytes -= l2;
                assert (this.size > 0 && this.bytes >= 0L);
            }
        }
        pendingWrite.recycle();
        this.tracker.decrementPendingOutboundBytes(l2);
    }

    private static void safeFail(ChannelPromise channelPromise, Throwable throwable) {
        if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.tryFailure(throwable)) {
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)channelPromise, (Object)throwable);
        }
    }

    static final class PendingWrite {
        private static final Recycler<PendingWrite> RECYCLER = new Recycler<PendingWrite>(){

            @Override
            protected PendingWrite newObject(Recycler.Handle<PendingWrite> handle) {
                return new PendingWrite(handle);
            }
        };
        private final ObjectPool.Handle<PendingWrite> handle;
        private PendingWrite next;
        private long size;
        private ChannelPromise promise;
        private Object msg;

        private PendingWrite(ObjectPool.Handle<PendingWrite> handle) {
            this.handle = handle;
        }

        static PendingWrite newInstance(Object object, int n2, ChannelPromise channelPromise) {
            PendingWrite pendingWrite = RECYCLER.get();
            pendingWrite.size = n2;
            pendingWrite.msg = object;
            pendingWrite.promise = channelPromise;
            return pendingWrite;
        }

        private void recycle() {
            this.size = 0L;
            this.next = null;
            this.msg = null;
            this.promise = null;
            this.handle.recycle(this);
        }
    }
}

