/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.SwappedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledDirectByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnsafeByteBufUtil;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnsafeDirectSwappedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.CleanableDirectBuffer;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class UnpooledUnsafeDirectByteBuf
extends UnpooledDirectByteBuf {
    long memoryAddress;

    public UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, int n2, int n3) {
        super(byteBufAllocator, n2, n3);
    }

    UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, int n2, int n3, boolean bl2) {
        super(byteBufAllocator, n2, n3, bl2);
    }

    protected UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n2) {
        super(byteBufAllocator, byteBuffer, n2, false, true);
    }

    @Override
    final void setByteBuffer(ByteBuffer byteBuffer, boolean bl2) {
        super.setByteBuffer(byteBuffer, bl2);
        this.memoryAddress = PlatformDependent.directBufferAddress(byteBuffer);
    }

    @Override
    final void setByteBuffer(CleanableDirectBuffer cleanableDirectBuffer, boolean bl2) {
        super.setByteBuffer(cleanableDirectBuffer, bl2);
        this.memoryAddress = PlatformDependent.directBufferAddress(cleanableDirectBuffer.buffer());
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    @Override
    public byte getByte(int n2) {
        this.checkIndex(n2);
        return this._getByte(n2);
    }

    @Override
    protected byte _getByte(int n2) {
        return UnsafeByteBufUtil.getByte(this.addr(n2));
    }

    @Override
    public short getShort(int n2) {
        this.checkIndex(n2, 2);
        return this._getShort(n2);
    }

    @Override
    protected short _getShort(int n2) {
        return UnsafeByteBufUtil.getShort(this.addr(n2));
    }

    @Override
    protected short _getShortLE(int n2) {
        return UnsafeByteBufUtil.getShortLE(this.addr(n2));
    }

    @Override
    public int getUnsignedMedium(int n2) {
        this.checkIndex(n2, 3);
        return this._getUnsignedMedium(n2);
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(n2));
    }

    @Override
    protected int _getUnsignedMediumLE(int n2) {
        return UnsafeByteBufUtil.getUnsignedMediumLE(this.addr(n2));
    }

    @Override
    public int getInt(int n2) {
        this.checkIndex(n2, 4);
        return this._getInt(n2);
    }

    @Override
    protected int _getInt(int n2) {
        return UnsafeByteBufUtil.getInt(this.addr(n2));
    }

    @Override
    protected int _getIntLE(int n2) {
        return UnsafeByteBufUtil.getIntLE(this.addr(n2));
    }

    @Override
    public long getLong(int n2) {
        this.checkIndex(n2, 8);
        return this._getLong(n2);
    }

    @Override
    protected long _getLong(int n2) {
        return UnsafeByteBufUtil.getLong(this.addr(n2));
    }

    @Override
    protected long _getLongLE(int n2) {
        return UnsafeByteBufUtil.getLongLE(this.addr(n2));
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(n2), n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    void getBytes(int n2, byte[] byArray, int n3, int n4, boolean bl2) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(n2), n2, byArray, n3, n4);
    }

    @Override
    void getBytes(int n2, ByteBuffer byteBuffer, boolean bl2) {
        UnsafeByteBufUtil.getBytes(this, this.addr(n2), n2, byteBuffer);
    }

    @Override
    public ByteBuf setByte(int n2, int n3) {
        this.checkIndex(n2);
        this._setByte(n2, n3);
        return this;
    }

    @Override
    protected void _setByte(int n2, int n3) {
        UnsafeByteBufUtil.setByte(this.addr(n2), n3);
    }

    @Override
    public ByteBuf setShort(int n2, int n3) {
        this.checkIndex(n2, 2);
        this._setShort(n2, n3);
        return this;
    }

    @Override
    protected void _setShort(int n2, int n3) {
        UnsafeByteBufUtil.setShort(this.addr(n2), n3);
    }

    @Override
    public ByteBuf setMedium(int n2, int n3) {
        this.checkIndex(n2, 3);
        this._setMedium(n2, n3);
        return this;
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        UnsafeByteBufUtil.setMedium(this.addr(n2), n3);
    }

    @Override
    public ByteBuf setInt(int n2, int n3) {
        this.checkIndex(n2, 4);
        this._setInt(n2, n3);
        return this;
    }

    @Override
    protected void _setInt(int n2, int n3) {
        UnsafeByteBufUtil.setInt(this.addr(n2), n3);
    }

    @Override
    public ByteBuf setLong(int n2, long l2) {
        this.checkIndex(n2, 8);
        this._setLong(n2, l2);
        return this;
    }

    @Override
    protected void _setLong(int n2, long l2) {
        UnsafeByteBufUtil.setLong(this.addr(n2), l2);
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(n2), n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(n2), n2, byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        UnsafeByteBufUtil.setBytes(this, this.addr(n2), n2, byteBuffer);
        return this;
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) throws IOException {
        return UnsafeByteBufUtil.setBytes(this, this.addr(n2), n2, inputStream, n3);
    }

    final long addr(int n2) {
        return this.memoryAddress + (long)n2;
    }

    @Override
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    @Override
    public ByteBuf setZero(int n2, int n3) {
        this.checkIndex(n2, n3);
        UnsafeByteBufUtil.setZero(this.addr(n2), n3);
        return this;
    }
}

