/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.HeapByteBufUtil;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PooledByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.util.Recycler;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectPool;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

class PooledHeapByteBuf
extends PooledByteBuf<byte[]> {
    private static final Recycler<PooledHeapByteBuf> RECYCLER = new Recycler<PooledHeapByteBuf>(){

        @Override
        protected PooledHeapByteBuf newObject(Recycler.Handle<PooledHeapByteBuf> handle) {
            return new PooledHeapByteBuf((ObjectPool.Handle<? extends PooledHeapByteBuf>)handle, 0);
        }
    };

    static PooledHeapByteBuf newInstance(int n2) {
        PooledHeapByteBuf pooledHeapByteBuf = RECYCLER.get();
        pooledHeapByteBuf.reuse(n2);
        return pooledHeapByteBuf;
    }

    PooledHeapByteBuf(ObjectPool.Handle<? extends PooledHeapByteBuf> handle, int n2) {
        super(handle, n2);
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    @Override
    protected byte _getByte(int n2) {
        return HeapByteBufUtil.getByte((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected short _getShort(int n2) {
        return HeapByteBufUtil.getShort((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected short _getShortLE(int n2) {
        return HeapByteBufUtil.getShortLE((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        return HeapByteBufUtil.getUnsignedMedium((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected int _getUnsignedMediumLE(int n2) {
        return HeapByteBufUtil.getUnsignedMediumLE((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected int _getInt(int n2) {
        return HeapByteBufUtil.getInt((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected int _getIntLE(int n2) {
        return HeapByteBufUtil.getIntLE((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected long _getLong(int n2) {
        return HeapByteBufUtil.getLong((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected long _getLongLE(int n2) {
        return HeapByteBufUtil.getLongLE((byte[])this.memory, this.idx(n2));
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress() && PlatformDependent.hasUnsafe()) {
            PlatformDependent.copyMemory((byte[])this.memory, this.idx(n2), byteBuf.memoryAddress() + (long)n3, (long)n4);
        } else if (byteBuf.hasArray()) {
            this.getBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else {
            byteBuf.setBytes(n3, (byte[])this.memory, this.idx(n2), n4);
        }
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        System.arraycopy(this.memory, this.idx(n2), byArray, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        int n3 = byteBuffer.remaining();
        this.checkIndex(n2, n3);
        byteBuffer.put((byte[])this.memory, this.idx(n2), n3);
        return this;
    }

    @Override
    protected void _setByte(int n2, int n3) {
        HeapByteBufUtil.setByte((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setShort(int n2, int n3) {
        HeapByteBufUtil.setShort((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        HeapByteBufUtil.setMedium((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setInt(int n2, int n3) {
        HeapByteBufUtil.setInt((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setLong(int n2, long l2) {
        HeapByteBufUtil.setLong((byte[])this.memory, this.idx(n2), l2);
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress() && PlatformDependent.hasUnsafe()) {
            PlatformDependent.copyMemory(byteBuf.memoryAddress() + (long)n3, (byte[])this.memory, this.idx(n2), (long)n4);
        } else if (byteBuf.hasArray()) {
            this.setBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else {
            byteBuf.getBytes(n3, (byte[])this.memory, this.idx(n2), n4);
        }
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byArray.length);
        System.arraycopy(byArray, n3, this.memory, this.idx(n2), n4);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        int n3 = byteBuffer.remaining();
        this.checkIndex(n2, n3);
        byteBuffer.get((byte[])this.memory, this.idx(n2), n3);
        return this;
    }

    @Override
    public final int setBytes(int n2, InputStream inputStream, int n3) throws IOException {
        this.checkIndex(n2, n3);
        return inputStream.read((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    final ByteBuffer duplicateInternalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return ByteBuffer.wrap((byte[])this.memory, this.idx(n2), n3).slice();
    }

    @Override
    public final boolean hasArray() {
        return true;
    }

    @Override
    public final byte[] array() {
        this.ensureAccessible();
        return (byte[])this.memory;
    }

    @Override
    public final int arrayOffset() {
        return this.offset;
    }

    @Override
    public final boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final ByteBuffer newInternalNioBuffer(byte[] byArray) {
        return ByteBuffer.wrap(byArray);
    }
}

