/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.dev.failsafe;

import com.gradle.maven.extension.internal.dep.dev.failsafe.ExecutionImpl;
import com.gradle.maven.extension.internal.dep.dev.failsafe.Functions;
import com.gradle.maven.extension.internal.dep.dev.failsafe.Policy;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.AsyncExecutionInternal;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.ExecutionResult;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.FailsafeFuture;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.PolicyExecutor;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.Scheduler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;

final class AsyncExecutionImpl<R>
extends ExecutionImpl<R>
implements AsyncExecutionInternal<R> {
    private final FailsafeFuture<R> future;
    private final boolean asyncExecution;
    private Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> outerFn;
    private final boolean[] policyPostExecuted;
    private volatile boolean recorded;

    AsyncExecutionImpl(List<Policy<R>> list, Scheduler scheduler, FailsafeFuture<R> failsafeFuture, boolean bl2, Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> function) {
        super(list);
        this.policyPostExecuted = new boolean[this.policyExecutors.size()];
        this.future = failsafeFuture;
        this.asyncExecution = bl2;
        this.outerFn = bl2 ? Functions.toExecutionAware(function) : function;
        this.outerFn = Functions.toAsync(this.outerFn, scheduler, failsafeFuture);
        for (PolicyExecutor policyExecutor : this.policyExecutors) {
            this.outerFn = policyExecutor.applyAsync(this.outerFn, scheduler, failsafeFuture);
        }
    }

    private AsyncExecutionImpl(AsyncExecutionImpl<R> asyncExecutionImpl) {
        super(asyncExecutionImpl);
        this.policyPostExecuted = new boolean[this.policyExecutors.size()];
        this.outerFn = asyncExecutionImpl.outerFn;
        this.future = asyncExecutionImpl.future;
        this.asyncExecution = asyncExecutionImpl.asyncExecution;
    }

    @Override
    public boolean isAsyncExecution() {
        return this.asyncExecution;
    }

    @Override
    public boolean isRecorded() {
        return this.recorded;
    }

    @Override
    public synchronized void setPostExecuted(int n2) {
        this.policyPostExecuted[n2] = true;
    }

    @Override
    public synchronized boolean isPostExecuted(int n2) {
        return this.policyPostExecuted[n2];
    }

    @Override
    public AsyncExecutionInternal<R> copy() {
        return new AsyncExecutionImpl<R>(this);
    }

    void executeAsync() {
        this.outerFn.apply(this).whenComplete(this::complete);
    }

    private void complete(ExecutionResult<R> executionResult, Throwable throwable) {
        if (executionResult == null && throwable == null) {
            return;
        }
        this.completed = true;
        if (!this.future.isDone()) {
            if (executionResult != null) {
                this.future.completeResult(executionResult);
            } else {
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                this.future.completeResult(ExecutionResult.exception(throwable));
            }
        }
    }
}

