/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaAnnotation;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.AbstractJavaModel;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultJavaAnnotation
extends AbstractJavaModel
implements JavaAnnotation,
AnnotationValue,
Serializable {
    private final JavaClass type;
    private final Map<String, AnnotationValue> properties = new LinkedHashMap<String, AnnotationValue>();
    private final Map<String, Object> namedParameters = new LinkedHashMap<String, Object>();

    public DefaultJavaAnnotation(JavaClass javaClass, Map<String, Object> map) {
        this.type = javaClass;
        if (this.properties != null) {
            for (Map.Entry<String, AnnotationValue> entry : this.properties.entrySet()) {
                String string = entry.getKey();
                AnnotationValue annotationValue = entry.getValue();
                this.setProperty(string, annotationValue);
            }
        }
    }

    public DefaultJavaAnnotation(JavaClass javaClass) {
        this(javaClass, null);
    }

    public final void setProperty(String string, AnnotationValue annotationValue) {
        this.properties.put(string, annotationValue);
        this.namedParameters.put(string, annotationValue.getParameterValue());
    }

    @Override
    public JavaClass getType() {
        return this.type;
    }

    @Override
    public DefaultJavaAnnotation getParameterValue() {
        return this;
    }

    @Override
    public Map<String, AnnotationValue> getPropertyMap() {
        return this.properties;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('@');
        stringBuilder.append(this.type.getFullyQualifiedName());
        stringBuilder.append('(');
        if (!this.namedParameters.isEmpty()) {
            Iterator<Map.Entry<String, Object>> iterator = this.namedParameters.entrySet().iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

