/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.AbstractClassLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.SourceLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaModule;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;

public class SourceFolderLibrary
extends SourceLibrary {
    private List<File> sourceFolders = new LinkedList<File>();

    public SourceFolderLibrary(AbstractClassLibrary abstractClassLibrary) {
        super(abstractClassLibrary);
    }

    public JavaModule addSourceFolder(File file) {
        this.sourceFolders.add(file);
        return this.resolveJavaModule(file);
    }

    private JavaModule resolveJavaModule(File file) {
        JavaModule javaModule = null;
        File file2 = new File(file, "module-info.java");
        if (file2.isFile()) {
            try {
                javaModule = this.parse(new FileReader(file2), file2.toURI().toURL()).getModuleInfo();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return javaModule;
    }

    @Override
    protected JavaClass resolveJavaClass(String string) {
        JavaClass javaClass = super.resolveJavaClass(string);
        String string2 = string.split("\\$")[0];
        File file = this.getSourceFile(string2);
        if (file != null) {
            javaClass = this.getClassFromSourceFile(file, string);
        }
        return javaClass;
    }

    @Override
    protected boolean containsClassReference(String string) {
        String string2;
        File file;
        boolean bl2 = super.containsClassReference(string);
        if (!bl2 && (file = this.getSourceFile(string2 = string.split("\\$")[0])) != null) {
            bl2 = string2.equals(string) ? true : this.getClassFromSourceFile(file, string) != null;
        }
        return bl2;
    }

    private File getSourceFile(String string) {
        for (File file : this.sourceFolders) {
            File file2 = new File(file, string.replace('.', File.separatorChar) + ".java");
            if (!file2.isFile()) continue;
            return file2;
        }
        return null;
    }

    private JavaClass getClassFromSourceFile(File file, String string) {
        try {
            JavaSource javaSource = this.parse(new FileReader(file), file.toURI().toURL()).getSource();
            return javaSource.getClassByName(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }
}

