/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.builder.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.builder.Builder;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.builder.TypeAssembler;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.builder.impl.DefaultJavaAnnotationAssembler;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.ClassLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.DocletTag;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.DocletTagFactory;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaAnnotation;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaConstructor;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaExecutable;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaGenericDeclaration;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaMethod;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaModule;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaParameter;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaSource;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaType;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaTypeVariable;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.expression.Expression;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.AbstractBaseJavaEntity;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaConstructor;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaField;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaInitializer;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaMethod;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaModule;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaModuleDescriptor;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaPackage;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaParameter;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaSource;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaType;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaTypeVariable;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.expression.ExpressionDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.AnnoDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.ClassDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.CompactConstructorDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.FieldDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.InitDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.MethodDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.ModuleDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.PackageDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.RecordFieldsDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.TagDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.TypeDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.TypeVariableDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.type.TypeResolver;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.writer.ModelWriterFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ModelBuilder
implements Builder {
    private final DefaultJavaSource source;
    private DefaultJavaModule module;
    private DefaultJavaModuleDescriptor moduleDescriptor;
    private LinkedList<DefaultJavaClass> classStack = new LinkedList();
    private LinkedList<DefaultJavaConstructor> recordHeaderStack = new LinkedList();
    private List<DefaultJavaParameter> parameterList = new LinkedList<DefaultJavaParameter>();
    private DefaultJavaConstructor currentConstructor;
    private DefaultJavaMethod currentMethod;
    private DefaultJavaField currentField;
    private List<AnnoDef> currentAnnoDefs;
    private List<ExpressionDef> currentArguments;
    private String lastComment;
    private List<TagDef> lastTagSet = new LinkedList<TagDef>();
    private ClassLibrary classLibrary;
    private DocletTagFactory docletTagFactory;
    private ModelWriterFactory modelWriterFactory;

    public ModelBuilder(ClassLibrary classLibrary, DocletTagFactory docletTagFactory) {
        this.classLibrary = classLibrary;
        this.docletTagFactory = docletTagFactory;
        this.source = new DefaultJavaSource(classLibrary);
        this.currentAnnoDefs = new LinkedList<AnnoDef>();
        this.currentArguments = new LinkedList<ExpressionDef>();
    }

    public void setModelWriterFactory(ModelWriterFactory modelWriterFactory) {
        this.modelWriterFactory = modelWriterFactory;
        this.source.setModelWriterFactory(modelWriterFactory);
    }

    @Override
    public void setModule(ModuleDef moduleDef) {
        this.moduleDescriptor = new DefaultJavaModuleDescriptor(moduleDef.getName());
        this.module = new DefaultJavaModule(moduleDef.getName(), this.moduleDescriptor);
    }

    @Override
    public void addExports(ModuleDef.ExportsDef exportsDef) {
        ArrayList<JavaModule> arrayList = new ArrayList<JavaModule>(exportsDef.getTargets().size());
        for (String string : exportsDef.getTargets()) {
            arrayList.add(new DefaultJavaModule(string, null));
        }
        DefaultJavaModuleDescriptor.DefaultJavaExports defaultJavaExports = new DefaultJavaModuleDescriptor.DefaultJavaExports(new DefaultJavaPackage(exportsDef.getSource()), arrayList);
        defaultJavaExports.setLineNumber(exportsDef.getLineNumber());
        defaultJavaExports.setModelWriterFactory(this.modelWriterFactory);
        this.moduleDescriptor.addExports(defaultJavaExports);
    }

    @Override
    public void addOpens(ModuleDef.OpensDef opensDef) {
        ArrayList<JavaModule> arrayList = new ArrayList<JavaModule>(opensDef.getTargets().size());
        for (String string : opensDef.getTargets()) {
            arrayList.add(new DefaultJavaModule(string, null));
        }
        DefaultJavaModuleDescriptor.DefaultJavaOpens defaultJavaOpens = new DefaultJavaModuleDescriptor.DefaultJavaOpens(new DefaultJavaPackage(opensDef.getSource()), arrayList);
        defaultJavaOpens.setLineNumber(opensDef.getLineNumber());
        defaultJavaOpens.setModelWriterFactory(this.modelWriterFactory);
        this.moduleDescriptor.addOpens(defaultJavaOpens);
    }

    @Override
    public void addProvides(ModuleDef.ProvidesDef providesDef) {
        DefaultJavaType defaultJavaType = this.createType(providesDef.getService(), 0);
        LinkedList<JavaClass> linkedList = new LinkedList<JavaClass>();
        for (TypeDef typeDef : providesDef.getImplementations()) {
            linkedList.add(this.createType(typeDef, 0));
        }
        DefaultJavaModuleDescriptor.DefaultJavaProvides defaultJavaProvides = new DefaultJavaModuleDescriptor.DefaultJavaProvides(defaultJavaType, linkedList);
        defaultJavaProvides.setLineNumber(providesDef.getLineNumber());
        defaultJavaProvides.setModelWriterFactory(this.modelWriterFactory);
        this.moduleDescriptor.addProvides(defaultJavaProvides);
    }

    @Override
    public void addRequires(ModuleDef.RequiresDef requiresDef) {
        DefaultJavaModule defaultJavaModule = new DefaultJavaModule(requiresDef.getName(), null);
        DefaultJavaModuleDescriptor.DefaultJavaRequires defaultJavaRequires = new DefaultJavaModuleDescriptor.DefaultJavaRequires(defaultJavaModule, requiresDef.getModifiers());
        defaultJavaRequires.setLineNumber(requiresDef.getLineNumber());
        defaultJavaRequires.setModelWriterFactory(this.modelWriterFactory);
        this.moduleDescriptor.addRequires(defaultJavaRequires);
    }

    @Override
    public void addUses(ModuleDef.UsesDef usesDef) {
        DefaultJavaModuleDescriptor.DefaultJavaUses defaultJavaUses = new DefaultJavaModuleDescriptor.DefaultJavaUses(this.createType(usesDef.getService(), 0));
        defaultJavaUses.setLineNumber(usesDef.getLineNumber());
        defaultJavaUses.setModelWriterFactory(this.modelWriterFactory);
        this.moduleDescriptor.addUses(defaultJavaUses);
    }

    @Override
    public void addPackage(PackageDef packageDef) {
        DefaultJavaPackage defaultJavaPackage = new DefaultJavaPackage(packageDef.getName());
        defaultJavaPackage.setClassLibrary(this.classLibrary);
        defaultJavaPackage.setLineNumber(packageDef.getLineNumber());
        defaultJavaPackage.setModelWriterFactory(this.modelWriterFactory);
        this.addJavaDoc(defaultJavaPackage);
        this.setAnnotations(defaultJavaPackage);
        this.source.setPackage(defaultJavaPackage);
    }

    @Override
    public void addImport(String string) {
        this.source.addImport(string);
    }

    @Override
    public void addImplements(Set<TypeDef> set) {
        LinkedList<JavaClass> linkedList = new LinkedList<JavaClass>();
        for (TypeDef typeDef : set) {
            linkedList.add(this.createType(typeDef, 0));
        }
        this.classStack.getFirst().setImplementz(linkedList);
    }

    @Override
    public void addJavaDoc(String string) {
        this.lastComment = string;
    }

    @Override
    public void addJavaDocTag(TagDef tagDef) {
        this.lastTagSet.add(tagDef);
    }

    @Override
    public void beginClass(ClassDef classDef) {
        DefaultJavaClass defaultJavaClass = new DefaultJavaClass(this.source);
        defaultJavaClass.setLineNumber(classDef.getLineNumber());
        defaultJavaClass.setModelWriterFactory(this.modelWriterFactory);
        defaultJavaClass.setName(classDef.getName());
        defaultJavaClass.setInterface("interface".equals(classDef.getType()));
        defaultJavaClass.setEnum("enum".equals(classDef.getType()));
        defaultJavaClass.setRecord("record".equals(classDef.getType()));
        defaultJavaClass.setAnnotation("@interface".equals(classDef.getType()));
        if (defaultJavaClass.isInterface()) {
            defaultJavaClass.setSuperClass(null);
        } else if (!defaultJavaClass.isEnum()) {
            defaultJavaClass.setSuperClass(classDef.getExtends().size() > 0 ? this.createType(classDef.getExtends().iterator().next(), 0) : null);
        }
        Set<TypeDef> set = defaultJavaClass.isInterface() ? classDef.getExtends() : classDef.getImplements();
        LinkedList<JavaClass> linkedList = new LinkedList<JavaClass>();
        for (TypeDef object : set) {
            linkedList.add(this.createType(object, 0));
        }
        defaultJavaClass.setImplementz(linkedList);
        defaultJavaClass.setModifiers(new LinkedList<String>(classDef.getModifiers()));
        if (classDef.getTypeParameters() != null) {
            LinkedList linkedList2 = new LinkedList();
            for (TypeVariableDef typeVariableDef : classDef.getTypeParameters()) {
                linkedList2.add(this.createTypeVariable(typeVariableDef, defaultJavaClass));
            }
            defaultJavaClass.setTypeParameters(linkedList2);
        }
        this.addJavaDoc(defaultJavaClass);
        this.setAnnotations(defaultJavaClass);
        this.classStack.addFirst(this.bindClass(defaultJavaClass));
    }

    protected DefaultJavaClass bindClass(DefaultJavaClass defaultJavaClass) {
        if (this.currentField != null) {
            this.classStack.getFirst().addClass(defaultJavaClass);
            this.currentField.setEnumConstantClass(defaultJavaClass);
        } else if (!this.classStack.isEmpty()) {
            this.classStack.getFirst().addClass(defaultJavaClass);
            defaultJavaClass.setDeclaringClass(this.classStack.getFirst());
        } else {
            this.source.addClass(defaultJavaClass);
        }
        return defaultJavaClass;
    }

    @Override
    public void endClass() {
        this.classStack.removeFirst();
    }

    @Override
    public void endRecord(RecordFieldsDef recordFieldsDef) {
        DefaultJavaClass defaultJavaClass = this.classStack.getFirst();
        for (FieldDef fieldDef : recordFieldsDef.getFields()) {
            int n2 = fieldDef.isVarArgs() ? fieldDef.getDimensions() + 1 : fieldDef.getDimensions();
            FieldDef fieldDef2 = new FieldDef();
            fieldDef2.setName(fieldDef.getName());
            fieldDef2.setType(fieldDef.getType());
            fieldDef2.setDimensions(n2);
            fieldDef2.setEnumConstant(false);
            fieldDef2.getModifiers().addAll(fieldDef.getModifiers());
            fieldDef2.getModifiers().add("private");
            fieldDef2.getModifiers().add("final");
            fieldDef2.setLineNumber(fieldDef.getLineNumber());
            this.beginField(fieldDef2);
            this.endField();
            if (defaultJavaClass.getMethod(fieldDef.getName(), new LinkedList<JavaType>(), false) != null) continue;
            MethodDef methodDef = new MethodDef();
            methodDef.setName(fieldDef.getName());
            methodDef.setLineNumber(fieldDef.getLineNumber());
            methodDef.setReturnType(fieldDef.getType());
            methodDef.getModifiers().add("public");
            methodDef.setDimensions(n2);
            methodDef.setTypeParams(new LinkedList<TypeVariableDef>());
            methodDef.setLineNumber(fieldDef.getLineNumber());
            this.beginMethod();
            this.endMethod(methodDef);
        }
        this.recordHeaderStack.removeFirst();
        this.classStack.removeFirst();
    }

    private DefaultJavaType createType(TypeDef typeDef, int n2) {
        if (typeDef == null) {
            return null;
        }
        TypeResolver typeResolver = this.classStack.isEmpty() ? TypeResolver.byPackageName(this.source.getPackageName(), this.classLibrary, this.source.getImports()) : TypeResolver.byClassName(this.classStack.getFirst().getBinaryName(), this.classLibrary, this.source.getImports());
        return TypeAssembler.createUnresolved(typeDef, n2, typeResolver);
    }

    private void addJavaDoc(AbstractBaseJavaEntity abstractBaseJavaEntity) {
        abstractBaseJavaEntity.setComment(this.lastComment);
        LinkedList<DocletTag> linkedList = new LinkedList<DocletTag>();
        for (TagDef tagDef : this.lastTagSet) {
            linkedList.add(this.docletTagFactory.createDocletTag(tagDef.getName(), tagDef.getText(), (JavaAnnotatedElement)((Object)abstractBaseJavaEntity), tagDef.getLineNumber()));
        }
        abstractBaseJavaEntity.setTags(linkedList);
        this.lastTagSet.clear();
        this.lastComment = null;
    }

    @Override
    public void addInitializer(InitDef initDef) {
        DefaultJavaInitializer defaultJavaInitializer = new DefaultJavaInitializer();
        defaultJavaInitializer.setLineNumber(initDef.getLineNumber());
        defaultJavaInitializer.setBlock(initDef.getBlockContent());
        defaultJavaInitializer.setStatic(initDef.isStatic());
        this.classStack.getFirst().addInitializer(defaultJavaInitializer);
    }

    @Override
    public void beginConstructor() {
        this.currentConstructor = new DefaultJavaConstructor();
        this.currentConstructor.setDeclaringClass(this.classStack.getFirst());
        this.currentConstructor.setModelWriterFactory(this.modelWriterFactory);
        this.addJavaDoc(this.currentConstructor);
        this.setAnnotations(this.currentConstructor);
        DefaultJavaClass defaultJavaClass = this.classStack.getFirst();
        if (defaultJavaClass.isRecord() && defaultJavaClass.getConstructors().isEmpty()) {
            this.recordHeaderStack.addFirst(this.currentConstructor);
        }
        defaultJavaClass.addConstructor(this.currentConstructor);
    }

    @Override
    public void endConstructor(MethodDef methodDef) {
        LinkedList<JavaTypeVariable<JavaConstructor>> linkedList;
        this.currentConstructor.setLineNumber(methodDef.getLineNumber());
        this.currentConstructor.setName(methodDef.getName());
        if (methodDef.getTypeParams() != null) {
            linkedList = new LinkedList<JavaTypeVariable<JavaConstructor>>();
            for (TypeVariableDef object : methodDef.getTypeParams()) {
                linkedList.add(this.createTypeVariable(object, this.currentConstructor));
            }
            this.currentConstructor.setTypeParameters(linkedList);
        }
        linkedList = new LinkedList();
        for (TypeDef typeDef : methodDef.getExceptions()) {
            linkedList.add((JavaTypeVariable<JavaConstructor>)((Object)this.createType(typeDef, 0)));
        }
        this.currentConstructor.setExceptions(linkedList);
        this.currentConstructor.setModifiers(new LinkedList<String>(methodDef.getModifiers()));
        if (!this.parameterList.isEmpty()) {
            this.currentConstructor.setParameters(new ArrayList<JavaParameter>(this.parameterList));
            this.parameterList.clear();
        }
        this.currentConstructor.setSourceCode(methodDef.getBody());
    }

    @Override
    public void addCompactConstructor(CompactConstructorDef compactConstructorDef) {
        DefaultJavaConstructor defaultJavaConstructor = this.recordHeaderStack.getFirst();
        defaultJavaConstructor.setModifiers(new LinkedList<String>(compactConstructorDef.getModifiers()));
        defaultJavaConstructor.setSourceCode(compactConstructorDef.getBody());
        defaultJavaConstructor.setLineNumber(compactConstructorDef.getLineNumber());
    }

    @Override
    public void beginMethod() {
        this.currentMethod = new DefaultJavaMethod();
        if (this.currentField == null) {
            this.currentMethod.setDeclaringClass(this.classStack.getFirst());
            this.classStack.getFirst().addMethod(this.currentMethod);
        }
        this.currentMethod.setModelWriterFactory(this.modelWriterFactory);
        this.addJavaDoc(this.currentMethod);
        this.setAnnotations(this.currentMethod);
    }

    @Override
    public void endMethod(MethodDef methodDef) {
        LinkedList<JavaTypeVariable<JavaMethod>> linkedList;
        this.currentMethod.setLineNumber(methodDef.getLineNumber());
        this.currentMethod.setName(methodDef.getName());
        this.currentMethod.setReturns(this.createType(methodDef.getReturnType(), methodDef.getDimensions()));
        if (methodDef.getTypeParams() != null) {
            linkedList = new LinkedList<JavaTypeVariable<JavaMethod>>();
            for (TypeVariableDef object : methodDef.getTypeParams()) {
                linkedList.add(this.createTypeVariable(object, this.currentMethod));
            }
            this.currentMethod.setTypeParameters(linkedList);
        }
        linkedList = new LinkedList();
        for (TypeDef typeDef : methodDef.getExceptions()) {
            linkedList.add((JavaTypeVariable<JavaMethod>)((Object)this.createType(typeDef, 0)));
        }
        this.currentMethod.setExceptions(linkedList);
        this.currentMethod.setDefault(methodDef.getModifiers().remove("default"));
        this.currentMethod.setModifiers(new LinkedList<String>(methodDef.getModifiers()));
        if (!this.parameterList.isEmpty()) {
            this.currentMethod.setParameters(new ArrayList<JavaParameter>(this.parameterList));
            this.parameterList.clear();
        }
        this.currentMethod.setSourceCode(methodDef.getBody());
    }

    private <G extends JavaGenericDeclaration> DefaultJavaTypeVariable<G> createTypeVariable(TypeVariableDef typeVariableDef, G g2) {
        if (typeVariableDef == null) {
            return null;
        }
        JavaClass javaClass = ModelBuilder.getContext(g2);
        if (javaClass == null) {
            return null;
        }
        TypeResolver typeResolver = TypeResolver.byClassName(javaClass.getBinaryName(), this.classLibrary, this.source.getImports());
        DefaultJavaTypeVariable defaultJavaTypeVariable = new DefaultJavaTypeVariable(typeVariableDef.getName(), typeResolver);
        if (typeVariableDef.getBounds() != null && !typeVariableDef.getBounds().isEmpty()) {
            LinkedList<JavaType> linkedList = new LinkedList<JavaType>();
            for (TypeDef typeDef : typeVariableDef.getBounds()) {
                linkedList.add(this.createType(typeDef, 0));
            }
            defaultJavaTypeVariable.setBounds(linkedList);
        }
        return defaultJavaTypeVariable;
    }

    private static JavaClass getContext(JavaGenericDeclaration javaGenericDeclaration) {
        JavaClass javaClass;
        if (javaGenericDeclaration instanceof JavaClass) {
            javaClass = (JavaClass)javaGenericDeclaration;
        } else if (javaGenericDeclaration instanceof JavaExecutable) {
            javaClass = ((JavaExecutable)javaGenericDeclaration).getDeclaringClass();
        } else {
            throw new IllegalArgumentException("Unknown JavaGenericDeclaration implementation");
        }
        return javaClass;
    }

    @Override
    public void beginField(FieldDef fieldDef) {
        this.currentField = new DefaultJavaField(fieldDef.getName());
        this.currentField.setDeclaringClass(this.classStack.getFirst());
        this.currentField.setLineNumber(fieldDef.getLineNumber());
        this.currentField.setModelWriterFactory(this.modelWriterFactory);
        this.currentField.setType(this.createType(fieldDef.getType(), fieldDef.getDimensions()));
        this.currentField.setEnumConstant(fieldDef.isEnumConstant());
        this.currentField.setModifiers(new LinkedList<String>(fieldDef.getModifiers()));
        this.currentField.setInitializationExpression(fieldDef.getBody());
        this.addJavaDoc(this.currentField);
        this.setAnnotations(this.currentField);
    }

    @Override
    public void endField() {
        if (this.currentArguments != null && !this.currentArguments.isEmpty()) {
            TypeResolver typeResolver = this.classStack.isEmpty() ? TypeResolver.byPackageName(this.source.getPackageName(), this.classLibrary, this.source.getImports()) : TypeResolver.byClassName(this.classStack.getFirst().getBinaryName(), this.classLibrary, this.source.getImports());
            DefaultJavaAnnotationAssembler defaultJavaAnnotationAssembler = new DefaultJavaAnnotationAssembler(this.currentField.getDeclaringClass(), this.classLibrary, typeResolver);
            LinkedList<Expression> linkedList = new LinkedList<Expression>();
            for (ExpressionDef expressionDef : this.currentArguments) {
                linkedList.add(defaultJavaAnnotationAssembler.assemble(expressionDef));
            }
            this.currentField.setEnumConstantArguments(linkedList);
            this.currentArguments.clear();
        }
        this.classStack.getFirst().addField(this.currentField);
        this.currentField = null;
    }

    @Override
    public void addParameter(FieldDef fieldDef) {
        DefaultJavaParameter defaultJavaParameter = new DefaultJavaParameter(this.createType(fieldDef.getType(), fieldDef.getDimensions()), fieldDef.getName(), fieldDef.isVarArgs());
        if (this.currentMethod != null) {
            defaultJavaParameter.setExecutable(this.currentMethod);
        } else {
            defaultJavaParameter.setExecutable(this.currentConstructor);
        }
        defaultJavaParameter.setModelWriterFactory(this.modelWriterFactory);
        this.addJavaDoc(defaultJavaParameter);
        this.setAnnotations(defaultJavaParameter);
        this.parameterList.add(defaultJavaParameter);
    }

    private void setAnnotations(AbstractBaseJavaEntity abstractBaseJavaEntity) {
        if (!this.currentAnnoDefs.isEmpty()) {
            TypeResolver typeResolver = this.classStack.isEmpty() ? TypeResolver.byPackageName(this.source.getPackageName(), this.classLibrary, this.source.getImports()) : TypeResolver.byClassName(this.classStack.getFirst().getBinaryName(), this.classLibrary, this.source.getImports());
            DefaultJavaAnnotationAssembler defaultJavaAnnotationAssembler = new DefaultJavaAnnotationAssembler(abstractBaseJavaEntity.getDeclaringClass(), this.classLibrary, typeResolver);
            LinkedList<JavaAnnotation> linkedList = new LinkedList<JavaAnnotation>();
            for (AnnoDef annoDef : this.currentAnnoDefs) {
                linkedList.add(defaultJavaAnnotationAssembler.assemble(annoDef));
            }
            abstractBaseJavaEntity.setAnnotations(linkedList);
            this.currentAnnoDefs.clear();
        }
    }

    @Override
    public void addAnnotation(AnnoDef annoDef) {
        this.currentAnnoDefs.add(annoDef);
    }

    @Override
    public void addArgument(ExpressionDef expressionDef) {
        this.currentArguments.add(expressionDef);
    }

    @Override
    public JavaSource getSource() {
        return this.source;
    }

    @Override
    public JavaModule getModuleInfo() {
        return this.module;
    }

    @Override
    public void setUrl(URL uRL) {
        this.source.setURL(uRL);
    }
}

