/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.base;

import com.gradle.maven.extension.internal.dep.com.google.common.base.AbstractIterator;
import com.gradle.maven.extension.internal.dep.com.google.common.base.CharMatcher;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Splitter {
    private final CharMatcher trimmer;
    private final boolean omitEmptyStrings;
    private final Strategy strategy;
    private final int limit;

    private Splitter(Strategy strategy) {
        this(strategy, false, CharMatcher.none(), Integer.MAX_VALUE);
    }

    private Splitter(Strategy strategy, boolean bl2, CharMatcher charMatcher, int n2) {
        this.strategy = strategy;
        this.omitEmptyStrings = bl2;
        this.trimmer = charMatcher;
        this.limit = n2;
    }

    public static Splitter on(char c2) {
        return Splitter.on(CharMatcher.is(c2));
    }

    public static Splitter on(final CharMatcher charMatcher) {
        Preconditions.checkNotNull(charMatcher);
        return new Splitter((splitter, charSequence) -> new SplittingIterator(splitter, charSequence){

            @Override
            int separatorStart(int n2) {
                return charMatcher.indexIn(this.toSplit, n2);
            }

            @Override
            int separatorEnd(int n2) {
                return n2 + 1;
            }
        });
    }

    public Splitter omitEmptyStrings() {
        return new Splitter(this.strategy, true, this.trimmer, this.limit);
    }

    private Iterator<String> splittingIterator(CharSequence charSequence) {
        return this.strategy.iterator(this, charSequence);
    }

    public List<String> splitToList(CharSequence charSequence) {
        Preconditions.checkNotNull(charSequence);
        Iterator<String> iterator = this.splittingIterator(charSequence);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static interface Strategy {
        public Iterator<String> iterator(Splitter var1, CharSequence var2);
    }

    private static abstract class SplittingIterator
    extends AbstractIterator<String> {
        final CharSequence toSplit;
        final CharMatcher trimmer;
        final boolean omitEmptyStrings;
        int offset = 0;
        int limit;

        abstract int separatorStart(int var1);

        abstract int separatorEnd(int var1);

        protected SplittingIterator(Splitter splitter, CharSequence charSequence) {
            this.trimmer = splitter.trimmer;
            this.omitEmptyStrings = splitter.omitEmptyStrings;
            this.limit = splitter.limit;
            this.toSplit = charSequence;
        }

        @Override
        protected String computeNext() {
            int n2 = this.offset;
            while (this.offset != -1) {
                int n3;
                int n4 = n2;
                int n5 = this.separatorStart(this.offset);
                if (n5 == -1) {
                    n3 = this.toSplit.length();
                    this.offset = -1;
                } else {
                    n3 = n5;
                    this.offset = this.separatorEnd(n5);
                }
                if (this.offset == n2) {
                    ++this.offset;
                    if (this.offset <= this.toSplit.length()) continue;
                    this.offset = -1;
                    continue;
                }
                while (n4 < n3 && this.trimmer.matches(this.toSplit.charAt(n4))) {
                    ++n4;
                }
                while (n3 > n4 && this.trimmer.matches(this.toSplit.charAt(n3 - 1))) {
                    --n3;
                }
                if (this.omitEmptyStrings && n4 == n3) {
                    n2 = this.offset;
                    continue;
                }
                if (this.limit == 1) {
                    this.offset = -1;
                    for (n3 = this.toSplit.length(); n3 > n4 && this.trimmer.matches(this.toSplit.charAt(n3 - 1)); --n3) {
                    }
                } else {
                    --this.limit;
                }
                return this.toSplit.subSequence(n4, n3).toString();
            }
            return (String)this.endOfData();
        }
    }
}

