/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.JavaTimeFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class LocalDateTimeDeserializer
extends JSR310DateTimeDeserializerBase<LocalDateTime> {
    private static final boolean DEFAULT_USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING = JavaTimeFeature.USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING.enabledByDefault();
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    public static final LocalDateTimeDeserializer INSTANCE = new LocalDateTimeDeserializer();
    protected final Boolean _readTimestampsAsNanosOverride;
    protected final boolean _useTimeZoneForLenientDateParsing;

    protected LocalDateTimeDeserializer() {
        this(DEFAULT_FORMATTER);
    }

    public LocalDateTimeDeserializer(DateTimeFormatter dateTimeFormatter) {
        super(LocalDateTime.class, dateTimeFormatter);
        this._readTimestampsAsNanosOverride = null;
        this._useTimeZoneForLenientDateParsing = DEFAULT_USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING;
    }

    protected LocalDateTimeDeserializer(LocalDateTimeDeserializer localDateTimeDeserializer, Boolean bl2) {
        super(localDateTimeDeserializer, bl2);
        this._readTimestampsAsNanosOverride = localDateTimeDeserializer._readTimestampsAsNanosOverride;
        this._useTimeZoneForLenientDateParsing = localDateTimeDeserializer._useTimeZoneForLenientDateParsing;
    }

    protected LocalDateTimeDeserializer(LocalDateTimeDeserializer localDateTimeDeserializer, Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape, Boolean bl3) {
        super(localDateTimeDeserializer, bl2, dateTimeFormatter, shape);
        this._readTimestampsAsNanosOverride = bl3;
        this._useTimeZoneForLenientDateParsing = localDateTimeDeserializer._useTimeZoneForLenientDateParsing;
    }

    protected LocalDateTimeDeserializer(LocalDateTimeDeserializer localDateTimeDeserializer, JacksonFeatureSet<JavaTimeFeature> jacksonFeatureSet) {
        super(LocalDateTime.class, localDateTimeDeserializer._formatter);
        this._readTimestampsAsNanosOverride = localDateTimeDeserializer._readTimestampsAsNanosOverride;
        this._useTimeZoneForLenientDateParsing = jacksonFeatureSet.isEnabled(JavaTimeFeature.USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING);
    }

    protected LocalDateTimeDeserializer withDateFormat(DateTimeFormatter dateTimeFormatter) {
        return new LocalDateTimeDeserializer(this, this._isLenient, dateTimeFormatter, this._shape, this._readTimestampsAsNanosOverride);
    }

    protected LocalDateTimeDeserializer withLeniency(Boolean bl2) {
        return new LocalDateTimeDeserializer(this, bl2);
    }

    @Override
    protected JSR310DateTimeDeserializerBase<?> _withFormatOverrides(DeserializationContext deserializationContext, BeanProperty beanProperty, JsonFormat.Value value) {
        LocalDateTimeDeserializer localDateTimeDeserializer = (LocalDateTimeDeserializer)super._withFormatOverrides(deserializationContext, beanProperty, value);
        Boolean bl2 = value.getFeature(JsonFormat.Feature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
        if (!Objects.equals(bl2, localDateTimeDeserializer._readTimestampsAsNanosOverride)) {
            return new LocalDateTimeDeserializer(localDateTimeDeserializer, localDateTimeDeserializer._isLenient, localDateTimeDeserializer._formatter, localDateTimeDeserializer._shape, bl2);
        }
        return localDateTimeDeserializer;
    }

    public LocalDateTimeDeserializer withFeatures(JacksonFeatureSet<JavaTimeFeature> jacksonFeatureSet) {
        if (this._useTimeZoneForLenientDateParsing == jacksonFeatureSet.isEnabled(JavaTimeFeature.USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING)) {
            return this;
        }
        return new LocalDateTimeDeserializer(this, jacksonFeatureSet);
    }

    @Override
    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasTokenId(6)) {
            return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            String string = deserializationContext.extractScalarFromObject(jsonParser, this, this.handledType());
            if (string != null) {
                return this._fromString(jsonParser, deserializationContext, string);
            }
            return (LocalDateTime)this._handleUnexpectedToken(deserializationContext, jsonParser, "Expected array or string", new Object[0]);
        }
        if (jsonParser.isExpectedStartArrayToken()) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                return null;
            }
            if ((jsonToken == JsonToken.VALUE_STRING || jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                LocalDateTime localDateTime = this.deserialize(jsonParser, deserializationContext);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return localDateTime;
            }
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                LocalDateTime localDateTime;
                int n2 = jsonParser.getIntValue();
                int n3 = jsonParser.nextIntValue(-1);
                int n4 = jsonParser.nextIntValue(-1);
                int n5 = jsonParser.nextIntValue(-1);
                int n6 = jsonParser.nextIntValue(-1);
                jsonToken = jsonParser.nextToken();
                if (jsonToken == JsonToken.END_ARRAY) {
                    localDateTime = LocalDateTime.of(n2, n3, n4, n5, n6);
                } else {
                    int n7 = jsonParser.getIntValue();
                    jsonToken = jsonParser.nextToken();
                    if (jsonToken == JsonToken.END_ARRAY) {
                        localDateTime = LocalDateTime.of(n2, n3, n4, n5, n6, n7);
                    } else {
                        int n8 = jsonParser.getIntValue();
                        if (n8 < 1000 && !this.shouldReadTimestampsAsNanoseconds(deserializationContext)) {
                            n8 *= 1000000;
                        }
                        if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                            throw deserializationContext.wrongTokenException(jsonParser, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                        }
                        localDateTime = LocalDateTime.of(n2, n3, n4, n5, n6, n7, n8);
                    }
                }
                return localDateTime;
            }
            deserializationContext.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", new Object[]{jsonToken});
        }
        if (jsonParser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (LocalDateTime)jsonParser.getEmbeddedObject();
        }
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            this._throwNoNumericTimestampNeedTimeZone(jsonParser, deserializationContext);
        }
        return (LocalDateTime)this._handleUnexpectedToken(deserializationContext, jsonParser, "Expected array or string", new Object[0]);
    }

    protected boolean shouldReadTimestampsAsNanoseconds(DeserializationContext deserializationContext) {
        return this._readTimestampsAsNanosOverride != null ? this._readTimestampsAsNanosOverride.booleanValue() : deserializationContext.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
    }

    protected LocalDateTime _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return (LocalDateTime)this._fromEmptyString(jsonParser, deserializationContext, string2);
        }
        try {
            if (this._formatter == DEFAULT_FORMATTER && string2.length() > 10 && string2.charAt(10) == 'T' && string2.endsWith("Z")) {
                if (this.isLenient()) {
                    if (this._useTimeZoneForLenientDateParsing) {
                        return Instant.parse(string2).atZone(deserializationContext.getTimeZone().toZoneId()).toLocalDateTime();
                    }
                    return LocalDateTime.parse(string2.substring(0, string2.length() - 1), this._formatter);
                }
                JavaType javaType = this.getValueType(deserializationContext);
                return (LocalDateTime)deserializationContext.handleWeirdStringValue(javaType.getRawClass(), string2, "Should not contain offset when 'strict' mode set for property or type (enable 'lenient' handling to allow)", new Object[0]);
            }
            return LocalDateTime.parse(string2, this._formatter);
        }
        catch (DateTimeException dateTimeException) {
            return (LocalDateTime)this._handleDateTimeException(deserializationContext, dateTimeException, string2);
        }
    }
}

