/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanDescription;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.KeyDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.Annotated;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.ArrayType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.CollectionType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.MapLikeType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.MapType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.ReferenceType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.Converter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.LRUMap;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.LookupCache;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

public final class DeserializerCache
implements Serializable {
    protected final LookupCache<JavaType, JsonDeserializer<Object>> _cachedDeserializers;
    protected final HashMap<JavaType, JsonDeserializer<Object>> _incompleteDeserializers = new HashMap(8);
    private final ReentrantLock _incompleteDeserializersLock = new ReentrantLock();

    public DeserializerCache() {
        this(2000);
    }

    public DeserializerCache(int n2) {
        this(new LRUMap<JavaType, JsonDeserializer<Object>>(Math.min(64, n2 >> 2), n2));
    }

    public DeserializerCache(LookupCache<JavaType, JsonDeserializer<Object>> lookupCache) {
        this._cachedDeserializers = lookupCache;
    }

    public JsonDeserializer<Object> findValueDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) throws JsonMappingException {
        Objects.requireNonNull(javaType, "Null 'propertyType' passed");
        JsonDeserializer<Object> jsonDeserializer = this._findCachedDeserializer(javaType);
        if (jsonDeserializer == null && (jsonDeserializer = this._createAndCacheValueDeserializer(deserializationContext, deserializerFactory, javaType)) == null) {
            jsonDeserializer = this._handleUnknownValueDeserializer(deserializationContext, javaType);
        }
        return jsonDeserializer;
    }

    public KeyDeserializer findKeyDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) throws JsonMappingException {
        Objects.requireNonNull(javaType, "Null 'type' passed");
        KeyDeserializer keyDeserializer = deserializerFactory.createKeyDeserializer(deserializationContext, javaType);
        if (keyDeserializer == null) {
            return this._handleUnknownKeyDeserializer(deserializationContext, javaType);
        }
        if (keyDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)keyDeserializer)).resolve(deserializationContext);
        }
        return keyDeserializer;
    }

    protected JsonDeserializer<Object> _findCachedDeserializer(JavaType javaType) {
        if (this._hasCustomHandlers(javaType)) {
            return null;
        }
        return this._cachedDeserializers.get(javaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonDeserializer<Object> _createAndCacheValueDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer;
        boolean bl2 = this._hasCustomHandlers(javaType);
        if (!bl2 && (jsonDeserializer = this._cachedDeserializers.get(javaType)) != null) {
            return jsonDeserializer;
        }
        this._incompleteDeserializersLock.lock();
        try {
            JsonDeserializer<Object> jsonDeserializer2;
            if (!bl2 && (jsonDeserializer = this._cachedDeserializers.get(javaType)) != null) {
                JsonDeserializer<Object> jsonDeserializer3 = jsonDeserializer;
                return jsonDeserializer3;
            }
            int n2 = this._incompleteDeserializers.size();
            if (n2 > 0 && (jsonDeserializer2 = this._incompleteDeserializers.get(javaType)) != null) {
                JsonDeserializer<Object> jsonDeserializer4 = jsonDeserializer2;
                return jsonDeserializer4;
            }
            try {
                jsonDeserializer2 = this._createAndCache2(deserializationContext, deserializerFactory, javaType, bl2);
                if (n2 == 0 && this._incompleteDeserializers.size() > 0) {
                    this._incompleteDeserializers.clear();
                }
                return jsonDeserializer2;
            }
            catch (Throwable throwable) {
                if (n2 == 0 && this._incompleteDeserializers.size() > 0) {
                    this._incompleteDeserializers.clear();
                }
                throw throwable;
            }
        }
        finally {
            this._incompleteDeserializersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonDeserializer<Object> _createAndCache2(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType, boolean bl2) throws JsonMappingException {
        boolean bl3;
        JsonDeserializer<Object> jsonDeserializer;
        try {
            jsonDeserializer = this._createDeserializer(deserializationContext, deserializerFactory, javaType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            deserializationContext.reportBadDefinition(javaType, ClassUtil.exceptionMessage(illegalArgumentException));
            jsonDeserializer = null;
        }
        if (jsonDeserializer == null) {
            return null;
        }
        boolean bl4 = bl3 = !bl2 && jsonDeserializer.isCachable();
        if (jsonDeserializer instanceof ResolvableDeserializer) {
            this._incompleteDeserializers.put(javaType, jsonDeserializer);
            try {
                ((ResolvableDeserializer)((Object)jsonDeserializer)).resolve(deserializationContext);
            }
            finally {
                this._incompleteDeserializers.remove(javaType);
            }
        }
        if (bl3) {
            this._cachedDeserializers.put(javaType, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    protected JsonDeserializer<Object> _createDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) throws JsonMappingException {
        Class<?> clazz;
        BeanDescription beanDescription;
        JsonDeserializer<Object> jsonDeserializer;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        if (javaType.isAbstract() || javaType.isMapLikeType() || javaType.isCollectionLikeType()) {
            javaType = deserializerFactory.mapAbstractType(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, (beanDescription = deserializationConfig.introspect(javaType)).getClassInfo())) != null) {
            return jsonDeserializer;
        }
        JavaType javaType2 = this.modifyTypeByAnnotation(deserializationContext, beanDescription.getClassInfo(), javaType);
        if (javaType2 != javaType) {
            javaType = javaType2;
            beanDescription = deserializationConfig.introspect(javaType2);
        }
        if ((clazz = beanDescription.findPOJOBuilder()) != null) {
            return deserializerFactory.createBuilderBasedDeserializer(deserializationContext, javaType, beanDescription, clazz);
        }
        Converter<Object, Object> converter = beanDescription.findDeserializationConverter();
        if (converter != null) {
            JavaType javaType3 = converter.getInputType(deserializationContext.getTypeFactory());
            if (!javaType3.hasRawClass(javaType.getRawClass())) {
                beanDescription = deserializationConfig.introspect(javaType3);
            }
            return new StdDelegatingDeserializer<Object>(converter, javaType3, this._createDeserializer2(deserializationContext, deserializerFactory, javaType3, beanDescription));
        }
        return this._createDeserializer2(deserializationContext, deserializerFactory, javaType, beanDescription);
    }

    protected JsonDeserializer<?> _createDeserializer2(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        if (javaType.isEnumType()) {
            return deserializerFactory.createEnumDeserializer(deserializationContext, javaType, beanDescription);
        }
        if (javaType.isContainerType()) {
            JsonFormat.Value value;
            if (javaType.isArrayType()) {
                return deserializerFactory.createArrayDeserializer(deserializationContext, (ArrayType)javaType, beanDescription);
            }
            if (javaType.isMapLikeType() && (value = beanDescription.findExpectedFormat()).getShape() != JsonFormat.Shape.OBJECT) {
                MapLikeType mapLikeType = (MapLikeType)javaType;
                if (mapLikeType instanceof MapType) {
                    return deserializerFactory.createMapDeserializer(deserializationContext, (MapType)mapLikeType, beanDescription);
                }
                return deserializerFactory.createMapLikeDeserializer(deserializationContext, mapLikeType, beanDescription);
            }
            if (javaType.isCollectionLikeType() && (value = beanDescription.findExpectedFormat()).getShape() != JsonFormat.Shape.OBJECT) {
                CollectionLikeType collectionLikeType = (CollectionLikeType)javaType;
                if (collectionLikeType instanceof CollectionType) {
                    return deserializerFactory.createCollectionDeserializer(deserializationContext, (CollectionType)collectionLikeType, beanDescription);
                }
                return deserializerFactory.createCollectionLikeDeserializer(deserializationContext, collectionLikeType, beanDescription);
            }
        }
        if (javaType.isReferenceType()) {
            return deserializerFactory.createReferenceDeserializer(deserializationContext, (ReferenceType)javaType, beanDescription);
        }
        if (JsonNode.class.isAssignableFrom(javaType.getRawClass())) {
            return deserializerFactory.createTreeDeserializer(deserializationConfig, javaType, beanDescription);
        }
        return deserializerFactory.createBeanDeserializer(deserializationContext, javaType, beanDescription);
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) throws JsonMappingException {
        Object object = deserializationContext.getAnnotationIntrospector().findDeserializer(annotated);
        if (object == null) {
            return null;
        }
        JsonDeserializer<Object> jsonDeserializer = deserializationContext.deserializerInstance(annotated, object);
        return this.findConvertingDeserializer(deserializationContext, annotated, jsonDeserializer);
    }

    protected JsonDeserializer<Object> findConvertingDeserializer(DeserializationContext deserializationContext, Annotated annotated, JsonDeserializer<Object> jsonDeserializer) throws JsonMappingException {
        Converter<Object, Object> converter = this.findConverter(deserializationContext, annotated);
        if (converter == null) {
            return jsonDeserializer;
        }
        JavaType javaType = converter.getInputType(deserializationContext.getTypeFactory());
        return new StdDelegatingDeserializer<Object>(converter, javaType, jsonDeserializer);
    }

    protected Converter<Object, Object> findConverter(DeserializationContext deserializationContext, Annotated annotated) throws JsonMappingException {
        Object object = deserializationContext.getAnnotationIntrospector().findDeserializationConverter(annotated);
        if (object == null) {
            return null;
        }
        return deserializationContext.converterInstance(annotated, object);
    }

    private JavaType modifyTypeByAnnotation(DeserializationContext deserializationContext, Annotated annotated, JavaType javaType) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer;
        Object object;
        JavaType javaType2;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            return javaType;
        }
        if (javaType.isMapLikeType() && (javaType2 = javaType.getKeyType()) != null && javaType2.getValueHandler() == null && (object = annotationIntrospector.findKeyDeserializer(annotated)) != null && (jsonDeserializer = deserializationContext.keyDeserializerInstance(annotated, object)) != null) {
            javaType = ((MapLikeType)javaType).withKeyValueHandler(jsonDeserializer);
        }
        if ((javaType2 = javaType.getContentType()) != null && javaType2.getValueHandler() == null && (object = annotationIntrospector.findContentDeserializer(annotated)) != null) {
            jsonDeserializer = null;
            if (object instanceof JsonDeserializer) {
                jsonDeserializer = (JsonDeserializer)object;
            } else {
                Class<?> clazz = this._verifyAsClass(object, "findContentDeserializer", JsonDeserializer.None.class);
                if (clazz != null) {
                    jsonDeserializer = deserializationContext.deserializerInstance(annotated, clazz);
                }
            }
            if (jsonDeserializer != null) {
                javaType = javaType.withContentValueHandler(jsonDeserializer);
            }
        }
        javaType = annotationIntrospector.refineDeserializationType(deserializationContext.getConfig(), annotated, javaType);
        return javaType;
    }

    private boolean _hasCustomHandlers(JavaType javaType) {
        if (javaType.isContainerType()) {
            JavaType javaType2;
            JavaType javaType3 = javaType.getContentType();
            if (javaType3 != null && (javaType3.getValueHandler() != null || javaType3.getTypeHandler() != null)) {
                return true;
            }
            if (javaType.isMapLikeType() && (javaType2 = javaType.getKeyType()).getValueHandler() != null) {
                return true;
            }
        }
        return false;
    }

    private Class<?> _verifyAsClass(Object object, String string, Class<?> clazz) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + string + "() returned value of type " + object.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        Class clazz2 = (Class)object;
        if (clazz2 == clazz || ClassUtil.isBogusClass(clazz2)) {
            return null;
        }
        return clazz2;
    }

    protected JsonDeserializer<Object> _handleUnknownValueDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (!ClassUtil.isConcrete(clazz)) {
            return (JsonDeserializer)deserializationContext.reportBadDefinition(javaType, "Cannot find a Value deserializer for abstract type " + javaType);
        }
        return (JsonDeserializer)deserializationContext.reportBadDefinition(javaType, "Cannot find a Value deserializer for type " + javaType);
    }

    protected KeyDeserializer _handleUnknownKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        return (KeyDeserializer)deserializationContext.reportBadDefinition(javaType, "Cannot find a (Map) Key deserializer for type " + javaType);
    }
}

