/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.ObjectIdResolver;
import java.util.HashMap;
import java.util.Map;

public class SimpleObjectIdResolver
implements ObjectIdResolver {
    protected Map<ObjectIdGenerator.IdKey, Object> _items;

    @Override
    public void bindItem(ObjectIdGenerator.IdKey idKey, Object object) {
        if (this._items == null) {
            this._items = new HashMap<ObjectIdGenerator.IdKey, Object>();
        } else {
            Object object2 = this._items.get(idKey);
            if (object2 != null) {
                if (object2 == object) {
                    return;
                }
                throw new IllegalStateException(String.format("Object Id conflict: Id %s already bound to an Object %s: attempt to re-bind to a different Object %s", idKey.toString(), this._desc(object2), this._desc(object)));
            }
        }
        this._items.put(idKey, object);
    }

    private String _desc(Object object) {
        String string;
        if (object == null) {
            return "(null)";
        }
        if (object instanceof String) {
            string = "\"" + object + "\"";
        } else {
            string = object.toString();
            if (string.length() > 100) {
                string = string.substring(0, 100) + "[... truncated]";
            }
        }
        return "(type: `" + object.getClass().getName() + "`, value: " + string + ")";
    }

    @Override
    public Object resolveId(ObjectIdGenerator.IdKey idKey) {
        return this._items == null ? null : this._items.get(idKey);
    }

    @Override
    public boolean canUseFor(ObjectIdResolver objectIdResolver) {
        return objectIdResolver.getClass() == this.getClass();
    }

    @Override
    public ObjectIdResolver newForDeserialization(Object object) {
        return new SimpleObjectIdResolver();
    }
}

