/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.KryoException;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io.Input;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io.Output;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.ObjectField;

class AsmCacheFields {

    static final class AsmObjectField
    extends ObjectField {
        public AsmObjectField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            if (this.accessIndex != -1) {
                return this.access.get(object, this.accessIndex);
            }
            throw new KryoException("Unknown acess index");
        }

        public void setField(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
            if (this.accessIndex == -1) {
                throw new KryoException("Unknown acess index");
            }
            this.access.set(object, this.accessIndex, object2);
        }

        public void copy(Object object, Object object2) {
            try {
                if (this.accessIndex == -1) {
                    throw new KryoException("Unknown acess index");
                }
                this.access.set(object2, this.accessIndex, this.kryo.copy(this.access.get(object, this.accessIndex)));
            }
            catch (KryoException kryoException) {
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
            catch (RuntimeException runtimeException) {
                KryoException kryoException = new KryoException(runtimeException);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }
    }

    static final class AsmStringField
    extends AsmCachedField {
        AsmStringField() {
        }

        public void write(Output output, Object object) {
            output.writeString(this.access.getString(object, this.accessIndex));
        }

        public void read(Input input, Object object) {
            this.access.set(object, this.accessIndex, input.readString());
        }

        public void copy(Object object, Object object2) {
            this.access.set(object2, this.accessIndex, this.access.getString(object, this.accessIndex));
        }
    }

    static final class AsmDoubleField
    extends AsmCachedField {
        AsmDoubleField() {
        }

        public void write(Output output, Object object) {
            output.writeDouble(this.access.getDouble(object, this.accessIndex));
        }

        public void read(Input input, Object object) {
            this.access.setDouble(object, this.accessIndex, input.readDouble());
        }

        public void copy(Object object, Object object2) {
            this.access.setDouble(object2, this.accessIndex, this.access.getDouble(object, this.accessIndex));
        }
    }

    static final class AsmLongField
    extends AsmCachedField {
        AsmLongField() {
        }

        public void write(Output output, Object object) {
            if (this.varIntsEnabled) {
                output.writeLong(this.access.getLong(object, this.accessIndex), false);
            } else {
                output.writeLong(this.access.getLong(object, this.accessIndex));
            }
        }

        public void read(Input input, Object object) {
            if (this.varIntsEnabled) {
                this.access.setLong(object, this.accessIndex, input.readLong(false));
            } else {
                this.access.setLong(object, this.accessIndex, input.readLong());
            }
        }

        public void copy(Object object, Object object2) {
            this.access.setLong(object2, this.accessIndex, this.access.getLong(object, this.accessIndex));
        }
    }

    static final class AsmCharField
    extends AsmCachedField {
        AsmCharField() {
        }

        public void write(Output output, Object object) {
            output.writeChar(this.access.getChar(object, this.accessIndex));
        }

        public void read(Input input, Object object) {
            this.access.setChar(object, this.accessIndex, input.readChar());
        }

        public void copy(Object object, Object object2) {
            this.access.setChar(object2, this.accessIndex, this.access.getChar(object, this.accessIndex));
        }
    }

    static final class AsmBooleanField
    extends AsmCachedField {
        AsmBooleanField() {
        }

        public void write(Output output, Object object) {
            output.writeBoolean(this.access.getBoolean(object, this.accessIndex));
        }

        public void read(Input input, Object object) {
            this.access.setBoolean(object, this.accessIndex, input.readBoolean());
        }

        public void copy(Object object, Object object2) {
            this.access.setBoolean(object2, this.accessIndex, this.access.getBoolean(object, this.accessIndex));
        }
    }

    static final class AsmByteField
    extends AsmCachedField {
        AsmByteField() {
        }

        public void write(Output output, Object object) {
            output.writeByte(this.access.getByte(object, this.accessIndex));
        }

        public void read(Input input, Object object) {
            this.access.setByte(object, this.accessIndex, input.readByte());
        }

        public void copy(Object object, Object object2) {
            this.access.setByte(object2, this.accessIndex, this.access.getByte(object, this.accessIndex));
        }
    }

    static final class AsmShortField
    extends AsmCachedField {
        AsmShortField() {
        }

        public void write(Output output, Object object) {
            output.writeShort(this.access.getShort(object, this.accessIndex));
        }

        public void read(Input input, Object object) {
            this.access.setShort(object, this.accessIndex, input.readShort());
        }

        public void copy(Object object, Object object2) {
            this.access.setShort(object2, this.accessIndex, this.access.getShort(object, this.accessIndex));
        }
    }

    static final class AsmFloatField
    extends AsmCachedField {
        AsmFloatField() {
        }

        public void write(Output output, Object object) {
            output.writeFloat(this.access.getFloat(object, this.accessIndex));
        }

        public void read(Input input, Object object) {
            this.access.setFloat(object, this.accessIndex, input.readFloat());
        }

        public void copy(Object object, Object object2) {
            this.access.setFloat(object2, this.accessIndex, this.access.getFloat(object, this.accessIndex));
        }
    }

    static final class AsmIntField
    extends AsmCachedField {
        AsmIntField() {
        }

        public void write(Output output, Object object) {
            if (this.varIntsEnabled) {
                output.writeInt(this.access.getInt(object, this.accessIndex), false);
            } else {
                output.writeInt(this.access.getInt(object, this.accessIndex));
            }
        }

        public void read(Input input, Object object) {
            if (this.varIntsEnabled) {
                this.access.setInt(object, this.accessIndex, input.readInt(false));
            } else {
                this.access.setInt(object, this.accessIndex, input.readInt());
            }
        }

        public void copy(Object object, Object object2) {
            this.access.setInt(object2, this.accessIndex, this.access.getInt(object, this.accessIndex));
        }
    }

    static abstract class AsmCachedField
    extends FieldSerializer.CachedField {
        AsmCachedField() {
        }
    }
}

