/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.SerializationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.FloatingNumberType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.SimpleURType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;

public class FloatType
extends FloatingNumberType {
    public static final FloatType theInstance = new FloatType();
    private static final long serialVersionUID = 1L;

    private FloatType() {
        super("float");
    }

    @Override
    public final XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }

    @Override
    public Object _createValue(String string, ValidationContext validationContext) {
        return FloatType.load(string);
    }

    public static Float load(String string) {
        try {
            if (string.equals("NaN")) {
                return new Float(Float.NaN);
            }
            if (string.equals("INF")) {
                return new Float(Float.POSITIVE_INFINITY);
            }
            if (string.equals("-INF")) {
                return new Float(Float.NEGATIVE_INFINITY);
            }
            if (string.length() == 0 || !FloatType.isDigitOrPeriodOrSign(string.charAt(0)) || !FloatType.isDigitOrPeriodOrSign(string.charAt(string.length() - 1))) {
                return null;
            }
            return Float.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public Class getJavaObjectType() {
        return Float.class;
    }

    @Override
    public String convertToLexicalValue(Object object, SerializationContext serializationContext) {
        if (!(object instanceof Float)) {
            throw new IllegalArgumentException();
        }
        return FloatType.save((Float)object);
    }

    public static String save(Float f2) {
        float f3 = f2.floatValue();
        if (Float.isNaN(f3)) {
            return "NaN";
        }
        if (f3 == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (f3 == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return f2.toString();
    }
}

