/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.PrefixedNameSet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.PrefixedName;
import java.util.Iterator;
import java.util.TreeSet;

public final class LargePrefixedNameSet
extends PrefixedNameSet {
    static final int MIN_HASH_AREA = 8;
    final boolean mNsAware;
    final PrefixedName[] mNames;
    final Bucket[] mBuckets;

    public LargePrefixedNameSet(boolean bl2, PrefixedName[] prefixedNameArray) {
        int n2;
        this.mNsAware = bl2;
        int n3 = prefixedNameArray.length;
        int n4 = n3 + (n3 + 7 >> 3);
        for (n2 = 8; n2 < n4; n2 += n2) {
        }
        this.mNames = new PrefixedName[n2];
        Bucket[] bucketArray = null;
        int n5 = n2 - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            Bucket bucket;
            PrefixedName prefixedName = prefixedNameArray[i2];
            int n6 = prefixedName.hashCode() & n5;
            if (this.mNames[n6] == null) {
                this.mNames[n6] = prefixedName;
                continue;
            }
            n6 >>= 2;
            if (bucketArray == null) {
                bucketArray = new Bucket[n2 >> 2];
                bucket = null;
            } else {
                bucket = bucketArray[n6];
            }
            bucketArray[n6] = new Bucket(prefixedName, bucket);
        }
        this.mBuckets = bucketArray;
    }

    @Override
    public boolean hasMultiple() {
        return true;
    }

    @Override
    public boolean contains(PrefixedName prefixedName) {
        PrefixedName[] prefixedNameArray = this.mNames;
        int n2 = prefixedName.hashCode() & prefixedNameArray.length - 1;
        PrefixedName prefixedName2 = prefixedNameArray[n2];
        if (prefixedName2 != null && prefixedName2.equals(prefixedName)) {
            return true;
        }
        Bucket[] bucketArray = this.mBuckets;
        if (bucketArray != null) {
            for (Bucket bucket = bucketArray[n2 >> 2]; bucket != null; bucket = bucket.getNext()) {
                prefixedName2 = bucket.getName();
                if (!prefixedName2.equals(prefixedName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void appendNames(StringBuilder stringBuilder, String string) {
        Object object;
        int n2;
        TreeSet<PrefixedName> treeSet = new TreeSet<PrefixedName>();
        for (n2 = 0; n2 < this.mNames.length; ++n2) {
            object = this.mNames[n2];
            if (object == null) continue;
            treeSet.add((PrefixedName)object);
        }
        if (this.mBuckets != null) {
            for (n2 = 0; n2 < this.mNames.length >> 2; ++n2) {
                for (object = this.mBuckets[n2]; object != null; object = ((Bucket)object).getNext()) {
                    treeSet.add(((Bucket)object).getName());
                }
            }
        }
        Iterator iterator = treeSet.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append(((PrefixedName)iterator.next()).toString());
        }
    }

    private static final class Bucket {
        final PrefixedName mName;
        final Bucket mNext;

        public Bucket(PrefixedName prefixedName, Bucket bucket) {
            this.mName = prefixedName;
            this.mNext = bucket;
        }

        public PrefixedName getName() {
            return this.mName;
        }

        public Bucket getNext() {
            return this.mNext;
        }
    }
}

