/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.time;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.internal.time.Clock;
import org.gradle.internal.time.TimeSource;

class MonotonicClock
implements Clock {
    private static final long SYNC_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(3L);
    private final long syncIntervalMillis;
    private final TimeSource timeSource;
    private final AtomicLong syncMillisRef;
    private final AtomicLong syncNanosRef;
    private final AtomicLong currentTime = new AtomicLong();

    MonotonicClock() {
        this(TimeSource.SYSTEM, SYNC_INTERVAL_MILLIS);
    }

    MonotonicClock(TimeSource timeSource, long l2) {
        long l3 = timeSource.nanoTime();
        long l4 = timeSource.currentTimeMillis();
        this.timeSource = timeSource;
        this.syncIntervalMillis = l2;
        this.syncNanosRef = new AtomicLong(l3);
        this.syncMillisRef = new AtomicLong(l4);
        this.currentTime.set(l4);
    }

    @Override
    public long getCurrentTime() {
        long l2 = this.timeSource.nanoTime();
        long l3 = this.syncNanosRef.get();
        long l4 = this.syncMillisRef.get();
        long l5 = l2 - l3;
        long l6 = TimeUnit.NANOSECONDS.toMillis(l5);
        if (this.syncIsDue(l2, l3, l6)) {
            return this.sync(l4);
        }
        return this.advance(l4 + l6);
    }

    private boolean syncIsDue(long l2, long l3, long l4) {
        return l4 >= this.syncIntervalMillis && this.syncNanosRef.compareAndSet(l3, l2);
    }

    private long sync(long l2) {
        long l3 = this.advance(this.timeSource.currentTimeMillis());
        this.syncMillisRef.compareAndSet(l2, l3);
        return l3;
    }

    private long advance(long l2) {
        long l3;
        do {
            if (l2 > (l3 = this.currentTime.get())) continue;
            return l3;
        } while (!this.currentTime.compareAndSet(l3, l2));
        return l2;
    }
}

