/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import com.gradle.maven.extension.internal.dep.com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashFunction;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.HashingOutputStream;
import org.gradle.internal.hash.PrimitiveHasher;

public class Hashing {
    private static final HashFunction MD5 = MessageDigestHashFunction.of("MD5");
    private static final HashFunction SHA1 = MessageDigestHashFunction.of("SHA-1");
    private static final HashFunction SHA256 = MessageDigestHashFunction.of("SHA-256");
    private static final HashFunction SHA512 = MessageDigestHashFunction.of("SHA-512");
    private static final HashFunction DEFAULT = MD5;

    public static Hasher newHasher() {
        return DEFAULT.newHasher();
    }

    public static PrimitiveHasher newPrimitiveHasher() {
        return DEFAULT.newPrimitiveHasher();
    }

    public static HashCode signature(Class<?> clazz) {
        return Hashing.signature("CLASS:" + clazz.getName());
    }

    public static HashCode signature(String string) {
        Hasher hasher = DEFAULT.newHasher();
        hasher.putString("SIGNATURE");
        hasher.putString(string);
        return hasher.hash();
    }

    public static HashCode hashBytes(byte[] byArray) {
        return DEFAULT.hashBytes(byArray);
    }

    public static HashCode hashString(CharSequence charSequence) {
        return DEFAULT.hashString(charSequence);
    }

    public static HashCode hashStream(InputStream inputStream) throws IOException {
        return DEFAULT.hashStream(inputStream);
    }

    private static abstract class MessageDigestHashFunction
    implements HashFunction {
        private final int hexDigits;

        public MessageDigestHashFunction(int n2) {
            this.hexDigits = n2 / 4;
        }

        public static MessageDigestHashFunction of(String string) {
            MessageDigest messageDigest;
            try {
                messageDigest = MessageDigest.getInstance(string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalArgumentException("Cannot instantiate digest algorithm: " + string);
            }
            int n2 = messageDigest.getDigestLength() * 8;
            try {
                Object object = messageDigest.clone();
                return new CloningMessageDigestHashFunction(messageDigest, n2);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return new RegularMessageDigestHashFunction(string, n2);
            }
        }

        @Override
        public PrimitiveHasher newPrimitiveHasher() {
            MessageDigest messageDigest = this.createDigest();
            return new MessageDigestHasher(messageDigest);
        }

        @Override
        public Hasher newHasher() {
            return new DefaultHasher(this.newPrimitiveHasher());
        }

        @Override
        public HashCode hashBytes(byte[] byArray) {
            PrimitiveHasher primitiveHasher = this.newPrimitiveHasher();
            primitiveHasher.putBytes(byArray);
            return primitiveHasher.hash();
        }

        @Override
        public HashCode hashString(CharSequence charSequence) {
            PrimitiveHasher primitiveHasher = this.newPrimitiveHasher();
            primitiveHasher.putString(charSequence);
            return primitiveHasher.hash();
        }

        @Override
        public HashCode hashStream(InputStream inputStream) throws IOException {
            HashingOutputStream hashingOutputStream = this.primitiveStreamHasher();
            ByteStreams.copy(inputStream, hashingOutputStream);
            return hashingOutputStream.hash();
        }

        private HashingOutputStream primitiveStreamHasher() {
            return new HashingOutputStream(this, ByteStreams.nullOutputStream());
        }

        protected abstract MessageDigest createDigest();

        public String toString() {
            return this.getAlgorithm();
        }
    }

    private static class DefaultHasher
    implements Hasher {
        private final PrimitiveHasher hasher;

        public DefaultHasher(PrimitiveHasher primitiveHasher) {
            this.hasher = primitiveHasher;
        }

        @Override
        public void putByte(byte by2) {
            this.hasher.putInt(1);
            this.hasher.putByte(by2);
        }

        @Override
        public void putBytes(byte[] byArray) {
            this.hasher.putInt(byArray.length);
            this.hasher.putBytes(byArray);
        }

        @Override
        public void putBytes(byte[] byArray, int n2, int n3) {
            this.hasher.putInt(n3);
            this.hasher.putBytes(byArray, n2, n3);
        }

        @Override
        public void putHash(HashCode hashCode) {
            this.hasher.putInt(hashCode.length());
            this.hasher.putHash(hashCode);
        }

        @Override
        public void putInt(int n2) {
            this.hasher.putInt(4);
            this.hasher.putInt(n2);
        }

        @Override
        public void putLong(long l2) {
            this.hasher.putInt(8);
            this.hasher.putLong(l2);
        }

        @Override
        public void putDouble(double d2) {
            this.hasher.putInt(8);
            this.hasher.putDouble(d2);
        }

        @Override
        public void putBoolean(boolean bl2) {
            this.hasher.putInt(1);
            this.hasher.putBoolean(bl2);
        }

        @Override
        public void putString(CharSequence charSequence) {
            this.hasher.putInt(charSequence.length());
            this.hasher.putString(charSequence);
        }

        @Override
        public void putNull() {
            this.putInt(0);
        }

        @Override
        public HashCode hash() {
            return this.hasher.hash();
        }
    }

    private static class MessageDigestHasher
    implements PrimitiveHasher {
        private final ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        private MessageDigest digest;

        public MessageDigestHasher(MessageDigest messageDigest) {
            this.digest = messageDigest;
        }

        private MessageDigest getDigest() {
            if (this.digest == null) {
                throw new IllegalStateException("Cannot reuse hasher!");
            }
            return this.digest;
        }

        @Override
        public void putByte(byte by2) {
            this.getDigest().update(by2);
        }

        @Override
        public void putBytes(byte[] byArray) {
            this.getDigest().update(byArray);
        }

        @Override
        public void putBytes(byte[] byArray, int n2, int n3) {
            this.getDigest().update(byArray, n2, n3);
        }

        private void update(int n2) {
            this.getDigest().update(this.buffer.array(), 0, n2);
            MessageDigestHasher.castBuffer(this.buffer).clear();
        }

        private static <T extends Buffer> Buffer castBuffer(T t2) {
            return t2;
        }

        @Override
        public void putInt(int n2) {
            this.buffer.putInt(n2);
            this.update(4);
        }

        @Override
        public void putLong(long l2) {
            this.buffer.putLong(l2);
            this.update(8);
        }

        @Override
        public void putDouble(double d2) {
            long l2 = Double.doubleToRawLongBits(d2);
            this.putLong(l2);
        }

        @Override
        public void putBoolean(boolean bl2) {
            this.putByte((byte)(bl2 ? 1 : 0));
        }

        @Override
        public void putString(CharSequence charSequence) {
            this.putBytes(charSequence.toString().getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public void putHash(HashCode hashCode) {
            hashCode.appendToHasher(this);
        }

        @Override
        public HashCode hash() {
            byte[] byArray = this.getDigest().digest();
            this.digest = null;
            return HashCode.fromBytes(byArray, HashCode.Usage.SAFE_TO_REUSE_BYTES);
        }
    }

    private static class RegularMessageDigestHashFunction
    extends MessageDigestHashFunction {
        private final String algorithm;

        public RegularMessageDigestHashFunction(String string, int n2) {
            super(n2);
            this.algorithm = string;
        }

        @Override
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        protected MessageDigest createDigest() {
            try {
                return MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new AssertionError((Object)noSuchAlgorithmException);
            }
        }
    }

    private static class CloningMessageDigestHashFunction
    extends MessageDigestHashFunction {
        private final MessageDigest prototype;

        public CloningMessageDigestHashFunction(MessageDigest messageDigest, int n2) {
            super(n2);
            this.prototype = messageDigest;
        }

        @Override
        public String getAlgorithm() {
            return this.prototype.getAlgorithm();
        }

        @Override
        protected MessageDigest createDigest() {
            try {
                return (MessageDigest)this.prototype.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
        }
    }
}

