/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import com.gradle.maven.extension.internal.dep.com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.hash.PrimitiveHasher;
import org.gradle.internal.hash.StreamHasher;

public class DefaultStreamHasher
implements StreamHasher {
    private static final HashCode SIGNATURE = Hashing.signature(DefaultStreamHasher.class);
    private final Queue<byte[]> buffers = new ArrayBlockingQueue<byte[]>(16);

    @Override
    public HashCode hash(InputStream inputStream) throws IOException {
        return this.doHash(inputStream, ByteStreams.nullOutputStream());
    }

    @Override
    public HashCode hashCopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return this.doHash(inputStream, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashCode doHash(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = this.takeBuffer();
        try {
            int n2;
            PrimitiveHasher primitiveHasher = Hashing.newPrimitiveHasher();
            primitiveHasher.putHash(SIGNATURE);
            while ((n2 = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n2);
                primitiveHasher.putBytes(byArray, 0, n2);
            }
            HashCode hashCode = primitiveHasher.hash();
            return hashCode;
        }
        finally {
            this.returnBuffer(byArray);
        }
    }

    private void returnBuffer(byte[] byArray) {
        this.buffers.offer(byArray);
    }

    private byte[] takeBuffer() {
        byte[] byArray = this.buffers.poll();
        if (byArray == null) {
            byArray = new byte[8192];
        }
        return byArray;
    }
}

