/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PathTraversalChecker {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.US).contains("windows");

    public static String safePathName(String string) {
        if (PathTraversalChecker.isUnsafePathName(string)) {
            throw new IllegalArgumentException(String.format("'%s' is not a safe archive entry or path name.", string));
        }
        return string;
    }

    public static boolean isUnsafePathName(String string) {
        if (string.isEmpty()) {
            return true;
        }
        if (IS_WINDOWS && string.contains(":")) {
            return true;
        }
        if (string.startsWith("/") || string.startsWith("\\")) {
            return true;
        }
        return PathTraversalChecker.containsDirectoryNavigation(string);
    }

    private static String osIndependentPath(String string) {
        if (File.separatorChar == '\\') {
            return string.replace('/', File.separatorChar);
        }
        if (File.separatorChar == '/') {
            return string.replace('\\', File.separatorChar);
        }
        throw new IllegalStateException("Unknown file separator: " + File.separatorChar);
    }

    private static boolean containsDirectoryNavigation(String string) {
        List<String> list = PathTraversalChecker.buildNamesList(string);
        for (String string2 : list) {
            if (string2.equals("..")) {
                return true;
            }
            if (!IS_WINDOWS || string2.equals(".") || !string2.endsWith(".")) continue;
            return true;
        }
        return false;
    }

    private static List<String> buildNamesList(String string) {
        Path path = new File(PathTraversalChecker.osIndependentPath(string)).toPath();
        ArrayList<String> arrayList = new ArrayList<String>(path.getNameCount());
        for (Path path2 : path) {
            arrayList.add(path2.toString());
        }
        return arrayList;
    }
}

