/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ExecutorPolicy {

    public static class CatchAndRecordFailures
    implements ExecutorPolicy {
        private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutorFactory.class);
        private final AtomicReference<Throwable> failure;

        public void onExecute(Runnable runnable) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                this.onFailure(String.format("Failed to execute %s.", runnable), throwable);
            }
        }

        public void onFailure(String string, Throwable throwable) {
            if (!this.failure.compareAndSet(null, throwable)) {
                LOGGER.error(string, throwable);
            }
        }

        public void onStop() {
            Throwable throwable = this.failure.getAndSet(null);
            if (throwable != null) {
                throw UncheckedException.throwAsUncheckedException(throwable);
            }
        }
    }
}

