/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import java.io.File;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.internal.controller.service.BuildCacheLoadResult;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.LoadTarget;
import org.gradle.caching.internal.controller.service.OpFiringRemoteBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.RemoteBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.StoreTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRemoteBuildCacheServiceHandle
implements RemoteBuildCacheServiceHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpFiringRemoteBuildCacheServiceHandle.class);
    protected final BuildCacheService service;
    protected final BuildCacheServiceRole role;
    private final boolean pushEnabled;
    private final boolean logStackTraces;
    private final boolean disableOnError;
    private boolean disabled;

    public BaseRemoteBuildCacheServiceHandle(BuildCacheService buildCacheService, boolean bl2, BuildCacheServiceRole buildCacheServiceRole, boolean bl3, boolean bl4) {
        this.role = buildCacheServiceRole;
        this.service = buildCacheService;
        this.pushEnabled = bl2;
        this.logStackTraces = bl3;
        this.disableOnError = bl4;
    }

    @Override
    public boolean canLoad() {
        return !this.disabled;
    }

    @Override
    public final Optional<BuildCacheLoadResult> maybeLoad(BuildCacheKey buildCacheKey, File file, Function<File, BuildCacheLoadResult> function) {
        if (!this.canLoad()) {
            return Optional.empty();
        }
        String string = Operation.LOAD.describe(buildCacheKey, this.role);
        LOGGER.debug(string);
        LoadTarget loadTarget = new LoadTarget(file);
        try {
            this.loadInner(string, buildCacheKey, loadTarget);
        }
        catch (Exception exception) {
            this.failure(Operation.LOAD, buildCacheKey, exception);
        }
        return BaseRemoteBuildCacheServiceHandle.maybeUnpack(loadTarget, function);
    }

    protected void loadInner(String string, BuildCacheKey buildCacheKey, LoadTarget loadTarget) {
        this.service.load(buildCacheKey, loadTarget);
    }

    protected void loadInner(BuildCacheKey buildCacheKey, BuildCacheEntryReader buildCacheEntryReader) {
        this.service.load(buildCacheKey, buildCacheEntryReader);
    }

    private static Optional<BuildCacheLoadResult> maybeUnpack(LoadTarget loadTarget, Function<File, BuildCacheLoadResult> function) {
        if (loadTarget.isLoaded()) {
            return Optional.ofNullable(function.apply(loadTarget.getFile()));
        }
        return Optional.empty();
    }

    @Override
    public boolean canStore() {
        return this.pushEnabled && !this.disabled;
    }

    @Override
    public final boolean maybeStore(BuildCacheKey buildCacheKey, File file) {
        if (!this.canStore()) {
            return false;
        }
        String string = Operation.STORE.describe(buildCacheKey, this.role);
        LOGGER.debug(string);
        try {
            this.storeInner(string, buildCacheKey, new StoreTarget(file));
            return true;
        }
        catch (Exception exception) {
            this.failure(Operation.STORE, buildCacheKey, exception);
            return false;
        }
    }

    protected void storeInner(String string, BuildCacheKey buildCacheKey, StoreTarget storeTarget) {
        this.service.store(buildCacheKey, storeTarget);
    }

    private void failure(Operation operation, BuildCacheKey buildCacheKey, Throwable throwable) {
        if (this.disableOnError) {
            this.disabled = true;
            this.onCacheDisabledDueToFailure(buildCacheKey, operation, throwable);
        }
        String string = operation.describeFailure(buildCacheKey, this.role);
        if (LOGGER.isWarnEnabled()) {
            if (this.logStackTraces) {
                LOGGER.warn(string, throwable);
            } else {
                LOGGER.warn(string + ": " + throwable.getMessage());
            }
        }
    }

    protected void onCacheDisabledDueToFailure(BuildCacheKey buildCacheKey, Operation operation, Throwable throwable) {
    }

    @Override
    public void close() {
        LOGGER.debug("Closing {} build cache", (Object)this.role.getDisplayName());
        if (this.disabled) {
            LOGGER.warn("The {} build cache was disabled during the build due to errors.", (Object)this.role.getDisplayName());
        }
        try {
            this.service.close();
        }
        catch (Exception exception) {
            if (this.logStackTraces) {
                LOGGER.warn("Error closing {} build cache: ", (Object)this.role.getDisplayName(), (Object)exception);
            }
            LOGGER.warn("Error closing {} build cache: {}", (Object)this.role.getDisplayName(), (Object)exception.getMessage());
        }
    }

    protected static enum Operation {
        LOAD("Load", "from"),
        STORE("Store", "in");

        private final String verb;
        private final String capitalizedVerb;
        private final String preposition;

        private Operation(String string2, String string3) {
            this.capitalizedVerb = string2;
            this.verb = string2.toLowerCase(Locale.ROOT);
            this.preposition = string3;
        }

        public String describe(BuildCacheKey buildCacheKey, BuildCacheServiceRole buildCacheServiceRole) {
            return this.capitalizedVerb + " entry " + buildCacheKey.getHashCode() + " " + this.preposition + " " + buildCacheServiceRole.getDisplayName() + " build cache";
        }

        public String describeFailure(BuildCacheKey buildCacheKey, BuildCacheServiceRole buildCacheServiceRole) {
            return "Could not " + this.verb + " entry " + buildCacheKey.getHashCode() + " " + this.preposition + " " + buildCacheServiceRole.getDisplayName() + " build cache";
        }
    }
}

