/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.gradle.cache.internal.filelock.FileLockOutcome;
import org.gradle.cache.internal.filelock.LockInfo;
import org.gradle.cache.internal.filelock.LockInfoAccess;
import org.gradle.cache.internal.filelock.LockState;
import org.gradle.cache.internal.filelock.LockStateAccess;

public class LockFileAccess {
    private final RandomAccessFile lockFileAccess;
    private final LockStateAccess lockStateAccess;
    private final LockInfoAccess lockInfoAccess;

    public LockFileAccess(File file, LockStateAccess lockStateAccess) throws FileNotFoundException {
        this.lockFileAccess = new RandomAccessFile(file, "rw");
        this.lockStateAccess = lockStateAccess;
        this.lockInfoAccess = new LockInfoAccess(this.lockStateAccess.getRegionEnd());
    }

    public void close() throws IOException {
        this.lockFileAccess.close();
    }

    public void writeLockInfo(int n2, long l2, String string, String string2) throws IOException {
        LockInfo lockInfo = new LockInfo();
        lockInfo.port = n2;
        lockInfo.lockId = l2;
        lockInfo.pid = string;
        lockInfo.operation = string2;
        this.lockInfoAccess.writeLockInfo(this.lockFileAccess, lockInfo);
    }

    public LockInfo readLockInfo() throws IOException {
        return this.lockInfoAccess.readLockInfo(this.lockFileAccess);
    }

    public LockState ensureLockState() throws IOException {
        return this.lockStateAccess.ensureLockState(this.lockFileAccess);
    }

    public LockState markClean(LockState lockState) throws IOException {
        LockState lockState2 = lockState.completeUpdate();
        this.lockStateAccess.writeState(this.lockFileAccess, lockState2);
        return lockState2;
    }

    public LockState markDirty(LockState lockState) throws IOException {
        LockState lockState2 = lockState.beforeUpdate();
        this.lockStateAccess.writeState(this.lockFileAccess, lockState2);
        return lockState2;
    }

    public void clearLockInfo() throws IOException {
        this.lockInfoAccess.clearLockInfo(this.lockFileAccess);
    }

    public FileLockOutcome tryLockInfo(boolean bl2) throws IOException {
        return this.lockInfoAccess.tryLock(this.lockFileAccess, bl2);
    }

    public FileLockOutcome tryLockState(boolean bl2) throws IOException {
        return this.lockStateAccess.tryLock(this.lockFileAccess, bl2);
    }

    public LockState readLockState() throws IOException {
        return this.lockStateAccess.readState(this.lockFileAccess);
    }
}

