/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache;

import java.time.Duration;
import java.time.Instant;

public interface CleanupFrequency {
    public static final CleanupFrequency DAILY = new CleanupFrequency(){

        @Override
        public boolean requiresCleanup(Instant instant) {
            if (instant == null) {
                return true;
            }
            return Duration.between(instant, Instant.now()).toHours() >= 24L;
        }
    };
    public static final CleanupFrequency ALWAYS = new CleanupFrequency(){

        @Override
        public boolean requiresCleanup(Instant instant) {
            return true;
        }
    };
    public static final CleanupFrequency NEVER = new CleanupFrequency(){

        @Override
        public boolean requiresCleanup(Instant instant) {
            return false;
        }
    };

    public boolean requiresCleanup(Instant var1);
}

