/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import java.util.LinkedList;
import java.util.List;

public abstract class PatternMatcher {
    public static final PatternMatcher MATCH_ALL = new PatternMatcher(){

        @Override
        public boolean test(String[] stringArray, boolean bl2) {
            return true;
        }

        @Override
        public PatternMatcher and(PatternMatcher patternMatcher) {
            return patternMatcher;
        }

        @Override
        public PatternMatcher or(PatternMatcher patternMatcher) {
            return this;
        }
    };

    public abstract boolean test(String[] var1, boolean var2);

    public PatternMatcher and(PatternMatcher patternMatcher) {
        return new And(this, patternMatcher);
    }

    public PatternMatcher or(PatternMatcher patternMatcher) {
        return new Or(this, patternMatcher);
    }

    public PatternMatcher negate() {
        return new PatternMatcher(){

            @Override
            public boolean test(String[] stringArray, boolean bl2) {
                return !PatternMatcher.this.test(stringArray, bl2);
            }
        };
    }

    private static final class And
    extends PatternMatcher {
        private final List<PatternMatcher> parts = new LinkedList<PatternMatcher>();

        public And(PatternMatcher patternMatcher, PatternMatcher patternMatcher2) {
            this.parts.add(patternMatcher);
            this.parts.add(patternMatcher2);
        }

        @Override
        public PatternMatcher and(PatternMatcher patternMatcher) {
            this.parts.add(patternMatcher);
            return this;
        }

        @Override
        public boolean test(String[] stringArray, boolean bl2) {
            for (PatternMatcher patternMatcher : this.parts) {
                if (patternMatcher.test(stringArray, bl2)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class Or
    extends PatternMatcher {
        private final List<PatternMatcher> parts = new LinkedList<PatternMatcher>();

        public Or(PatternMatcher patternMatcher, PatternMatcher patternMatcher2) {
            this.parts.add(patternMatcher);
            this.parts.add(patternMatcher2);
        }

        @Override
        public PatternMatcher or(PatternMatcher patternMatcher) {
            this.parts.add(patternMatcher);
            return this;
        }

        @Override
        public boolean test(String[] stringArray, boolean bl2) {
            for (PatternMatcher patternMatcher : this.parts) {
                if (!patternMatcher.test(stringArray, bl2)) continue;
                return true;
            }
            return false;
        }
    }
}

