/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.internal.hash.Hasher;

public class IgnoringResourceFilter
implements ResourceFilter {
    private final Set<String> ignores;
    private final ImmutableSet<PathMatcher> ignoreMatchers;

    public IgnoringResourceFilter(ImmutableSet<String> immutableSet) {
        this.ignores = immutableSet;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String string : immutableSet) {
            PathMatcher pathMatcher = PatternMatcherFactory.compile(true, string);
            builder.add(pathMatcher);
        }
        this.ignoreMatchers = builder.build();
    }

    private boolean shouldBeIgnored(String[] stringArray) {
        for (PathMatcher pathMatcher : this.ignoreMatchers) {
            if (!pathMatcher.matches(stringArray, 0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString(this.getClass().getName());
        for (String string : this.ignores) {
            hasher.putString(string);
        }
    }

    @Override
    public boolean shouldBeIgnored(Supplier<String[]> supplier) {
        if (this.ignoreMatchers.isEmpty()) {
            return false;
        }
        return this.shouldBeIgnored(supplier.get());
    }
}

