/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.software.os.windows;

import com.gradle.maven.extension.internal.dep.oshi.driver.windows.registry.ProcessPerformanceData;
import com.gradle.maven.extension.internal.dep.oshi.driver.windows.registry.ProcessWtsData;
import com.gradle.maven.extension.internal.dep.oshi.driver.windows.registry.ThreadPerformanceData;
import com.gradle.maven.extension.internal.dep.oshi.driver.windows.wmi.Win32Process;
import com.gradle.maven.extension.internal.dep.oshi.driver.windows.wmi.Win32ProcessCached;
import com.gradle.maven.extension.internal.dep.oshi.jna.ByRef;
import com.gradle.maven.extension.internal.dep.oshi.jna.platform.windows.NtDll;
import com.gradle.maven.extension.internal.dep.oshi.software.common.AbstractOSProcess;
import com.gradle.maven.extension.internal.dep.oshi.software.os.OSProcess;
import com.gradle.maven.extension.internal.dep.oshi.software.os.windows.WindowsOperatingSystem;
import com.gradle.maven.extension.internal.dep.oshi.util.GlobalConfig;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.windows.WmiUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Pair;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Triplet;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsOSProcess
extends AbstractOSProcess {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsOSProcess.class);
    private static final boolean USE_BATCH_COMMANDLINE = GlobalConfig.get("com.gradle.maven.extension.internal.dep.oshi.os.windows.commandline.batch", false);
    private static final boolean USE_PROCSTATE_SUSPENDED = GlobalConfig.get("com.gradle.maven.extension.internal.dep.oshi.os.windows.procstate.suspended", false);
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();
    private static final boolean IS_WINDOWS7_OR_GREATER = VersionHelpers.IsWindows7OrGreater();
    private final WindowsOperatingSystem os;
    private Supplier<Pair<String, String>> userInfo = Memoizer.memoize(this::queryUserInfo);
    private Supplier<Pair<String, String>> groupInfo = Memoizer.memoize(this::queryGroupInfo);
    private Supplier<String> currentWorkingDirectory = Memoizer.memoize(this::queryCwd);
    private Supplier<String> commandLine = Memoizer.memoize(this::queryCommandLine);
    private Supplier<List<String>> args = Memoizer.memoize(this::queryArguments);
    private Supplier<Triplet<String, String, Map<String, String>>> cwdCmdEnv = Memoizer.memoize(this::queryCwdCommandlineEnvironment);
    private Map<Integer, ThreadPerformanceData.PerfCounterBlock> tcb;
    private String name;
    private String path;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private long bytesRead;
    private long bytesWritten;
    private long openFiles;
    private int bitness;
    private long pageFaults;

    public WindowsOSProcess(int n2, WindowsOperatingSystem windowsOperatingSystem, Map<Integer, ProcessPerformanceData.PerfCounterBlock> map, Map<Integer, ProcessWtsData.WtsInfo> map2, Map<Integer, ThreadPerformanceData.PerfCounterBlock> map3) {
        super(n2);
        this.os = windowsOperatingSystem;
        this.bitness = windowsOperatingSystem.getBitness();
        this.tcb = map3;
        this.updateAttributes(map.get(n2), map2.get(n2));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getCommandLine() {
        return this.commandLine.get();
    }

    @Override
    public List<String> getArguments() {
        return this.args.get();
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getBitness() {
        return this.bitness;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateAttributes(ProcessPerformanceData.PerfCounterBlock perfCounterBlock, ProcessWtsData.WtsInfo wtsInfo) {
        WinNT.HANDLE hANDLE;
        this.name = perfCounterBlock.getName();
        this.path = wtsInfo.getPath();
        this.parentProcessID = perfCounterBlock.getParentProcessID();
        this.threadCount = wtsInfo.getThreadCount();
        this.priority = perfCounterBlock.getPriority();
        this.virtualSize = wtsInfo.getVirtualSize();
        this.residentSetSize = perfCounterBlock.getResidentSetSize();
        this.kernelTime = wtsInfo.getKernelTime();
        this.userTime = wtsInfo.getUserTime();
        this.startTime = perfCounterBlock.getStartTime();
        this.upTime = perfCounterBlock.getUpTime();
        this.bytesRead = perfCounterBlock.getBytesRead();
        this.bytesWritten = perfCounterBlock.getBytesWritten();
        this.openFiles = wtsInfo.getOpenFiles();
        this.pageFaults = perfCounterBlock.getPageFaults();
        this.state = OSProcess.State.RUNNING;
        if (this.tcb != null) {
            int n2 = this.getProcessID();
            for (ThreadPerformanceData.PerfCounterBlock perfCounterBlock2 : this.tcb.values()) {
                if (perfCounterBlock2.getOwningProcessID() != n2) continue;
                if (perfCounterBlock2.getThreadWaitReason() == 5) {
                    this.state = OSProcess.State.SUSPENDED;
                    continue;
                }
                this.state = OSProcess.State.RUNNING;
                break;
            }
        }
        if ((hANDLE = Kernel32.INSTANCE.OpenProcess(1024, false, this.getProcessID())) != null) {
            try {
                if (IS_VISTA_OR_GREATER && this.bitness == 64) {
                    try (ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference();){
                        if (Kernel32.INSTANCE.IsWow64Process(hANDLE, closeableIntByReference) && closeableIntByReference.getValue() > 0) {
                            this.bitness = 32;
                        }
                    }
                }
                try {
                    if (IS_WINDOWS7_OR_GREATER) {
                        this.path = Kernel32Util.QueryFullProcessImageName(hANDLE, 0);
                    }
                }
                catch (Win32Exception win32Exception) {
                    this.state = OSProcess.State.INVALID;
                }
            }
            finally {
                Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }
        return !this.state.equals((Object)OSProcess.State.INVALID);
    }

    private String queryCommandLine() {
        if (!this.cwdCmdEnv.get().getB().isEmpty()) {
            return this.cwdCmdEnv.get().getB();
        }
        if (USE_BATCH_COMMANDLINE) {
            return Win32ProcessCached.getInstance().getCommandLine(this.getProcessID(), this.getStartTime());
        }
        WbemcliUtil.WmiResult<Win32Process.CommandLineProperty> wmiResult = Win32Process.queryCommandLines(Collections.singleton(this.getProcessID()));
        if (wmiResult.getResultCount() > 0) {
            return WmiUtil.getString(wmiResult, Win32Process.CommandLineProperty.COMMANDLINE, 0);
        }
        return "";
    }

    private List<String> queryArguments() {
        String string = this.getCommandLine();
        if (!string.isEmpty()) {
            return Arrays.asList(Shell32Util.CommandLineToArgv(string));
        }
        return Collections.emptyList();
    }

    private String queryCwd() {
        String string;
        if (!this.cwdCmdEnv.get().getA().isEmpty()) {
            return this.cwdCmdEnv.get().getA();
        }
        if (this.getProcessID() == this.os.getProcessId() && !(string = new File(".").getAbsolutePath()).isEmpty()) {
            return string.substring(0, string.length() - 1);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<String, String> queryUserInfo() {
        Pair<String, String> pair = null;
        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.OpenProcess(1024, false, this.getProcessID());
        if (hANDLE != null) {
            try (ByRef.CloseableHANDLEByReference closeableHANDLEByReference = new ByRef.CloseableHANDLEByReference();){
                try {
                    if (Advapi32.INSTANCE.OpenProcessToken(hANDLE, 10, closeableHANDLEByReference)) {
                        Advapi32Util.Account account = Advapi32Util.getTokenAccount(closeableHANDLEByReference.getValue());
                        pair = new Pair<String, String>(account.name, account.sidString);
                    } else {
                        int n2 = Kernel32.INSTANCE.GetLastError();
                        if (n2 != 5) {
                            LOG.error("Failed to get process token for process {}: {}", (Object)this.getProcessID(), (Object)Kernel32.INSTANCE.GetLastError());
                        }
                    }
                }
                catch (Win32Exception win32Exception) {
                    LOG.warn("Failed to query user info for process {} ({}): {}", new Object[]{this.getProcessID(), this.getName(), win32Exception.getMessage()});
                }
                finally {
                    WinNT.HANDLE hANDLE2 = closeableHANDLEByReference.getValue();
                    if (hANDLE2 != null) {
                        Kernel32.INSTANCE.CloseHandle(hANDLE2);
                    }
                    Kernel32.INSTANCE.CloseHandle(hANDLE);
                }
            }
        }
        if (pair == null) {
            return new Pair<String, String>("unknown", "unknown");
        }
        return pair;
    }

    private Pair<String, String> queryGroupInfo() {
        Pair<String, String> pair = null;
        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.OpenProcess(1024, false, this.getProcessID());
        if (hANDLE != null) {
            try (ByRef.CloseableHANDLEByReference closeableHANDLEByReference = new ByRef.CloseableHANDLEByReference();){
                Object object;
                if (Advapi32.INSTANCE.OpenProcessToken(hANDLE, 10, closeableHANDLEByReference)) {
                    object = Advapi32Util.getTokenPrimaryGroup(closeableHANDLEByReference.getValue());
                    pair = new Pair<String, String>(((Advapi32Util.Account)object).name, ((Advapi32Util.Account)object).sidString);
                } else {
                    int n2 = Kernel32.INSTANCE.GetLastError();
                    if (n2 != 5) {
                        LOG.error("Failed to get process token for process {}: {}", (Object)this.getProcessID(), (Object)Kernel32.INSTANCE.GetLastError());
                    }
                }
                object = closeableHANDLEByReference.getValue();
                if (object != null) {
                    Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)object);
                }
                Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }
        if (pair == null) {
            return new Pair<String, String>("unknown", "unknown");
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Triplet<String, String, Map<String, String>> queryCwdCommandlineEnvironment() {
        block20: {
            var1_1 = Kernel32.INSTANCE.OpenProcess(1040, false, this.getProcessID());
            if (var1_1 == null) break block20;
            try {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    if (WindowsOperatingSystem.isX86() != WindowsOperatingSystem.isWow(var1_1)) break block20;
                                    var2_2 = new ByRef.CloseableIntByReference();
                                    try {
                                        var3_3 = new NtDll.PROCESS_BASIC_INFORMATION();
                                        var4_5 = NtDll.INSTANCE.NtQueryInformationProcess(var1_1, 0, var3_3.getPointer(), var3_3.size(), var2_2);
                                        if (var4_5 == 0) break block21;
                                        var5_7 = WindowsOSProcess.defaultCwdCommandlineEnvironment();
                                        var2_2.close();
                                        return var5_7;
                                    }
                                    catch (Throwable var3_4) {
                                        try {
                                            var2_2.close();
                                        }
                                        catch (Throwable var4_6) {
                                            var3_4.addSuppressed(var4_6);
                                        }
                                        throw var3_4;
                                    }
                                }
                                var3_3.read();
                                var5_8 = new NtDll.PEB();
                                Kernel32.INSTANCE.ReadProcessMemory(var1_1, var3_3.PebBaseAddress, var5_8.getPointer(), var5_8.size(), var2_2);
                                if (var2_2.getValue() != 0) break block22;
                                var6_9 = WindowsOSProcess.defaultCwdCommandlineEnvironment();
                                var2_2.close();
                                return var6_9;
                            }
                            var5_8.read();
                            var6_10 = new NtDll.RTL_USER_PROCESS_PARAMETERS();
                            Kernel32.INSTANCE.ReadProcessMemory(var1_1, var5_8.ProcessParameters, var6_10.getPointer(), var6_10.size(), var2_2);
                            if (var2_2.getValue() != 0) break block23;
                            var7_11 = WindowsOSProcess.defaultCwdCommandlineEnvironment();
                            var2_2.close();
                            return var7_11;
                        }
                        var6_10.read();
                        var7_12 = WindowsOSProcess.readUnicodeString(var1_1, var6_10.CurrentDirectory.DosPath);
                        var8_13 = WindowsOSProcess.readUnicodeString(var1_1, var6_10.CommandLine);
                        var9_14 = var6_10.EnvironmentSize.intValue();
                        if (var9_14 <= 0) ** GOTO lbl74
                        var10_15 = new Memory(var9_14);
                        Kernel32.INSTANCE.ReadProcessMemory(var1_1, var6_10.Environment, (Pointer)var10_15, var9_14, var2_2);
                        if (var2_2.getValue() <= 0) break block24;
                        var11_16 = var10_15.getCharArray(0L, var9_14 / 2);
                        var12_18 = ParseUtil.parseCharArrayToStringMap(var11_16);
                        var12_18.remove("");
                        var13_20 = new Triplet<String, String, Map<String, String>>(var7_12, var8_13, Collections.unmodifiableMap(var12_18));
                        var10_15.close();
                        var2_2.close();
                        return var13_20;
                    }
                    var10_15.close();
                    break block25;
                    {
                        catch (Throwable var11_17) {
                            try {
                                var10_15.close();
                            }
                            catch (Throwable var12_19) {
                                var11_17.addSuppressed(var12_19);
                            }
                            throw var11_17;
                        }
                    }
                }
                var10_15 = new Triplet<String, String, Map<K, V>>(var7_12, var8_13, Collections.emptyMap());
                var2_2.close();
                return var10_15;
            }
            finally {
                Kernel32.INSTANCE.CloseHandle(var1_1);
            }
        }
        return WindowsOSProcess.defaultCwdCommandlineEnvironment();
    }

    private static Triplet<String, String, Map<String, String>> defaultCwdCommandlineEnvironment() {
        return new Triplet<String, String, Map<String, String>>("", "", Collections.emptyMap());
    }

    private static String readUnicodeString(WinNT.HANDLE hANDLE, NtDll.UNICODE_STRING uNICODE_STRING) {
        if (uNICODE_STRING.Length > 0) {
            try (Memory memory = new Memory((long)uNICODE_STRING.Length + 2L);
                 ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference();){
                memory.clear();
                Kernel32.INSTANCE.ReadProcessMemory(hANDLE, uNICODE_STRING.Buffer, memory, uNICODE_STRING.Length, closeableIntByReference);
                if (closeableIntByReference.getValue() > 0) {
                    String string = memory.getWideString(0L);
                    return string;
                }
            }
        }
        return "";
    }
}

