/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.software.os.unix.freebsd;

import com.gradle.maven.extension.internal.dep.oshi.jna.ByRef;
import com.gradle.maven.extension.internal.dep.oshi.jna.platform.unix.FreeBsdLibc;
import com.gradle.maven.extension.internal.dep.oshi.software.common.AbstractOSProcess;
import com.gradle.maven.extension.internal.dep.oshi.software.os.OSProcess;
import com.gradle.maven.extension.internal.dep.oshi.software.os.unix.freebsd.FreeBsdOperatingSystem;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.unix.freebsd.BsdSysctlUtil;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.platform.unix.LibCAPI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeBsdOSProcess
extends AbstractOSProcess {
    private static final Logger LOG = LoggerFactory.getLogger(FreeBsdOSProcess.class);
    private static final int ARGMAX = BsdSysctlUtil.sysctl("kern.argmax", 0);
    private final FreeBsdOperatingSystem os;
    static final String PS_THREAD_COLUMNS = Arrays.stream(PsThreadColumns.values()).map(Enum::name).map(string -> string.toLowerCase(Locale.ROOT)).collect(Collectors.joining(","));
    private Supplier<Integer> bitness = Memoizer.memoize(this::queryBitness);
    private Supplier<String> commandLine = Memoizer.memoize(this::queryCommandLine);
    private Supplier<List<String>> arguments = Memoizer.memoize(this::queryArguments);
    private Supplier<Map<String, String>> environmentVariables = Memoizer.memoize(this::queryEnvironmentVariables);
    private String name;
    private String path = "";
    private String user;
    private String userID;
    private String group;
    private String groupID;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private long minorFaults;
    private long majorFaults;
    private long contextSwitches;
    private String commandLineBackup;

    public FreeBsdOSProcess(int n2, Map<FreeBsdOperatingSystem.PsKeywords, String> map, FreeBsdOperatingSystem freeBsdOperatingSystem) {
        super(n2);
        this.os = freeBsdOperatingSystem;
        this.updateAttributes(map);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private String queryCommandLine() {
        String string = String.join((CharSequence)" ", this.getArguments());
        return string.isEmpty() ? this.commandLineBackup : string;
    }

    @Override
    public List<String> getArguments() {
        return this.arguments.get();
    }

    private List<String> queryArguments() {
        if (ARGMAX > 0) {
            int[] nArray = new int[]{1, 14, 7, this.getProcessID()};
            try (Memory memory = new Memory(ARGMAX);
                 ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)ARGMAX);){
                if (FreeBsdLibc.INSTANCE.sysctl(nArray, nArray.length, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO) == 0) {
                    List<String> list = Collections.unmodifiableList(ParseUtil.parseByteArrayToStrings(memory.getByteArray(0L, closeableSizeTByReference.getValue().intValue())));
                    return list;
                }
                LOG.warn("Failed sysctl call for process arguments (kern.proc.args), process {} may not exist. Error code: {}", (Object)this.getProcessID(), (Object)Native.getLastError());
            }
        }
        return Collections.emptyList();
    }

    private Map<String, String> queryEnvironmentVariables() {
        if (ARGMAX > 0) {
            int[] nArray = new int[]{1, 14, 35, this.getProcessID()};
            try (Memory memory = new Memory(ARGMAX);
                 ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)ARGMAX);){
                if (FreeBsdLibc.INSTANCE.sysctl(nArray, nArray.length, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO) == 0) {
                    Map<String, String> map = Collections.unmodifiableMap(ParseUtil.parseByteArrayToStringMap(memory.getByteArray(0L, closeableSizeTByReference.getValue().intValue())));
                    return map;
                }
                LOG.warn("Failed sysctl call for process environment variables (kern.proc.env), process {} may not exist. Error code: {}", (Object)this.getProcessID(), (Object)Native.getLastError());
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getBitness() {
        return this.bitness.get();
    }

    private int queryBitness() {
        int[] nArray = new int[]{1, 14, 9, this.getProcessID()};
        try (Memory memory = new Memory(32L);
             ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference(32L);){
            if (0 == FreeBsdLibc.INSTANCE.sysctl(nArray, nArray.length, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                String string = memory.getString(0L);
                if (string.contains("ELF32")) {
                    int n2 = 32;
                    return n2;
                }
                if (string.contains("ELF64")) {
                    int n3 = 64;
                    return n3;
                }
            }
        }
        return 0;
    }

    private boolean updateAttributes(Map<FreeBsdOperatingSystem.PsKeywords, String> map) {
        long l2 = System.currentTimeMillis();
        switch (map.get((Object)FreeBsdOperatingSystem.PsKeywords.STATE).charAt(0)) {
            case 'R': {
                this.state = OSProcess.State.RUNNING;
                break;
            }
            case 'I': 
            case 'S': {
                this.state = OSProcess.State.SLEEPING;
                break;
            }
            case 'D': 
            case 'L': 
            case 'U': {
                this.state = OSProcess.State.WAITING;
                break;
            }
            case 'Z': {
                this.state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                this.state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                this.state = OSProcess.State.OTHER;
            }
        }
        this.parentProcessID = ParseUtil.parseIntOrDefault(map.get((Object)FreeBsdOperatingSystem.PsKeywords.PPID), 0);
        this.user = map.get((Object)FreeBsdOperatingSystem.PsKeywords.USER);
        this.userID = map.get((Object)FreeBsdOperatingSystem.PsKeywords.UID);
        this.group = map.get((Object)FreeBsdOperatingSystem.PsKeywords.GROUP);
        this.groupID = map.get((Object)FreeBsdOperatingSystem.PsKeywords.GID);
        this.threadCount = ParseUtil.parseIntOrDefault(map.get((Object)FreeBsdOperatingSystem.PsKeywords.NLWP), 0);
        this.priority = ParseUtil.parseIntOrDefault(map.get((Object)FreeBsdOperatingSystem.PsKeywords.PRI), 0);
        this.virtualSize = ParseUtil.parseLongOrDefault(map.get((Object)FreeBsdOperatingSystem.PsKeywords.VSZ), 0L) * 1024L;
        this.residentSetSize = ParseUtil.parseLongOrDefault(map.get((Object)FreeBsdOperatingSystem.PsKeywords.RSS), 0L) * 1024L;
        long l3 = ParseUtil.parseDHMSOrDefault(map.get((Object)FreeBsdOperatingSystem.PsKeywords.ETIMES), 0L);
        this.upTime = l3 < 1L ? 1L : l3;
        this.startTime = l2 - this.upTime;
        this.kernelTime = ParseUtil.parseDHMSOrDefault(map.get((Object)FreeBsdOperatingSystem.PsKeywords.SYSTIME), 0L);
        this.userTime = ParseUtil.parseDHMSOrDefault(map.get((Object)FreeBsdOperatingSystem.PsKeywords.TIME), 0L) - this.kernelTime;
        this.path = map.get((Object)FreeBsdOperatingSystem.PsKeywords.COMM);
        this.name = this.path.substring(this.path.lastIndexOf(47) + 1);
        this.minorFaults = ParseUtil.parseLongOrDefault(map.get((Object)FreeBsdOperatingSystem.PsKeywords.MAJFLT), 0L);
        this.majorFaults = ParseUtil.parseLongOrDefault(map.get((Object)FreeBsdOperatingSystem.PsKeywords.MINFLT), 0L);
        long l4 = ParseUtil.parseLongOrDefault(map.get((Object)FreeBsdOperatingSystem.PsKeywords.NVCSW), 0L);
        long l5 = ParseUtil.parseLongOrDefault(map.get((Object)FreeBsdOperatingSystem.PsKeywords.NIVCSW), 0L);
        this.contextSwitches = l5 + l4;
        this.commandLineBackup = map.get((Object)FreeBsdOperatingSystem.PsKeywords.ARGS);
        return true;
    }

    static enum PsThreadColumns {
        TDNAME,
        LWP,
        STATE,
        ETIMES,
        SYSTIME,
        TIME,
        TDADDR,
        NIVCSW,
        NVCSW,
        MAJFLT,
        MINFLT,
        PRI;

    }
}

