/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.hardware.platform.windows;

import com.gradle.maven.extension.internal.dep.oshi.driver.windows.wmi.Win32BaseBoard;
import com.gradle.maven.extension.internal.dep.oshi.hardware.common.AbstractBaseboard;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import com.gradle.maven.extension.internal.dep.oshi.util.Util;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.windows.WmiUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Quartet;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.function.Supplier;

final class WindowsBaseboard
extends AbstractBaseboard {
    private final Supplier<Quartet<String, String, String, String>> manufModelVersSerial = Memoizer.memoize(WindowsBaseboard::queryManufModelVersSerial);

    WindowsBaseboard() {
    }

    @Override
    public String getManufacturer() {
        return this.manufModelVersSerial.get().getA();
    }

    @Override
    public String getModel() {
        return this.manufModelVersSerial.get().getB();
    }

    @Override
    public String getVersion() {
        return this.manufModelVersSerial.get().getC();
    }

    @Override
    public String getSerialNumber() {
        return this.manufModelVersSerial.get().getD();
    }

    private static Quartet<String, String, String, String> queryManufModelVersSerial() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        WbemcliUtil.WmiResult<Win32BaseBoard.BaseBoardProperty> wmiResult = Win32BaseBoard.queryBaseboardInfo();
        if (wmiResult.getResultCount() > 0) {
            string = WmiUtil.getString(wmiResult, Win32BaseBoard.BaseBoardProperty.MANUFACTURER, 0);
            string2 = WmiUtil.getString(wmiResult, Win32BaseBoard.BaseBoardProperty.MODEL, 0);
            String string5 = WmiUtil.getString(wmiResult, Win32BaseBoard.BaseBoardProperty.PRODUCT, 0);
            if (!Util.isBlank(string5)) {
                string2 = Util.isBlank(string2) ? string5 : string2 + " (" + string5 + ")";
            }
            string3 = WmiUtil.getString(wmiResult, Win32BaseBoard.BaseBoardProperty.VERSION, 0);
            string4 = WmiUtil.getString(wmiResult, Win32BaseBoard.BaseBoardProperty.SERIALNUMBER, 0);
        }
        return new Quartet<String, String, String, String>(Util.isBlank(string) ? "unknown" : string, Util.isBlank(string2) ? "unknown" : string2, Util.isBlank(string3) ? "unknown" : string3, Util.isBlank(string4) ? "unknown" : string4);
    }
}

