/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.hardware.platform.unix.solaris;

import com.gradle.maven.extension.internal.dep.oshi.driver.unix.solaris.kstat.SystemPages;
import com.gradle.maven.extension.internal.dep.oshi.hardware.VirtualMemory;
import com.gradle.maven.extension.internal.dep.oshi.hardware.common.AbstractGlobalMemory;
import com.gradle.maven.extension.internal.dep.oshi.hardware.platform.unix.solaris.SolarisVirtualMemory;
import com.gradle.maven.extension.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Pair;
import java.util.function.Supplier;

final class SolarisGlobalMemory
extends AbstractGlobalMemory {
    private final Supplier<Pair<Long, Long>> availTotal = Memoizer.memoize(SystemPages::queryAvailableTotal, Memoizer.defaultExpiration());
    private final Supplier<Long> pageSize = Memoizer.memoize(SolarisGlobalMemory::queryPageSize);
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    SolarisGlobalMemory() {
    }

    @Override
    public long getAvailable() {
        return this.availTotal.get().getA() * this.getPageSize();
    }

    @Override
    public long getTotal() {
        return this.availTotal.get().getB() * this.getPageSize();
    }

    public long getPageSize() {
        return this.pageSize.get();
    }

    private static long queryPageSize() {
        return ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("pagesize"), 4096L);
    }

    private VirtualMemory createVirtualMemory() {
        return new SolarisVirtualMemory(this);
    }
}

