/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.hardware.platform.mac;

import com.gradle.maven.extension.internal.dep.oshi.hardware.VirtualMemory;
import com.gradle.maven.extension.internal.dep.oshi.hardware.common.AbstractGlobalMemory;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import com.sun.jna.Native;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MacGlobalMemory
extends AbstractGlobalMemory {
    private static final Logger LOG = LoggerFactory.getLogger(MacGlobalMemory.class);
    private final Supplier<Long> available = Memoizer.memoize(this::queryVmStats, Memoizer.defaultExpiration());
    private final Supplier<Long> total = Memoizer.memoize(this::queryPhysMem);
    private final Supplier<Long> pageSize = Memoizer.memoize(this::queryPageSize);
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    MacGlobalMemory() {
    }

    @Override
    public long getAvailable() {
        return this.available.get();
    }

    @Override
    public long getTotal() {
        return this.total.get();
    }

    public long getPageSize() {
        return this.pageSize.get();
    }

    protected abstract long queryVmStats();

    protected abstract long sysctl(String var1, long var2);

    private long queryPhysMem() {
        return this.sysctl("hw.memsize", 0L);
    }

    private long queryPageSize() {
        long l2 = this.host_page_size();
        if (l2 > 0L) {
            return l2;
        }
        LOG.error("Failed to get host page size. Error code: {}", (Object)Native.getLastError());
        return 4098L;
    }

    protected abstract long host_page_size();

    protected abstract VirtualMemory createVirtualMemory();
}

