/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.Operation;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Operator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.NumberUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class OpPlus
extends Operator {
    public OpPlus(int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super("+", n2, n3, spelNodeImplArray);
        Assert.notEmpty(spelNodeImplArray, "Operands must not be empty");
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        SpelNodeImpl spelNodeImpl = this.getLeftOperand();
        if (this.children.length < 2) {
            Object object = spelNodeImpl.getValueInternal(expressionState).getValue();
            if (object instanceof Number) {
                if (object instanceof Double) {
                    this.exitTypeDescriptor = "D";
                } else if (object instanceof Float) {
                    this.exitTypeDescriptor = "F";
                } else if (object instanceof Long) {
                    this.exitTypeDescriptor = "J";
                } else if (object instanceof Integer) {
                    this.exitTypeDescriptor = "I";
                }
                return new TypedValue(object);
            }
            return expressionState.operate(Operation.ADD, object, null);
        }
        TypedValue typedValue = spelNodeImpl.getValueInternal(expressionState);
        Object object = typedValue.getValue();
        TypedValue typedValue2 = this.getRightOperand().getValueInternal(expressionState);
        Object object2 = typedValue2.getValue();
        if (object instanceof Number && object2 instanceof Number) {
            Number number = (Number)object;
            Number number2 = (Number)object2;
            if (number instanceof BigDecimal || number2 instanceof BigDecimal) {
                BigDecimal bigDecimal = NumberUtils.convertNumberToTargetClass(number, BigDecimal.class);
                BigDecimal bigDecimal2 = NumberUtils.convertNumberToTargetClass(number2, BigDecimal.class);
                return new TypedValue(bigDecimal.add(bigDecimal2));
            }
            if (number instanceof Double || number2 instanceof Double) {
                this.exitTypeDescriptor = "D";
                return new TypedValue(number.doubleValue() + number2.doubleValue());
            }
            if (number instanceof Float || number2 instanceof Float) {
                this.exitTypeDescriptor = "F";
                return new TypedValue(Float.valueOf(number.floatValue() + number2.floatValue()));
            }
            if (number instanceof BigInteger || number2 instanceof BigInteger) {
                BigInteger bigInteger = NumberUtils.convertNumberToTargetClass(number, BigInteger.class);
                BigInteger bigInteger2 = NumberUtils.convertNumberToTargetClass(number2, BigInteger.class);
                return new TypedValue(bigInteger.add(bigInteger2));
            }
            if (number instanceof Long || number2 instanceof Long) {
                this.exitTypeDescriptor = "J";
                return new TypedValue(number.longValue() + number2.longValue());
            }
            if (CodeFlow.isIntegerForNumericOp(number) || CodeFlow.isIntegerForNumericOp(number2)) {
                this.exitTypeDescriptor = "I";
                return new TypedValue(number.intValue() + number2.intValue());
            }
            return new TypedValue(number.doubleValue() + number2.doubleValue());
        }
        if (object instanceof String && object2 instanceof String) {
            this.exitTypeDescriptor = "Ljava/lang/String";
            String string = (String)object;
            String string2 = (String)object2;
            this.checkStringLength(string);
            this.checkStringLength(string2);
            return this.concatenate(string, string2);
        }
        if (object instanceof String) {
            String string = (String)object;
            this.checkStringLength(string);
            String string3 = object2 == null ? "null" : OpPlus.convertTypedValueToString(typedValue2, expressionState);
            this.checkStringLength(string3);
            return this.concatenate(string, string3);
        }
        if (object2 instanceof String) {
            String string = (String)object2;
            this.checkStringLength(string);
            String string4 = object == null ? "null" : OpPlus.convertTypedValueToString(typedValue, expressionState);
            this.checkStringLength(string4);
            return this.concatenate(string4, string);
        }
        return expressionState.operate(Operation.ADD, object, object2);
    }

    private void checkStringLength(String string) {
        if (string.length() > 100000) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.MAX_CONCATENATED_STRING_LENGTH_EXCEEDED, 100000);
        }
    }

    private TypedValue concatenate(String string, String string2) {
        String string3 = string + string2;
        this.checkStringLength(string3);
        return new TypedValue(string3);
    }

    @Override
    public String toStringAST() {
        if (this.children.length < 2) {
            return "+" + this.getLeftOperand().toStringAST();
        }
        return super.toStringAST();
    }

    @Override
    public SpelNodeImpl getRightOperand() {
        if (this.children.length < 2) {
            throw new IllegalStateException("No right operand");
        }
        return this.children[1];
    }

    private static String convertTypedValueToString(TypedValue typedValue, ExpressionState expressionState) {
        TypeConverter typeConverter = expressionState.getEvaluationContext().getTypeConverter();
        TypeDescriptor typeDescriptor = TypeDescriptor.valueOf(String.class);
        if (typeConverter.canConvert(typedValue.getTypeDescriptor(), typeDescriptor)) {
            return String.valueOf(typeConverter.convertValue(typedValue.getValue(), typedValue.getTypeDescriptor(), typeDescriptor));
        }
        return String.valueOf(typedValue.getValue());
    }

    @Override
    public boolean isCompilable() {
        if (!this.getLeftOperand().isCompilable()) {
            return false;
        }
        if (this.children.length > 1 && !this.getRightOperand().isCompilable()) {
            return false;
        }
        return this.exitTypeDescriptor != null;
    }

    private void walk(MethodVisitor methodVisitor, CodeFlow codeFlow, SpelNodeImpl spelNodeImpl) {
        if (spelNodeImpl instanceof OpPlus) {
            OpPlus opPlus = (OpPlus)spelNodeImpl;
            this.walk(methodVisitor, codeFlow, opPlus.getLeftOperand());
            this.walk(methodVisitor, codeFlow, opPlus.getRightOperand());
        } else if (spelNodeImpl != null) {
            codeFlow.enterCompilationScope();
            spelNodeImpl.generateCode(methodVisitor, codeFlow);
            if (!"Ljava/lang/String".equals(codeFlow.lastDescriptor())) {
                methodVisitor.visitTypeInsn(192, "java/lang/String");
            }
            codeFlow.exitCompilationScope();
            methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        }
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        if ("Ljava/lang/String".equals(this.exitTypeDescriptor)) {
            methodVisitor.visitTypeInsn(187, "java/lang/StringBuilder");
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
            this.walk(methodVisitor, codeFlow, this.getLeftOperand());
            this.walk(methodVisitor, codeFlow, this.getRightOperand());
            methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        } else {
            this.children[0].generateCode(methodVisitor, codeFlow);
            String string = this.children[0].exitTypeDescriptor;
            String string2 = this.exitTypeDescriptor;
            Assert.state(string2 != null, "No exit type descriptor");
            char c2 = string2.charAt(0);
            CodeFlow.insertNumericUnboxOrPrimitiveTypeCoercion(methodVisitor, string, c2);
            if (this.children.length > 1) {
                codeFlow.enterCompilationScope();
                this.children[1].generateCode(methodVisitor, codeFlow);
                String string3 = this.children[1].exitTypeDescriptor;
                codeFlow.exitCompilationScope();
                CodeFlow.insertNumericUnboxOrPrimitiveTypeCoercion(methodVisitor, string3, c2);
                switch (c2) {
                    case 'I': {
                        methodVisitor.visitInsn(96);
                        break;
                    }
                    case 'J': {
                        methodVisitor.visitInsn(97);
                        break;
                    }
                    case 'F': {
                        methodVisitor.visitInsn(98);
                        break;
                    }
                    case 'D': {
                        methodVisitor.visitInsn(99);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unrecognized exit type descriptor: '" + this.exitTypeDescriptor + "'");
                    }
                }
            }
        }
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }
}

