/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms;

import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.AsmModuleInfoParser;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.BinaryModuleInfoParser;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.CmdModuleNameExtractor;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.MainClassModuleNameExtractor;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ManifestModuleNameExtractor;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ModuleInfoParser;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ModuleNameExtractor;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ModuleNameSource;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ResolvePathRequest;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ResolvePathResult;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.SourceModuleInfoParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class LocationManager {
    private SourceModuleInfoParser sourceParser = new SourceModuleInfoParser();
    private ManifestModuleNameExtractor manifestModuleNameExtractor = new ManifestModuleNameExtractor();

    public <T> ResolvePathResult resolvePath(final ResolvePathRequest<T> resolvePathRequest) throws IOException {
        ModuleNameExtractor moduleNameExtractor = new ModuleNameExtractor(){
            MainClassModuleNameExtractor extractor;
            final /* synthetic */ LocationManager this$0;
            {
                this.this$0 = locationManager;
                this.extractor = new MainClassModuleNameExtractor(resolvePathRequest.getJdkHome());
            }

            @Override
            public String extract(Path path) throws IOException {
                if (resolvePathRequest.getJdkHome() != null) {
                    return this.extractor.extract(Collections.singletonMap(path, path)).get(path);
                }
                return CmdModuleNameExtractor.getModuleName(path);
            }
        };
        return this.resolvePath(resolvePathRequest.toPath(resolvePathRequest.getPathElement()), moduleNameExtractor, this.getBinaryModuleInfoParser(resolvePathRequest.getJdkHome()));
    }

    public <T> ResolvePathsResult<T> resolvePaths(ResolvePathsRequest<T> resolvePathsRequest) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object422;
        ResolvePathsResult resolvePathsResult = resolvePathsRequest.createResult();
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>(resolvePathsRequest.getPathElements().size());
        ModuleInfoParser moduleInfoParser = this.getBinaryModuleInfoParser(resolvePathsRequest.getJdkHome());
        JavaModuleDescriptor javaModuleDescriptor = this.getMainModuleDescriptor(resolvePathsRequest, moduleInfoParser);
        resolvePathsResult.setMainModuleDescriptor(javaModuleDescriptor);
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        if (javaModuleDescriptor != null && resolvePathsRequest.isIncludeAllProviders()) {
            this.collectProviders(javaModuleDescriptor, hashMap);
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        HashMap<String, ModuleNameSource> hashMap3 = new HashMap<String, ModuleNameSource>();
        HashMap hashMap4 = new HashMap();
        for (Object object422 : resolvePathsRequest.getPathElements()) {
            ModuleNameSource moduleNameSource;
            JavaModuleDescriptor iterator;
            object3 = path -> {
                if (resolvePathsRequest.getJdkHome() == null) {
                    return CmdModuleNameExtractor.getModuleName(path);
                }
                hashMap4.put(object422, path);
                return null;
            };
            try {
                object2 = this.resolvePath(resolvePathsRequest.toPath(object422), (ModuleNameExtractor)object3, moduleInfoParser);
                iterator = ((ResolvePathResult)object2).getModuleDescriptor();
                moduleNameSource = ((ResolvePathResult)object2).getModuleNameSource();
            }
            catch (Exception exception) {
                resolvePathsResult.getPathExceptions().put(object422, exception);
                linkedHashMap.put(object422, null);
                continue;
            }
            if (iterator != null && hashMap3.putIfAbsent(iterator.name(), moduleNameSource) == null) {
                hashMap2.put(iterator.name(), iterator);
                if (resolvePathsRequest.isIncludeAllProviders()) {
                    this.collectProviders(iterator, hashMap);
                }
            }
            linkedHashMap.put(object422, iterator);
        }
        resolvePathsResult.setPathElements(linkedHashMap);
        if (!hashMap4.isEmpty()) {
            object = new MainClassModuleNameExtractor(resolvePathsRequest.getJdkHome());
            object422 = ((MainClassModuleNameExtractor)object).extract(hashMap4);
            for (Map.Entry entry : object422.entrySet()) {
                object3 = (String)entry.getValue();
                if (object3 == null) continue;
                object2 = JavaModuleDescriptor.newAutomaticModule((String)object3).build();
                hashMap3.put(((JavaModuleDescriptor)object2).name(), ModuleNameSource.FILENAME);
                hashMap2.put(((JavaModuleDescriptor)object2).name(), object2);
                linkedHashMap.put(entry.getKey(), object2);
            }
        }
        object = new HashSet();
        if (javaModuleDescriptor != null) {
            object.add(javaModuleDescriptor.name());
            this.selectRequires(javaModuleDescriptor, Collections.unmodifiableMap(hashMap2), Collections.unmodifiableMap(hashMap), (Set<String>)object, true, true, resolvePathsRequest.isIncludeStatic());
        }
        for (String string : resolvePathsRequest.getAdditionalModules()) {
            this.selectModule(string, Collections.unmodifiableMap(hashMap2), Collections.unmodifiableMap(hashMap), (Set<String>)object, true, true, resolvePathsRequest.isIncludeStatic());
        }
        object422 = new HashSet(object.size());
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            if (entry.getValue() != null && object.contains(((JavaModuleDescriptor)entry.getValue()).name())) {
                if (object422.add(((JavaModuleDescriptor)entry.getValue()).name())) {
                    resolvePathsResult.getModulepathElements().put(entry.getKey(), (ModuleNameSource)((Object)hashMap3.get(((JavaModuleDescriptor)entry.getValue()).name())));
                    continue;
                }
                resolvePathsResult.getPathExceptions().put(entry.getKey(), new IllegalStateException("Module '" + ((JavaModuleDescriptor)entry.getValue()).name() + "' is already on the module path!"));
                continue;
            }
            resolvePathsResult.getClasspathElements().add(entry.getKey());
        }
        return resolvePathsResult;
    }

    ModuleInfoParser getBinaryModuleInfoParser(Path path) {
        AsmModuleInfoParser asmModuleInfoParser = path == null ? new BinaryModuleInfoParser() : new AsmModuleInfoParser();
        return asmModuleInfoParser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> JavaModuleDescriptor getMainModuleDescriptor(ResolvePathsRequest<T> resolvePathsRequest, ModuleInfoParser moduleInfoParser) throws IOException {
        Path path = resolvePathsRequest.getMainModuleDescriptor();
        if (path == null) return resolvePathsRequest.getModuleDescriptor();
        if (path.endsWith("module-info.java")) {
            return this.sourceParser.fromSourcePath(path);
        }
        if (!path.endsWith("module-info.class")) throw new IOException("Invalid path to module descriptor: " + path);
        return moduleInfoParser.getModuleDescriptor(path.getParent());
    }

    private ResolvePathResult resolvePath(Path path, ModuleNameExtractor moduleNameExtractor, ModuleInfoParser moduleInfoParser) throws IOException {
        ResolvePathResult resolvePathResult = new ResolvePathResult();
        JavaModuleDescriptor javaModuleDescriptor = null;
        if (Files.isRegularFile(path, new LinkOption[0]) && !path.getFileName().toString().endsWith(".jar")) {
            throw new IllegalArgumentException("'" + path + "' not allowed on the path, only outputDirectories and jars are accepted");
        }
        if (Files.isRegularFile(path, new LinkOption[0]) || Files.exists(path.resolve("module-info.class"), new LinkOption[0])) {
            javaModuleDescriptor = moduleInfoParser.getModuleDescriptor(path);
        }
        if (javaModuleDescriptor != null) {
            resolvePathResult.setModuleNameSource(ModuleNameSource.MODULEDESCRIPTOR);
        } else {
            String string = this.manifestModuleNameExtractor.extract(path);
            if (string != null) {
                resolvePathResult.setModuleNameSource(ModuleNameSource.MANIFEST);
            } else {
                string = moduleNameExtractor.extract(path);
                if (string != null) {
                    resolvePathResult.setModuleNameSource(ModuleNameSource.FILENAME);
                }
            }
            if (string != null) {
                javaModuleDescriptor = JavaModuleDescriptor.newAutomaticModule(string).build();
            }
        }
        resolvePathResult.setModuleDescriptor(javaModuleDescriptor);
        return resolvePathResult;
    }

    private void selectRequires(JavaModuleDescriptor javaModuleDescriptor, Map<String, JavaModuleDescriptor> map, Map<String, Set<String>> map2, Set<String> set, boolean bl2, boolean bl3, boolean bl4) {
        for (JavaModuleDescriptor.JavaRequires object : javaModuleDescriptor.requires()) {
            if (!bl2 && !bl4 && !bl3 && object.modifiers().contains((Object)JavaModuleDescriptor.JavaRequires.JavaModifier.STATIC) && !object.modifiers().contains((Object)JavaModuleDescriptor.JavaRequires.JavaModifier.TRANSITIVE)) continue;
            this.selectModule(object.name(), map, map2, set, false, bl4, bl4);
        }
        for (String string : javaModuleDescriptor.uses()) {
            if (!map2.containsKey(string)) continue;
            for (String string2 : map2.get(string)) {
                JavaModuleDescriptor javaModuleDescriptor2 = map.get(string2);
                if (javaModuleDescriptor2 == null || !set.add(string2)) continue;
                this.selectRequires(javaModuleDescriptor2, map, map2, set, false, bl3, bl4);
            }
        }
    }

    private void selectModule(String string, Map<String, JavaModuleDescriptor> map, Map<String, Set<String>> map2, Set<String> set, boolean bl2, boolean bl3, boolean bl4) {
        JavaModuleDescriptor javaModuleDescriptor = map.get(string);
        if (javaModuleDescriptor != null && set.add(string)) {
            this.selectRequires(javaModuleDescriptor, map, map2, set, false, bl3, bl4);
        }
    }

    private void collectProviders(JavaModuleDescriptor javaModuleDescriptor, Map<String, Set<String>> map) {
        for (JavaModuleDescriptor.JavaProvides javaProvides : javaModuleDescriptor.provides()) {
            String string2 = javaProvides.service().replace('$', '.');
            Set set = map.computeIfAbsent(string2, string -> new HashSet());
            set.add(javaModuleDescriptor.name());
        }
    }
}

