/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.message;

import com.gradle.maven.extension.internal.dep.org.apache.http.Header;
import com.gradle.maven.extension.internal.dep.org.apache.http.HeaderIterator;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.BasicListHeaderIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HeaderGroup
implements Serializable,
Cloneable {
    private static final Header[] EMPTY = new Header[0];
    private final List<Header> headers = new ArrayList<Header>(16);

    public void clear() {
        this.headers.clear();
    }

    public void addHeader(Header header) {
        if (header == null) {
            return;
        }
        this.headers.add(header);
    }

    public void updateHeader(Header header) {
        if (header == null) {
            return;
        }
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            Header header2 = this.headers.get(i2);
            if (!header2.getName().equalsIgnoreCase(header.getName())) continue;
            this.headers.set(i2, header);
            return;
        }
        this.headers.add(header);
    }

    public void setHeaders(Header[] headerArray) {
        this.clear();
        if (headerArray == null) {
            return;
        }
        Collections.addAll(this.headers, headerArray);
    }

    public Header[] getHeaders(String string) {
        ArrayList<Header> arrayList = null;
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            Header header = this.headers.get(i2);
            if (!header.getName().equalsIgnoreCase(string)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Header>();
            }
            arrayList.add(header);
        }
        return arrayList != null ? arrayList.toArray(new Header[arrayList.size()]) : EMPTY;
    }

    public Header getFirstHeader(String string) {
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            Header header = this.headers.get(i2);
            if (!header.getName().equalsIgnoreCase(string)) continue;
            return header;
        }
        return null;
    }

    public Header[] getAllHeaders() {
        return this.headers.toArray(new Header[this.headers.size()]);
    }

    public boolean containsHeader(String string) {
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            Header header = this.headers.get(i2);
            if (!header.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public HeaderIterator iterator() {
        return new BasicListHeaderIterator(this.headers, null);
    }

    public HeaderIterator iterator(String string) {
        return new BasicListHeaderIterator(this.headers, string);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.headers.toString();
    }
}

