/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.reflect;

import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.StringUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.Validate;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.reflect.MemberUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Objects;

public class FieldUtils {
    public static Field getField(Class<?> clazz, String string, boolean bl2) {
        AnnotatedElement annotatedElement;
        Objects.requireNonNull(clazz, "cls");
        Validate.isTrue(StringUtils.isNotBlank(string), "The field name must not be blank/empty", new Object[0]);
        for (annotatedElement = clazz; annotatedElement != null; annotatedElement = annotatedElement.getSuperclass()) {
            try {
                Field field = annotatedElement.getDeclaredField(string);
                if (!MemberUtils.isPublic(field)) {
                    if (!bl2) continue;
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        annotatedElement = null;
        for (Class clazz2 : ClassUtils.getAllInterfaces(clazz)) {
            try {
                Field field = clazz2.getField(string);
                Validate.isTrue(annotatedElement == null, "Reference to field %s is ambiguous relative to %s; a matching field exists on two or more implemented interfaces.", string, clazz);
                annotatedElement = field;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return annotatedElement;
    }

    public static Object readField(Field field, Object object, boolean bl2) throws IllegalAccessException {
        Objects.requireNonNull(field, "field");
        return FieldUtils.setAccessible(field, bl2).get(object);
    }

    public static Object readField(Object object, String string, boolean bl2) throws IllegalAccessException {
        Objects.requireNonNull(object, "target");
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getField(clazz, string, bl2);
        Validate.isTrue(field != null, "Cannot locate field %s on %s", string, clazz);
        return FieldUtils.readField(field, object, false);
    }

    static Field setAccessible(Field field, boolean bl2) {
        if (bl2 && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field);
        }
        return field;
    }
}

