/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.input;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.IOUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.build.AbstractStreamBuilder;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.function.IOIntConsumer;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.input.Input;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class ProxyInputStream
extends FilterInputStream {
    private volatile boolean closed;
    private final IOIntConsumer afterRead;

    protected ProxyInputStream(AbstractBuilder<?, ?> abstractBuilder) throws IOException {
        this(abstractBuilder.getInputStream(), abstractBuilder);
    }

    public ProxyInputStream(InputStream inputStream) {
        super(inputStream);
        this.afterRead = IOIntConsumer.NOOP;
    }

    protected ProxyInputStream(InputStream inputStream, AbstractBuilder<?, ?> abstractBuilder) {
        super(inputStream);
        this.afterRead = abstractBuilder.getAfterRead() != null ? abstractBuilder.getAfterRead() : IOIntConsumer.NOOP;
    }

    protected void afterRead(int n2) throws IOException {
        this.afterRead.accept(n2);
    }

    @Override
    public int available() throws IOException {
        if (this.in != null && !this.isClosed()) {
            try {
                return this.in.available();
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
            }
        }
        return 0;
    }

    protected void beforeRead(int n2) throws IOException {
    }

    void checkOpen() throws IOException {
        Input.checkOpen(!this.isClosed());
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.in, this::handleIOException);
        this.closed = true;
    }

    protected void handleIOException(IOException iOException) throws IOException {
        throw iOException;
    }

    boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void mark(int n2) {
        if (this.in != null) {
            this.in.mark(n2);
        }
    }

    @Override
    public boolean markSupported() {
        return this.in != null && this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        try {
            this.beforeRead(1);
            int n2 = this.in.read();
            this.afterRead(n2 != -1 ? 1 : -1);
            return n2;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        try {
            this.beforeRead(IOUtils.length(byArray));
            int n2 = this.in.read(byArray);
            this.afterRead(n2);
            return n2;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.beforeRead(n3);
            int n4 = this.in.read(byArray, n2, n3);
            this.afterRead(n4);
            return n4;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.in.reset();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public long skip(long l2) throws IOException {
        try {
            return this.in.skip(l2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return 0L;
        }
    }

    protected static abstract class AbstractBuilder<T, B extends AbstractStreamBuilder<T, B>>
    extends AbstractStreamBuilder<T, B> {
        private IOIntConsumer afterRead;

        protected AbstractBuilder() {
        }

        public IOIntConsumer getAfterRead() {
            return this.afterRead;
        }
    }
}

