/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.codec.binary;

import com.gradle.maven.extension.internal.dep.org.apache.commons.codec.CodecPolicy;
import com.gradle.maven.extension.internal.dep.org.apache.commons.codec.binary.BinaryCodec;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class BaseNCodec {
    protected static final CodecPolicy DECODING_POLICY_DEFAULT = CodecPolicy.LENIENT;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @Deprecated
    protected final byte PAD = (byte)61;
    protected final byte pad;
    private final int unencodedBlockSize;
    private final int encodedBlockSize;
    protected final int lineLength;
    private final int chunkSeparatorLength;
    private final CodecPolicy decodingPolicy;
    final byte[] decodeTable;
    final byte[] encodeTable;

    private static int createPositiveCapacity(int n2) {
        if (n2 < 0) {
            throw new OutOfMemoryError("Unable to allocate array size: " + ((long)n2 & 0xFFFFFFFFL));
        }
        return Math.max(n2, 0x7FFFFFF7);
    }

    private static byte[] resizeBuffer(Context context, int n2) {
        int n3 = context.buffer.length;
        int n4 = n3 * 2;
        if (Integer.compareUnsigned(n4, n2) < 0) {
            n4 = n2;
        }
        if (Integer.compareUnsigned(n4, 0x7FFFFFF7) > 0) {
            n4 = BaseNCodec.createPositiveCapacity(n2);
        }
        byte[] byArray = Arrays.copyOf(context.buffer, n4);
        context.buffer = byArray;
        return byArray;
    }

    protected BaseNCodec(AbstractBuilder<?, ?> abstractBuilder) {
        this.unencodedBlockSize = ((AbstractBuilder)abstractBuilder).unencodedBlockSize;
        this.encodedBlockSize = ((AbstractBuilder)abstractBuilder).encodedBlockSize;
        boolean bl2 = ((AbstractBuilder)abstractBuilder).lineLength > 0 && ((AbstractBuilder)abstractBuilder).lineSeparator.length > 0;
        this.lineLength = bl2 ? ((AbstractBuilder)abstractBuilder).lineLength / ((AbstractBuilder)abstractBuilder).encodedBlockSize * ((AbstractBuilder)abstractBuilder).encodedBlockSize : 0;
        this.chunkSeparatorLength = ((AbstractBuilder)abstractBuilder).lineSeparator.length;
        this.pad = ((AbstractBuilder)abstractBuilder).padding;
        this.decodingPolicy = Objects.requireNonNull(((AbstractBuilder)abstractBuilder).decodingPolicy, "codecPolicy");
        this.encodeTable = Objects.requireNonNull(abstractBuilder.getEncodeTable(), "builder.getEncodeTable()");
        this.decodeTable = abstractBuilder.getDecodeTable();
    }

    int available(Context context) {
        return this.hasData(context) ? context.pos - context.readPos : 0;
    }

    protected boolean containsAlphabetOrPad(byte[] byArray) {
        if (byArray != null) {
            for (byte by2 : byArray) {
                if (this.pad != by2 && !this.isInAlphabet(by2)) continue;
                return true;
            }
        }
        return false;
    }

    public byte[] decode(byte[] byArray) {
        if (BinaryCodec.isEmpty(byArray)) {
            return byArray;
        }
        Context context = new Context();
        this.decode(byArray, 0, byArray.length, context);
        this.decode(byArray, 0, -1, context);
        byte[] byArray2 = new byte[context.pos];
        this.readResults(byArray2, 0, byArray2.length, context);
        return byArray2;
    }

    abstract void decode(byte[] var1, int var2, int var3, Context var4);

    public byte[] encode(byte[] byArray) {
        if (BinaryCodec.isEmpty(byArray)) {
            return byArray;
        }
        return this.encode(byArray, 0, byArray.length);
    }

    public byte[] encode(byte[] byArray, int n2, int n3) {
        if (BinaryCodec.isEmpty(byArray)) {
            return byArray;
        }
        Context context = new Context();
        this.encode(byArray, n2, n3, context);
        this.encode(byArray, n2, -1, context);
        byte[] byArray2 = new byte[context.pos - context.readPos];
        this.readResults(byArray2, 0, byArray2.length, context);
        return byArray2;
    }

    abstract void encode(byte[] var1, int var2, int var3, Context var4);

    protected byte[] ensureBufferSize(int n2, Context context) {
        if (context.buffer == null) {
            context.buffer = new byte[Math.max(n2, this.getDefaultBufferSize())];
            context.pos = 0;
            context.readPos = 0;
        } else if (context.pos + n2 - context.buffer.length > 0) {
            return BaseNCodec.resizeBuffer(context, context.pos + n2);
        }
        return context.buffer;
    }

    protected int getDefaultBufferSize() {
        return 8192;
    }

    public long getEncodedLength(byte[] byArray) {
        long l2 = (long)((byArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
        if (this.lineLength > 0) {
            l2 += (l2 + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
        }
        return l2;
    }

    boolean hasData(Context context) {
        return context.pos > context.readPos;
    }

    protected abstract boolean isInAlphabet(byte var1);

    public boolean isStrictDecoding() {
        return this.decodingPolicy == CodecPolicy.STRICT;
    }

    int readResults(byte[] byArray, int n2, int n3, Context context) {
        if (this.hasData(context)) {
            int n4 = Math.min(this.available(context), n3);
            System.arraycopy(context.buffer, context.readPos, byArray, n2, n4);
            context.readPos += n4;
            if (!this.hasData(context)) {
                context.readPos = 0;
                context.pos = 0;
            }
            return n4;
        }
        return context.eof ? -1 : 0;
    }

    static class Context {
        int ibitWorkArea;
        long lbitWorkArea;
        byte[] buffer;
        int pos;
        int readPos;
        boolean eof;
        int currentLinePos;
        int modulus;

        Context() {
        }

        public String toString() {
            return String.format("%s[buffer=%s, currentLinePos=%s, eof=%s, ibitWorkArea=%s, lbitWorkArea=%s, modulus=%s, pos=%s, readPos=%s]", this.getClass().getSimpleName(), Arrays.toString(this.buffer), this.currentLinePos, this.eof, this.ibitWorkArea, this.lbitWorkArea, this.modulus, this.pos, this.readPos);
        }
    }

    public static abstract class AbstractBuilder<T, B extends AbstractBuilder<T, B>>
    implements Supplier<T> {
        private int unencodedBlockSize;
        private int encodedBlockSize;
        private CodecPolicy decodingPolicy = DECODING_POLICY_DEFAULT;
        private int lineLength;
        private byte[] lineSeparator = CHUNK_SEPARATOR;
        private final byte[] defaultEncodeTable;
        private byte[] encodeTable;
        private byte[] decodeTable;
        private byte padding = (byte)61;

        AbstractBuilder(byte[] byArray) {
            this.defaultEncodeTable = byArray;
            this.encodeTable = byArray;
        }

        B asThis() {
            return (B)this;
        }

        byte[] getDecodeTable() {
            return this.decodeTable;
        }

        byte[] getEncodeTable() {
            return this.encodeTable;
        }

        int getLineLength() {
            return this.lineLength;
        }

        byte[] getLineSeparator() {
            return this.lineSeparator;
        }

        B setDecodeTableRaw(byte[] byArray) {
            this.decodeTable = byArray;
            return this.asThis();
        }

        public B setDecodingPolicy(CodecPolicy codecPolicy) {
            this.decodingPolicy = codecPolicy != null ? codecPolicy : DECODING_POLICY_DEFAULT;
            return this.asThis();
        }

        B setEncodedBlockSize(int n2) {
            this.encodedBlockSize = n2;
            return this.asThis();
        }

        B setEncodeTableRaw(byte ... byArray) {
            this.encodeTable = byArray != null ? byArray : this.defaultEncodeTable;
            return this.asThis();
        }

        public B setLineLength(int n2) {
            this.lineLength = Math.max(0, n2);
            return this.asThis();
        }

        public B setLineSeparator(byte ... byArray) {
            this.lineSeparator = byArray != null ? (byte[])byArray.clone() : CHUNK_SEPARATOR;
            return this.asThis();
        }

        public B setPadding(byte by2) {
            this.padding = by2;
            return this.asThis();
        }

        B setUnencodedBlockSize(int n2) {
            this.unencodedBlockSize = n2;
            return this.asThis();
        }
    }
}

