/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi;

import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.TextColor;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.Visitor;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.BackgroundColor;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.BoldOff;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.BoldOn;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.CarriageReturn;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.CursorBackward;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.CursorDown;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.CursorForward;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.CursorToColumn;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.CursorUp;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.EraseInLine;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.EraseToBeginningOfLine;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.EraseToEndOfLine;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.ForegroundColor;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.NewLine;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.Text;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.Token;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.UnrecognizedControlSequence;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class AnsiParser {
    public OutputStream newParser(String string, Visitor visitor) {
        try {
            Charset charset = Charset.forName(string);
            return new ParsingStream(new AnsiByteConsumer(charset, visitor));
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not parse input", exception);
        }
    }

    private static void split(String string, Visitor visitor) {
        int n2 = 0;
        while (n2 < string.length()) {
            int n3;
            if (string.charAt(n2) == '\n') {
                visitor.visit(NewLine.INSTANCE);
                ++n2;
                continue;
            }
            if (string.charAt(n2) == '\r') {
                visitor.visit(CarriageReturn.INSTANCE);
                ++n2;
                continue;
            }
            for (n3 = n2; n3 < string.length() && string.charAt(n3) != '\n' && string.charAt(n3) != '\r'; ++n3) {
            }
            visitor.visit(new Text(string.substring(n2, n3)));
            n2 = n3;
        }
    }

    private static boolean parse(String string, char c2, Visitor visitor) {
        if (c2 == 'A') {
            if (string.isEmpty()) {
                visitor.visit(new CursorUp(1));
            } else {
                visitor.visit(new CursorUp(Integer.parseInt(string)));
            }
            return true;
        }
        if (c2 == 'B') {
            if (string.isEmpty()) {
                visitor.visit(new CursorDown(1));
            } else {
                visitor.visit(new CursorDown(Integer.parseInt(string)));
            }
            return true;
        }
        if (c2 == 'C') {
            if (string.isEmpty()) {
                visitor.visit(new CursorForward(1));
            } else {
                visitor.visit(new CursorForward(Integer.parseInt(string)));
            }
            return true;
        }
        if (c2 == 'D') {
            if (string.isEmpty()) {
                visitor.visit(new CursorBackward(1));
            } else {
                visitor.visit(new CursorBackward(Integer.parseInt(string)));
            }
            return true;
        }
        if (c2 == 'K') {
            if (string.isEmpty() || string.equals("0")) {
                visitor.visit(EraseToEndOfLine.INSTANCE);
                return true;
            }
            if (string.equals("1")) {
                visitor.visit(EraseToBeginningOfLine.INSTANCE);
                return true;
            }
            if (string.equals("2")) {
                visitor.visit(EraseInLine.INSTANCE);
                return true;
            }
        }
        if (c2 == 'G') {
            if (string.isEmpty() || string.equals("1")) {
                visitor.visit(new CursorToColumn(1));
            } else {
                visitor.visit(new CursorToColumn(Integer.parseInt(string)));
            }
            return true;
        }
        if (c2 == 'm') {
            if (string.isEmpty()) {
                visitor.visit(ForegroundColor.DEFAULT);
                visitor.visit(BackgroundColor.DEFAULT);
                visitor.visit(BoldOff.INSTANCE);
                return true;
            }
            if (string.contains(";")) {
                int n2 = 0;
                CollectingVisitor collectingVisitor = new CollectingVisitor();
                while (n2 < string.length()) {
                    int n3 = string.indexOf(59, n2);
                    if (n3 < 0) {
                        n3 = string.length();
                    } else if (n3 == n2) {
                        return false;
                    }
                    String object = string.substring(n2, n3);
                    if (!AnsiParser.parseTextAttribute(object, collectingVisitor)) {
                        return false;
                    }
                    if (n3 == string.length() - 1) {
                        return false;
                    }
                    n2 = n3 + 1;
                }
                for (Token token : collectingVisitor.tokens) {
                    visitor.visit(token);
                }
                return true;
            }
            if (AnsiParser.parseTextAttribute(string, visitor)) {
                return true;
            }
        }
        return false;
    }

    private static boolean parseTextAttribute(String string, Visitor visitor) {
        if (string.equals("0")) {
            visitor.visit(ForegroundColor.DEFAULT);
            visitor.visit(BackgroundColor.DEFAULT);
            visitor.visit(BoldOff.INSTANCE);
            return true;
        }
        if (string.equals("01") || string.equals("1")) {
            visitor.visit(BoldOn.INSTANCE);
            return true;
        }
        if (string.equals("22")) {
            visitor.visit(BoldOff.INSTANCE);
            return true;
        }
        if (string.equals("39")) {
            visitor.visit(ForegroundColor.DEFAULT);
            return true;
        }
        if (string.equals("30")) {
            visitor.visit(ForegroundColor.of(TextColor.BLACK));
            return true;
        }
        if (string.equals("31")) {
            visitor.visit(ForegroundColor.of(TextColor.RED));
            return true;
        }
        if (string.equals("32")) {
            visitor.visit(ForegroundColor.of(TextColor.GREEN));
            return true;
        }
        if (string.equals("33")) {
            visitor.visit(ForegroundColor.of(TextColor.YELLOW));
            return true;
        }
        if (string.equals("34")) {
            visitor.visit(ForegroundColor.of(TextColor.BLUE));
            return true;
        }
        if (string.equals("35")) {
            visitor.visit(ForegroundColor.of(TextColor.MAGENTA));
            return true;
        }
        if (string.equals("36")) {
            visitor.visit(ForegroundColor.of(TextColor.CYAN));
            return true;
        }
        if (string.equals("37")) {
            visitor.visit(ForegroundColor.of(TextColor.WHITE));
            return true;
        }
        if (string.equals("90")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_BLACK));
            return true;
        }
        if (string.equals("91")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_RED));
            return true;
        }
        if (string.equals("92")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_GREEN));
            return true;
        }
        if (string.equals("93")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_YELLOW));
            return true;
        }
        if (string.equals("94")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_BLUE));
            return true;
        }
        if (string.equals("95")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_MAGENTA));
            return true;
        }
        if (string.equals("96")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_CYAN));
            return true;
        }
        if (string.equals("97")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_WHITE));
            return true;
        }
        if (string.equals("40")) {
            visitor.visit(BackgroundColor.of(TextColor.BLACK));
            return true;
        }
        if (string.equals("41")) {
            visitor.visit(BackgroundColor.of(TextColor.RED));
            return true;
        }
        if (string.equals("42")) {
            visitor.visit(BackgroundColor.of(TextColor.GREEN));
            return true;
        }
        if (string.equals("43")) {
            visitor.visit(BackgroundColor.of(TextColor.YELLOW));
            return true;
        }
        if (string.equals("44")) {
            visitor.visit(BackgroundColor.of(TextColor.BLUE));
            return true;
        }
        if (string.equals("45")) {
            visitor.visit(BackgroundColor.of(TextColor.MAGENTA));
            return true;
        }
        if (string.equals("46")) {
            visitor.visit(BackgroundColor.of(TextColor.CYAN));
            return true;
        }
        if (string.equals("47")) {
            visitor.visit(BackgroundColor.of(TextColor.WHITE));
            return true;
        }
        if (string.equals("49")) {
            visitor.visit(BackgroundColor.DEFAULT);
            return true;
        }
        if (string.equals("100")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_BLACK));
            return true;
        }
        if (string.equals("101")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_RED));
            return true;
        }
        if (string.equals("102")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_GREEN));
            return true;
        }
        if (string.equals("103")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_YELLOW));
            return true;
        }
        if (string.equals("104")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_BLUE));
            return true;
        }
        if (string.equals("105")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_MAGENTA));
            return true;
        }
        if (string.equals("106")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_CYAN));
            return true;
        }
        if (string.equals("107")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_WHITE));
            return true;
        }
        return false;
    }

    private static class CollectingVisitor
    implements Visitor {
        final List<Token> tokens = new ArrayList<Token>();

        private CollectingVisitor() {
        }

        @Override
        public void visit(Token token) {
            this.tokens.add(token);
        }
    }

    private static class Buffer {
        private final byte[] buffer;
        private int offset;
        private int length;

        Buffer(byte[] byArray, int n2, int n3) {
            this.buffer = byArray;
            this.offset = n2;
            this.length = n3;
        }

        String consumeString(Charset charset) {
            return new String(this.buffer, this.offset, this.length, charset);
        }

        byte peek() {
            return this.buffer[this.offset];
        }

        void consume() {
            ++this.offset;
            --this.length;
        }

        boolean hasMore() {
            return this.length > 0;
        }

        Buffer consumeToNext(byte by2) {
            int n2 = this.offset + this.length;
            for (int i2 = this.offset; i2 < n2; ++i2) {
                if (this.buffer[i2] != by2) continue;
                int n3 = i2 - this.offset;
                Buffer buffer = new Buffer(this.buffer, this.offset, n3);
                this.offset = i2;
                this.length -= n3;
                return buffer;
            }
            return null;
        }
    }

    private static class AnsiByteConsumer {
        private final StringBuilder currentSequence = new StringBuilder();
        private final Charset charset;
        private final Visitor visitor;
        private State state = State.Normal;

        AnsiByteConsumer(Charset charset, Visitor visitor) {
            this.charset = charset;
            this.visitor = visitor;
        }

        void consume(Buffer buffer) {
            block6: while (buffer.hasMore()) {
                switch (this.state) {
                    case LeftParen: {
                        if (buffer.peek() != 91) {
                            this.visitor.visit(new UnrecognizedControlSequence(""));
                            this.state = State.Normal;
                            continue block6;
                        }
                        buffer.consume();
                        this.state = State.Param;
                        continue block6;
                    }
                    case Param: {
                        byte by2 = buffer.peek();
                        if ((by2 < 48 || by2 > 57) && by2 != 59) {
                            this.state = State.Code;
                            continue block6;
                        }
                        this.currentSequence.append((char)by2);
                        buffer.consume();
                        continue block6;
                    }
                    case Code: {
                        char c2 = (char)buffer.peek();
                        if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                            buffer.consume();
                            if (!AnsiParser.parse(this.currentSequence.toString(), c2, this.visitor)) {
                                this.visitor.visit(new UnrecognizedControlSequence("[" + this.currentSequence.toString() + c2));
                            }
                        } else {
                            this.visitor.visit(new UnrecognizedControlSequence("[" + this.currentSequence.toString()));
                        }
                        this.currentSequence.setLength(0);
                        this.state = State.Normal;
                        continue block6;
                    }
                    case Normal: {
                        Buffer buffer2 = buffer.consumeToNext((byte)27);
                        if (buffer2 == null) {
                            AnsiParser.split(buffer.consumeString(this.charset), this.visitor);
                            return;
                        }
                        AnsiParser.split(buffer2.consumeString(this.charset), this.visitor);
                        this.state = State.LeftParen;
                        buffer.consume();
                        this.currentSequence.setLength(0);
                        continue block6;
                    }
                }
                throw new IllegalStateException();
            }
        }
    }

    static enum State {
        Normal,
        LeftParen,
        Param,
        Code;

    }

    private static class ParsingStream
    extends OutputStream {
        private final AnsiByteConsumer sink;

        ParsingStream(AnsiByteConsumer ansiByteConsumer) {
            this.sink = ansiByteConsumer;
        }

        @Override
        public void write(int n2) throws IOException {
            byte[] byArray = new byte[]{(byte)n2};
            this.write(byArray, 0, 1);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            AnsiByteConsumer ansiByteConsumer = this.sink;
            synchronized (ansiByteConsumer) {
                this.sink.consume(new Buffer(byArray, n2, n3));
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

