/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Size64;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.AbstractFloatList;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatComparator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatComparators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatListIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatSpliterators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.UnaryOperator;

public interface FloatList
extends FloatCollection,
Comparable<List<? extends Float>>,
List<Float> {
    @Override
    public FloatListIterator iterator();

    @Override
    default public FloatSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractFloatList.IndexBasedSpliterator(this, 0);
        }
        return FloatSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16720);
    }

    public FloatListIterator listIterator();

    public FloatListIterator listIterator(int var1);

    public FloatList subList(int var1, int var2);

    public void getElements(int var1, float[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(float[] fArray) {
        this.setElements(0, fArray);
    }

    default public void setElements(int n2, float[] fArray) {
        this.setElements(n2, fArray, 0, fArray.length);
    }

    default public void setElements(int n2, float[] fArray, int n3, int n4) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
        FloatArrays.ensureOffsetLength(fArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        FloatListIterator floatListIterator = this.listIterator(n2);
        int n5 = 0;
        while (n5 < n4) {
            floatListIterator.nextFloat();
            floatListIterator.set(fArray[n3 + n5++]);
        }
    }

    @Override
    public boolean add(float var1);

    @Override
    public void add(int var1, float var2);

    @Override
    @Deprecated
    default public void add(int n2, Float f2) {
        this.add(n2, f2.floatValue());
    }

    @Override
    public float set(int var1, float var2);

    default public void replaceAll(FloatUnaryOperator floatUnaryOperator) {
        FloatListIterator floatListIterator = this.listIterator();
        while (floatListIterator.hasNext()) {
            floatListIterator.set(floatUnaryOperator.apply(floatListIterator.nextFloat()));
        }
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Float> unaryOperator) {
        Objects.requireNonNull(unaryOperator);
        this.replaceAll(unaryOperator instanceof FloatUnaryOperator ? (FloatUnaryOperator)unaryOperator : unaryOperator::apply);
    }

    public float getFloat(int var1);

    public int indexOf(float var1);

    public int lastIndexOf(float var1);

    @Override
    @Deprecated
    default public boolean contains(Object object) {
        return FloatCollection.super.contains(object);
    }

    @Override
    @Deprecated
    default public Float get(int n2) {
        return Float.valueOf(this.getFloat(n2));
    }

    @Override
    @Deprecated
    default public int indexOf(Object object) {
        return this.indexOf(((Float)object).floatValue());
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object object) {
        return this.lastIndexOf(((Float)object).floatValue());
    }

    @Override
    @Deprecated
    default public boolean add(Float f2) {
        return this.add(f2.floatValue());
    }

    public float removeFloat(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object object) {
        return FloatCollection.super.remove(object);
    }

    @Override
    @Deprecated
    default public Float remove(int n2) {
        return Float.valueOf(this.removeFloat(n2));
    }

    @Override
    @Deprecated
    default public Float set(int n2, Float f2) {
        return Float.valueOf(this.set(n2, f2.floatValue()));
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Float> comparator) {
        this.sort(FloatComparators.asFloatComparator(comparator));
    }

    default public void sort(FloatComparator floatComparator) {
        float[] fArray = this.toFloatArray();
        if (floatComparator == null) {
            FloatArrays.stableSort(fArray);
        } else {
            FloatArrays.stableSort(fArray, floatComparator);
        }
        this.setElements(fArray);
    }
}

