/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Arrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Hash;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleComparator;
import java.io.Serializable;

public final class DoubleArrays {
    public static final double[] EMPTY_ARRAY = new double[0];
    public static final double[] DEFAULT_EMPTY_ARRAY = new double[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<double[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(double[] dArray, int n2, int n3) {
        Arrays.ensureOffsetLength(dArray.length, n2, n3);
    }

    private static void insertionSort(double[] dArray, int n2, int n3, DoubleComparator doubleComparator) {
        int n4 = n2;
        while (++n4 < n3) {
            double d2 = dArray[n4];
            int n5 = n4;
            double d3 = dArray[n5 - 1];
            while (doubleComparator.compare(d2, d3) < 0) {
                dArray[n5] = d3;
                if (n2 == n5 - 1) {
                    --n5;
                    break;
                }
                d3 = dArray[--n5 - 1];
            }
            dArray[n5] = d2;
        }
    }

    private static void insertionSort(double[] dArray, int n2, int n3) {
        int n4 = n2;
        while (++n4 < n3) {
            double d2 = dArray[n4];
            int n5 = n4;
            double d3 = dArray[n5 - 1];
            while (Double.compare(d2, d3) < 0) {
                dArray[n5] = d3;
                if (n2 == n5 - 1) {
                    --n5;
                    break;
                }
                d3 = dArray[--n5 - 1];
            }
            dArray[n5] = d2;
        }
    }

    public static void mergeSort(double[] dArray, int n2, int n3, double[] dArray2) {
        int n4 = n3 - n2;
        if (n4 < 16) {
            DoubleArrays.insertionSort(dArray, n2, n3);
            return;
        }
        if (dArray2 == null) {
            dArray2 = java.util.Arrays.copyOf(dArray, n3);
        }
        int n5 = n2 + n3 >>> 1;
        DoubleArrays.mergeSort(dArray2, n2, n5, dArray);
        DoubleArrays.mergeSort(dArray2, n5, n3, dArray);
        if (Double.compare(dArray2[n5 - 1], dArray2[n5]) <= 0) {
            System.arraycopy(dArray2, n2, dArray, n2, n4);
            return;
        }
        int n6 = n2;
        int n7 = n5;
        for (int i2 = n2; i2 < n3; ++i2) {
            dArray[i2] = n7 >= n3 || n6 < n5 && Double.compare(dArray2[n6], dArray2[n7]) <= 0 ? dArray2[n6++] : dArray2[n7++];
        }
    }

    public static void mergeSort(double[] dArray, int n2, int n3) {
        DoubleArrays.mergeSort(dArray, n2, n3, (double[])null);
    }

    public static void mergeSort(double[] dArray, int n2, int n3, DoubleComparator doubleComparator, double[] dArray2) {
        int n4 = n3 - n2;
        if (n4 < 16) {
            DoubleArrays.insertionSort(dArray, n2, n3, doubleComparator);
            return;
        }
        if (dArray2 == null) {
            dArray2 = java.util.Arrays.copyOf(dArray, n3);
        }
        int n5 = n2 + n3 >>> 1;
        DoubleArrays.mergeSort(dArray2, n2, n5, doubleComparator, dArray);
        DoubleArrays.mergeSort(dArray2, n5, n3, doubleComparator, dArray);
        if (doubleComparator.compare(dArray2[n5 - 1], dArray2[n5]) <= 0) {
            System.arraycopy(dArray2, n2, dArray, n2, n4);
            return;
        }
        int n6 = n2;
        int n7 = n5;
        for (int i2 = n2; i2 < n3; ++i2) {
            dArray[i2] = n7 >= n3 || n6 < n5 && doubleComparator.compare(dArray2[n6], dArray2[n7]) <= 0 ? dArray2[n6++] : dArray2[n7++];
        }
    }

    public static void mergeSort(double[] dArray, int n2, int n3, DoubleComparator doubleComparator) {
        DoubleArrays.mergeSort(dArray, n2, n3, doubleComparator, null);
    }

    public static void stableSort(double[] dArray, int n2, int n3) {
        DoubleArrays.mergeSort(dArray, n2, n3);
    }

    public static void stableSort(double[] dArray) {
        DoubleArrays.stableSort(dArray, 0, dArray.length);
    }

    public static void stableSort(double[] dArray, int n2, int n3, DoubleComparator doubleComparator) {
        DoubleArrays.mergeSort(dArray, n2, n3, doubleComparator);
    }

    public static void stableSort(double[] dArray, DoubleComparator doubleComparator) {
        DoubleArrays.stableSort(dArray, 0, dArray.length, doubleComparator);
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int n2, int n3, int n4) {
            this.offset = n2;
            this.length = n3;
            this.level = n4;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<double[]>,
    Serializable {
        private ArrayHashStrategy() {
        }
    }
}

