/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleIterators;
import java.util.AbstractCollection;
import java.util.Collection;

public abstract class AbstractDoubleCollection
extends AbstractCollection<Double>
implements DoubleCollection {
    protected AbstractDoubleCollection() {
    }

    @Override
    public abstract DoubleIterator iterator();

    @Override
    public boolean add(double d2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(double d2) {
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            if (d2 != doubleIterator.nextDouble()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(double d2) {
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            if (d2 != doubleIterator.nextDouble()) continue;
            doubleIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Double d2) {
        return DoubleCollection.super.add(d2);
    }

    @Override
    @Deprecated
    public boolean contains(Object object) {
        return DoubleCollection.super.contains(object);
    }

    @Override
    @Deprecated
    public boolean remove(Object object) {
        return DoubleCollection.super.remove(object);
    }

    @Override
    public double[] toDoubleArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return DoubleArrays.EMPTY_ARRAY;
        }
        double[] dArray = new double[n2];
        DoubleIterators.unwrap(this.iterator(), dArray);
        return dArray;
    }

    public boolean addAll(DoubleCollection doubleCollection) {
        boolean bl2 = false;
        DoubleIterator doubleIterator = doubleCollection.iterator();
        while (doubleIterator.hasNext()) {
            if (!this.add(doubleIterator.nextDouble())) continue;
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean addAll(Collection<? extends Double> collection) {
        if (collection instanceof DoubleCollection) {
            return this.addAll((DoubleCollection)collection);
        }
        return super.addAll(collection);
    }

    public boolean containsAll(DoubleCollection doubleCollection) {
        DoubleIterator doubleIterator = doubleCollection.iterator();
        while (doubleIterator.hasNext()) {
            if (this.contains(doubleIterator.nextDouble())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection instanceof DoubleCollection) {
            return this.containsAll((DoubleCollection)collection);
        }
        return super.containsAll(collection);
    }

    public boolean removeAll(DoubleCollection doubleCollection) {
        boolean bl2 = false;
        DoubleIterator doubleIterator = doubleCollection.iterator();
        while (doubleIterator.hasNext()) {
            if (!this.rem(doubleIterator.nextDouble())) continue;
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection instanceof DoubleCollection) {
            return this.removeAll((DoubleCollection)collection);
        }
        return super.removeAll(collection);
    }

    public boolean retainAll(DoubleCollection doubleCollection) {
        boolean bl2 = false;
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            if (doubleCollection.contains(doubleIterator.nextDouble())) continue;
            doubleIterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection instanceof DoubleCollection) {
            return this.retainAll((DoubleCollection)collection);
        }
        return super.retainAll(collection);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        DoubleIterator doubleIterator = this.iterator();
        int n2 = this.size();
        boolean bl2 = true;
        stringBuilder.append("{");
        while (n2-- != 0) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            double d2 = doubleIterator.nextDouble();
            stringBuilder.append(String.valueOf(d2));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

