/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.AbstractCharSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharComparator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharConsumer;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;

public final class CharSpliterators {
    public static final EmptySpliterator EMPTY_SPLITERATOR = new EmptySpliterator();

    public static CharSpliterator wrap(char[] cArray, int n2, int n3, int n4) {
        CharArrays.ensureOffsetLength(cArray, n2, n3);
        return new ArraySpliterator(cArray, n2, n3, n4);
    }

    public static CharSpliterator wrapPreSorted(char[] cArray, int n2, int n3, int n4, CharComparator charComparator) {
        CharArrays.ensureOffsetLength(cArray, n2, n3);
        return new ArraySpliteratorWithComparator(cArray, n2, n3, n4, charComparator);
    }

    public static CharSpliterator asSpliterator(CharIterator charIterator, long l2, int n2) {
        return new SpliteratorFromIterator(charIterator, l2, n2);
    }

    public static CharSpliterator asSpliteratorFromSorted(CharIterator charIterator, long l2, int n2, CharComparator charComparator) {
        return new SpliteratorFromIteratorWithComparator(charIterator, l2, n2, charComparator);
    }

    public static CharSpliterator asSpliteratorUnknownSize(CharIterator charIterator, int n2) {
        return new SpliteratorFromIterator(charIterator, n2);
    }

    private static class ArraySpliterator
    implements CharSpliterator {
        final char[] array;
        private final int offset;
        private int length;
        private int curr;
        final int characteristics;

        public ArraySpliterator(char[] cArray, int n2, int n3, int n4) {
            this.array = cArray;
            this.offset = n2;
            this.length = n3;
            this.characteristics = 0x4150 | n4;
        }

        @Override
        public boolean tryAdvance(CharConsumer charConsumer) {
            if (this.curr >= this.length) {
                return false;
            }
            Objects.requireNonNull(charConsumer);
            charConsumer.accept(this.array[this.offset + this.curr++]);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.length - this.curr;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected ArraySpliterator makeForSplit(int n2, int n3) {
            return new ArraySpliterator(this.array, n2, n3, this.characteristics);
        }

        @Override
        public CharSpliterator trySplit() {
            int n2 = this.length - this.curr >> 1;
            if (n2 <= 1) {
                return null;
            }
            int n3 = this.curr + n2;
            int n4 = this.offset + this.curr;
            this.curr = n3;
            return this.makeForSplit(n4, n2);
        }

        @Override
        public void forEachRemaining(CharConsumer charConsumer) {
            Objects.requireNonNull(charConsumer);
            char[] cArray = this.array;
            while (this.curr < this.length) {
                charConsumer.accept(cArray[this.offset + this.curr]);
                ++this.curr;
            }
        }
    }

    private static class ArraySpliteratorWithComparator
    extends ArraySpliterator {
        private final CharComparator comparator;

        public ArraySpliteratorWithComparator(char[] cArray, int n2, int n3, int n4, CharComparator charComparator) {
            super(cArray, n2, n3, n4 | 0x14);
            this.comparator = charComparator;
        }

        @Override
        protected ArraySpliteratorWithComparator makeForSplit(int n2, int n3) {
            return new ArraySpliteratorWithComparator(this.array, n2, n3, this.characteristics, this.comparator);
        }

        @Override
        public CharComparator getComparator() {
            return this.comparator;
        }
    }

    private static class SpliteratorFromIterator
    implements CharSpliterator {
        private final CharIterator iter;
        final int characteristics;
        private final boolean knownSize;
        private long size = Long.MAX_VALUE;
        private int nextBatchSize = 1024;
        private CharSpliterator delegate = null;

        SpliteratorFromIterator(CharIterator charIterator, int n2) {
            this.iter = charIterator;
            this.characteristics = 0x100 | n2;
            this.knownSize = false;
        }

        SpliteratorFromIterator(CharIterator charIterator, long l2, int n2) {
            this.iter = charIterator;
            this.knownSize = true;
            this.size = l2;
            this.characteristics = (n2 & 0x1000) != 0 ? 0x100 | n2 : 0x4140 | n2;
        }

        @Override
        public boolean tryAdvance(CharConsumer charConsumer) {
            if (this.delegate != null) {
                boolean bl2 = this.delegate.tryAdvance(charConsumer);
                if (!bl2) {
                    this.delegate = null;
                }
                return bl2;
            }
            if (!this.iter.hasNext()) {
                return false;
            }
            --this.size;
            charConsumer.accept(this.iter.nextChar());
            return true;
        }

        @Override
        public void forEachRemaining(CharConsumer charConsumer) {
            if (this.delegate != null) {
                this.delegate.forEachRemaining(charConsumer);
                this.delegate = null;
            }
            this.iter.forEachRemaining(charConsumer);
            this.size = 0L;
        }

        @Override
        public long estimateSize() {
            if (this.delegate != null) {
                return this.delegate.estimateSize();
            }
            if (!this.iter.hasNext()) {
                return 0L;
            }
            return this.knownSize && this.size >= 0L ? this.size : Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected CharSpliterator makeForSplit(char[] cArray, int n2) {
            return CharSpliterators.wrap(cArray, 0, n2, this.characteristics);
        }

        @Override
        public CharSpliterator trySplit() {
            if (!this.iter.hasNext()) {
                return null;
            }
            int n2 = this.knownSize && this.size > 0L ? (int)Math.min((long)this.nextBatchSize, this.size) : this.nextBatchSize;
            char[] cArray = new char[n2];
            int n3 = 0;
            while (n3 < n2 && this.iter.hasNext()) {
                cArray[n3++] = this.iter.nextChar();
                --this.size;
            }
            if (n2 < this.nextBatchSize && this.iter.hasNext()) {
                cArray = Arrays.copyOf(cArray, this.nextBatchSize);
                while (this.iter.hasNext() && n3 < this.nextBatchSize) {
                    cArray[n3++] = this.iter.nextChar();
                    --this.size;
                }
            }
            this.nextBatchSize = Math.min(0x2000000, this.nextBatchSize + 1024);
            CharSpliterator charSpliterator = this.makeForSplit(cArray, n3);
            if (!this.iter.hasNext()) {
                this.delegate = charSpliterator;
                return charSpliterator.trySplit();
            }
            return charSpliterator;
        }
    }

    private static class SpliteratorFromIteratorWithComparator
    extends SpliteratorFromIterator {
        private final CharComparator comparator;

        SpliteratorFromIteratorWithComparator(CharIterator charIterator, long l2, int n2, CharComparator charComparator) {
            super(charIterator, l2, n2 | 0x14);
            this.comparator = charComparator;
        }

        @Override
        public CharComparator getComparator() {
            return this.comparator;
        }

        @Override
        protected CharSpliterator makeForSplit(char[] cArray, int n2) {
            return CharSpliterators.wrapPreSorted(cArray, 0, n2, this.characteristics, this.comparator);
        }
    }

    public static class EmptySpliterator
    implements CharSpliterator,
    Serializable,
    Cloneable {
        protected EmptySpliterator() {
        }

        @Override
        public boolean tryAdvance(CharConsumer charConsumer) {
            return false;
        }

        @Override
        @Deprecated
        public boolean tryAdvance(Consumer<? super Character> consumer) {
            return false;
        }

        @Override
        public CharSpliterator trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 16448;
        }

        @Override
        public void forEachRemaining(CharConsumer charConsumer) {
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Character> consumer) {
        }

        public Object clone() {
            return EMPTY_SPLITERATOR;
        }
    }

    public static abstract class LateBindingSizeIndexBasedSpliterator
    extends AbstractIndexBasedSpliterator {
        protected int maxPos = -1;
        private boolean maxPosFixed;

        protected LateBindingSizeIndexBasedSpliterator(int n2) {
            super(n2);
            this.maxPosFixed = false;
        }

        protected LateBindingSizeIndexBasedSpliterator(int n2, int n3) {
            super(n2);
            this.maxPos = n3;
            this.maxPosFixed = true;
        }

        protected abstract int getMaxPosFromBackingStore();

        @Override
        protected final int getMaxPos() {
            return this.maxPosFixed ? this.maxPos : this.getMaxPosFromBackingStore();
        }

        @Override
        public CharSpliterator trySplit() {
            CharSpliterator charSpliterator = super.trySplit();
            if (!this.maxPosFixed && charSpliterator != null) {
                this.maxPos = this.getMaxPosFromBackingStore();
                this.maxPosFixed = true;
            }
            return charSpliterator;
        }
    }

    public static abstract class AbstractIndexBasedSpliterator
    extends AbstractCharSpliterator {
        protected int pos;

        protected AbstractIndexBasedSpliterator(int n2) {
            this.pos = n2;
        }

        protected abstract char get(int var1);

        protected abstract int getMaxPos();

        protected abstract CharSpliterator makeForSplit(int var1, int var2);

        protected int computeSplitPoint() {
            return this.pos + (this.getMaxPos() - this.pos) / 2;
        }

        private void splitPointCheck(int n2, int n3) {
            if (n2 < this.pos || n2 > n3) {
                throw new IndexOutOfBoundsException("splitPoint " + n2 + " outside of range of current position " + this.pos + " and range end " + n3);
            }
        }

        @Override
        public int characteristics() {
            return 16720;
        }

        @Override
        public long estimateSize() {
            return (long)this.getMaxPos() - (long)this.pos;
        }

        @Override
        public boolean tryAdvance(CharConsumer charConsumer) {
            if (this.pos >= this.getMaxPos()) {
                return false;
            }
            charConsumer.accept(this.get(this.pos++));
            return true;
        }

        @Override
        public void forEachRemaining(CharConsumer charConsumer) {
            int n2 = this.getMaxPos();
            while (this.pos < n2) {
                charConsumer.accept(this.get(this.pos));
                ++this.pos;
            }
        }

        @Override
        public CharSpliterator trySplit() {
            int n2 = this.getMaxPos();
            int n3 = this.computeSplitPoint();
            if (n3 == this.pos || n3 == n2) {
                return null;
            }
            this.splitPointCheck(n3, n2);
            int n4 = this.pos;
            CharSpliterator charSpliterator = this.makeForSplit(n4, n3);
            if (charSpliterator != null) {
                this.pos = n3;
            }
            return charSpliterator;
        }
    }
}

